/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.swt.NewtCanvasSWT;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.PointImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2NewtCanvasSWT
extends UITestCase {
    static int screenIdx = 0;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static DimensionImmutable rwsize;
    static long duration;
    static boolean opaque;
    static int forceAlpha;
    static boolean fullscreen;
    static boolean pmvUseBackingArray;
    static int swapInterval;
    static boolean showFPS;
    static int loops;
    static boolean loop_shutdown;
    static boolean forceES2;
    static boolean forceGL3;
    static boolean mainRun;
    static boolean exclusiveContext;
    Display display = null;
    Shell shell = null;
    Composite composite = null;
    com.jogamp.newt.Display swtNewtDisplay = null;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    @Before
    public void init() {
        SWTAccessor.invoke((boolean)true, (Runnable)new Runnable(){

            @Override
            public void run() {
                TestGearsES2NewtCanvasSWT.this.display = new Display();
                Assert.assertNotNull((Object)TestGearsES2NewtCanvasSWT.this.display);
            }
        });
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestGearsES2NewtCanvasSWT.this.shell = new Shell(TestGearsES2NewtCanvasSWT.this.display);
                Assert.assertNotNull((Object)TestGearsES2NewtCanvasSWT.this.shell);
                TestGearsES2NewtCanvasSWT.this.shell.setLayout((Layout)new FillLayout());
                TestGearsES2NewtCanvasSWT.this.composite = new Composite((Composite)TestGearsES2NewtCanvasSWT.this.shell, 0);
                TestGearsES2NewtCanvasSWT.this.composite.setLayout((Layout)new FillLayout());
                Assert.assertNotNull((Object)TestGearsES2NewtCanvasSWT.this.composite);
            }
        });
        this.swtNewtDisplay = NewtFactory.createDisplay(null, (boolean)false);
    }

    @After
    public void release() {
        Assert.assertNotNull((Object)this.display);
        Assert.assertNotNull((Object)this.shell);
        Assert.assertNotNull((Object)this.composite);
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestGearsES2NewtCanvasSWT.this.composite.dispose();
                    TestGearsES2NewtCanvasSWT.this.shell.dispose();
                }
            });
            SWTAccessor.invoke((boolean)true, (Runnable)new Runnable(){

                @Override
                public void run() {
                    TestGearsES2NewtCanvasSWT.this.display.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        this.swtNewtDisplay = null;
        this.display = null;
        this.shell = null;
        this.composite = null;
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException, InvocationTargetException {
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        Screen screen = NewtFactory.createScreen((com.jogamp.newt.Display)this.swtNewtDisplay, (int)screenIdx);
        final GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        GearsES2 gearsES2 = new GearsES2(swapInterval);
        gearsES2.setPMVUseBackingArray(pmvUseBackingArray);
        gLWindow.addGLEventListener((GLEventListener)gearsES2);
        Animator animator = new Animator();
        animator.setModeBits(false, 1);
        animator.setExclusiveContext(exclusiveContext);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }

            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }
        });
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'f') {
                    new Thread(){

                        @Override
                        public void run() {
                            Thread thread = gLWindow.setExclusiveContextThread(null);
                            System.err.println("[set fullscreen  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setFullscreen(!gLWindow.isFullscreen());
                            System.err.println("[set fullscreen post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setExclusiveContextThread(thread);
                        }
                    }.start();
                }
            }
        });
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        Assert.assertTrue((boolean)animator.isStarted());
        Assert.assertTrue((boolean)animator.isAnimating());
        Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
        NewtCanvasSWT newtCanvasSWT = NewtCanvasSWT.create((Composite)this.composite, (int)0, (Window)gLWindow);
        Assert.assertNotNull((Object)newtCanvasSWT);
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                TestGearsES2NewtCanvasSWT.this.shell.setText(TestGearsES2NewtCanvasSWT.this.getSimpleTestName("."));
                TestGearsES2NewtCanvasSWT.this.shell.setSize(wsize.getWidth(), wsize.getHeight());
                if (null != wpos) {
                    TestGearsES2NewtCanvasSWT.this.shell.setLocation(wpos.getX(), wpos.getY());
                }
                TestGearsES2NewtCanvasSWT.this.shell.open();
            }
        });
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        if (null != rwsize) {
            for (int i = 0; i < 50; ++i) {
                if (this.display.readAndDispatch()) continue;
                Thread.sleep(10L);
            }
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    TestGearsES2NewtCanvasSWT.this.shell.setSize(rwsize.getWidth(), rwsize.getHeight());
                }
            });
            System.err.println("window resize pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        }
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            if (this.display.readAndDispatch()) continue;
            Thread.sleep(10L);
        }
        Assert.assertEquals((Object)(exclusiveContext ? animator.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        Assert.assertEquals(null, (Object)gLWindow.getExclusiveContextThread());
        newtCanvasSWT.dispose();
        gLWindow.destroy();
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, false));
    }

    @Test
    public void test01GL2ES2() throws InterruptedException, InvocationTargetException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setBackgroundOpaque(opaque);
            if (-1 < forceAlpha) {
                gLCapabilities.setAlphaBits(forceAlpha);
            }
            this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02GL3() throws InterruptedException, InvocationTargetException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities);
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-translucent")) {
                opaque = false;
                continue;
            }
            if (stringArray[i].equals("-forceAlpha")) {
                forceAlpha = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-fullscreen")) {
                fullscreen = true;
                continue;
            }
            if (stringArray[i].equals("-pmvDirect")) {
                pmvUseBackingArray = false;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-screen")) {
                screenIdx = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (!stringArray[i].equals("-loop-shutdown")) continue;
            loop_shutdown = true;
        }
        wsize = new Dimension(n3, n4);
        if (0 < n5 && 0 < n6) {
            rwsize = new Dimension(n5, n6);
        }
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("screen " + screenIdx);
        System.err.println("translucent " + !opaque);
        System.err.println("forceAlpha " + forceAlpha);
        System.err.println("fullscreen " + fullscreen);
        System.err.println("pmvDirect " + !pmvUseBackingArray);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        JUnitCore.main((String[])new String[]{TestGearsES2NewtCanvasSWT.class.getName()});
    }

    static {
        rwsize = null;
        duration = 500L;
        opaque = true;
        forceAlpha = -1;
        fullscreen = false;
        pmvUseBackingArray = true;
        swapInterval = 1;
        showFPS = false;
        loops = 1;
        loop_shutdown = false;
        forceES2 = false;
        forceGL3 = false;
        mainRun = false;
        exclusiveContext = false;
    }
}

