/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.newt;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.newt.parenting.NewtAWTReparentingKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.PointImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2NewtCanvasAWT
extends UITestCase {
    static int screenIdx = 0;
    static PointImmutable wpos;
    static DimensionImmutable wsize;
    static DimensionImmutable rwsize;
    static FrameLayout frameLayout;
    static ResizeBy resizeBy;
    static long duration;
    static boolean opaque;
    static int forceAlpha;
    static boolean fullscreen;
    static boolean pmvUseBackingArray;
    static int swapInterval;
    static boolean showFPS;
    static int loops;
    static boolean loop_shutdown;
    static boolean shallUseOffscreenFBOLayer;
    static boolean forceES2;
    static boolean forceGL3;
    static boolean mainRun;
    static boolean exclusiveContext;
    static boolean useAnimator;

    @BeforeClass
    public static void initClass() {
        if (null == wsize) {
            wsize = new javax.media.nativewindow.util.Dimension(640, 480);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    static void setGLWindowSize(final Frame frame, GLWindow gLWindow, DimensionImmutable dimensionImmutable) {
        try {
            gLWindow.setSize(dimensionImmutable.getWidth(), dimensionImmutable.getHeight());
            if (null != frame) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        frame.pack();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void setComponentSize(final Frame frame, final Component component, final DimensionImmutable dimensionImmutable) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dimension dimension = new Dimension(dimensionImmutable.getWidth(), dimensionImmutable.getHeight());
                    component.setMinimumSize(dimension);
                    component.setPreferredSize(dimension);
                    component.setSize(dimension);
                    if (null != frame) {
                        frame.pack();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void setFrameSize(final Frame frame, final boolean bl, final DimensionImmutable dimensionImmutable) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Dimension dimension = new Dimension(dimensionImmutable.getWidth(), dimensionImmutable.getHeight());
                    frame.setSize(dimension);
                    if (bl) {
                        frame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void setSize(ResizeBy resizeBy, Frame frame, boolean bl, Component component, GLWindow gLWindow, DimensionImmutable dimensionImmutable) {
        switch (resizeBy) {
            case GLWindow: {
                TestGearsES2NewtCanvasAWT.setGLWindowSize(bl ? frame : null, gLWindow, dimensionImmutable);
                break;
            }
            case Component: {
                TestGearsES2NewtCanvasAWT.setComponentSize(bl ? frame : null, component, dimensionImmutable);
                break;
            }
            case Frame: {
                TestGearsES2NewtCanvasAWT.setFrameSize(frame, bl, dimensionImmutable);
            }
        }
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, final ResizeBy resizeBy, FrameLayout frameLayout) throws InterruptedException, InvocationTargetException {
        long l;
        Container container;
        Object object;
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)display, (int)screenIdx);
        final GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        if (shallUseOffscreenFBOLayer) {
            newtCanvasAWT.setShallUseOffscreenLayer(true);
        }
        final Frame frame = new Frame("AWT Parent Frame");
        TestGearsES2NewtCanvasAWT.setSize(resizeBy, frame, false, (Component)newtCanvasAWT, gLWindow, wsize);
        switch (frameLayout) {
            case None: {
                frame.add((Component)newtCanvasAWT);
                break;
            }
            case TextOnBottom: {
                object = new TextArea(2, 20);
                ((TextArea)object).append("0123456789");
                ((TextArea)object).append(Platform.getNewline());
                ((TextArea)object).append("Some Text");
                ((TextArea)object).append(Platform.getNewline());
                frame.setLayout(new BorderLayout());
                frame.add((Component)object, "South");
                frame.add((Component)newtCanvasAWT, "Center");
                break;
            }
            case BorderBottom: {
                frame.setLayout(new BorderLayout());
                frame.add((Component)newtCanvasAWT, "South");
                break;
            }
            case BorderBottom2: {
                frame.setLayout(new BorderLayout());
                frame.add((Component)newtCanvasAWT, "South");
                frame.add((Component)new Button("North"), "North");
                break;
            }
            case BorderCenter: {
                frame.setLayout(new BorderLayout());
                frame.add((Component)newtCanvasAWT, "Center");
                break;
            }
            case BorderCenterSurrounded: {
                frame.setLayout(new BorderLayout());
                frame.add((Component)new Button("NORTH"), "North");
                frame.add((Component)new Button("SOUTH"), "South");
                frame.add((Component)new Button("EAST"), "East");
                frame.add((Component)new Button("WEST"), "West");
                frame.add((Component)newtCanvasAWT, "Center");
                break;
            }
            case DoubleBorderCenterSurrounded: {
                container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)new Button("north"), "North");
                container.add((Component)new Button("south"), "South");
                container.add((Component)new Button("east"), "East");
                container.add((Component)new Button("west"), "West");
                container.add((Component)newtCanvasAWT, "Center");
                frame.setLayout(new BorderLayout());
                frame.add((Component)new Button("NORTH"), "North");
                frame.add((Component)new Button("SOUTH"), "South");
                frame.add((Component)new Button("EAST"), "East");
                frame.add((Component)new Button("WEST"), "West");
                frame.add((Component)container, "Center");
            }
        }
        frame.setTitle("Gears NewtCanvasAWT Test (translucent " + !gLCapabilitiesImmutable.isBackgroundOpaque() + "), swapInterval " + swapInterval + ", size " + wsize + ", pos " + wpos);
        object = new GearsES2(swapInterval);
        ((GearsES2)object).setPMVUseBackingArray(pmvUseBackingArray);
        gLWindow.addGLEventListener((GLEventListener)object);
        Object object2 = container = useAnimator ? new Animator() : null;
        if (useAnimator) {
            container.setModeBits(false, 1);
            container.setExclusiveContext(exclusiveContext);
        }
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }

            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }
        });
        gLWindow.addKeyListener((KeyListener)new NewtAWTReparentingKeyAdapter(frame, newtCanvasAWT, gLWindow, quitAdapter));
        if (useAnimator) {
            container.add((GLAutoDrawable)gLWindow);
            container.start();
            Assert.assertTrue((boolean)container.isStarted());
            Assert.assertTrue((boolean)container.isAnimating());
            Assert.assertEquals((Object)(exclusiveContext ? container.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (ResizeBy.Frame == resizeBy) {
                    frame.validate();
                } else {
                    frame.pack();
                }
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(frame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, true));
        if (useAnimator) {
            container.setUpdateFPSFrames(60, showFPS ? System.err : null);
        }
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        if (null != rwsize) {
            Thread.sleep(500L);
            TestGearsES2NewtCanvasAWT.setSize(resizeBy, frame, true, (Component)newtCanvasAWT, gLWindow, rwsize);
            System.err.println("window resize " + rwsize + " -> pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        }
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        if (useAnimator) {
            Assert.assertEquals((Object)(exclusiveContext ? container.getThread() : null), (Object)gLWindow.getExclusiveContextThread());
            container.stop();
            Assert.assertFalse((boolean)container.isAnimating());
            Assert.assertFalse((boolean)container.isStarted());
        }
        Assert.assertEquals(null, (Object)gLWindow.getExclusiveContextThread());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, false));
    }

    @Test
    public void test01GL2ES2() throws InterruptedException, InvocationTargetException {
        for (int i = 1; i <= loops; ++i) {
            System.err.println("Loop " + i + "/" + loops);
            GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setBackgroundOpaque(opaque);
            if (-1 < forceAlpha) {
                gLCapabilities.setAlphaBits(forceAlpha);
            }
            this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, resizeBy, frameLayout);
            if (!loop_shutdown) continue;
            GLProfile.shutdown();
        }
    }

    @Test
    public void test02GL3() throws InterruptedException, InvocationTargetException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, resizeBy, frameLayout);
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        int n = 0;
        int n2 = 0;
        int n3 = 640;
        int n4 = 480;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-layout")) {
                frameLayout = FrameLayout.valueOf(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-resizeBy")) {
                resizeBy = ResizeBy.valueOf(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-translucent")) {
                opaque = false;
                continue;
            }
            if (stringArray[i].equals("-forceAlpha")) {
                forceAlpha = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-fullscreen")) {
                fullscreen = true;
                continue;
            }
            if (stringArray[i].equals("-pmvDirect")) {
                pmvUseBackingArray = false;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-layeredFBO")) {
                shallUseOffscreenFBOLayer = true;
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-x")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-y")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-screen")) {
                screenIdx = MiscUtils.atoi(stringArray[++i], 0);
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                loops = MiscUtils.atoi(stringArray[++i], 1);
                continue;
            }
            if (!stringArray[i].equals("-loop-shutdown")) continue;
            loop_shutdown = true;
        }
        wsize = new javax.media.nativewindow.util.Dimension(n3, n4);
        if (0 < n5 && 0 < n6) {
            rwsize = new javax.media.nativewindow.util.Dimension(n5, n6);
        }
        if (bl) {
            wpos = new Point(n, n2);
        }
        System.err.println("frameLayout " + (Object)((Object)frameLayout));
        System.err.println("resizeBy " + (Object)((Object)resizeBy));
        System.err.println("position " + wpos);
        System.err.println("size " + wsize);
        System.err.println("resize " + rwsize);
        System.err.println("screen " + screenIdx);
        System.err.println("translucent " + !opaque);
        System.err.println("forceAlpha " + forceAlpha);
        System.err.println("fullscreen " + fullscreen);
        System.err.println("pmvDirect " + !pmvUseBackingArray);
        System.err.println("loops " + loops);
        System.err.println("loop shutdown " + loop_shutdown);
        System.err.println("shallUseOffscreenFBOLayer     " + shallUseOffscreenFBOLayer);
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        System.err.println("useAnimator " + useAnimator);
        JUnitCore.main((String[])new String[]{TestGearsES2NewtCanvasAWT.class.getName()});
    }

    static {
        rwsize = null;
        frameLayout = FrameLayout.None;
        resizeBy = ResizeBy.Component;
        duration = 500L;
        opaque = true;
        forceAlpha = -1;
        fullscreen = false;
        pmvUseBackingArray = true;
        swapInterval = 1;
        showFPS = false;
        loops = 1;
        loop_shutdown = false;
        shallUseOffscreenFBOLayer = false;
        forceES2 = false;
        forceGL3 = false;
        mainRun = false;
        exclusiveContext = false;
        useAnimator = true;
    }

    public static enum ResizeBy {
        GLWindow,
        Component,
        Frame;

    }

    public static enum FrameLayout {
        None,
        TextOnBottom,
        BorderBottom,
        BorderBottom2,
        BorderCenter,
        BorderCenterSurrounded,
        DoubleBorderCenterSurrounded;

    }
}

