/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.awt;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGearsES2AWT
extends UITestCase {
    static long duration = 500L;
    static int width;
    static int height;
    static FrameLayout frameLayout;
    static ResizeBy resizeBy;
    static boolean forceES2;
    static boolean forceGL3;
    static boolean mainRun;
    static boolean shallUseOffscreenFBOLayer;
    static boolean shallUseOffscreenPBufferLayer;
    static boolean useMSAA;
    static boolean useStencil;
    static boolean shutdownRemoveGLCanvas;
    static boolean shutdownDisposeFrame;
    static boolean shutdownSystemExit;
    static int swapInterval;
    static boolean exclusiveContext;
    static boolean useAnimator;
    static Thread awtEDT;
    static Dimension rwsize;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    awtEDT = Thread.currentThread();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.assertNull((Object)exception);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    static void setComponentSize(final Frame frame, final Component component, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    component.setMinimumSize(dimension);
                    component.setPreferredSize(dimension);
                    component.setSize(dimension);
                    if (null != frame) {
                        frame.pack();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void setFrameSize(final Frame frame, final boolean bl, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(dimension);
                    if (bl) {
                        frame.validate();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    static void setSize(ResizeBy resizeBy, Frame frame, boolean bl, Component component, Dimension dimension) {
        switch (resizeBy) {
            case Component: {
                TestGearsES2AWT.setComponentSize(bl ? frame : null, component, dimension);
                break;
            }
            case Frame: {
                TestGearsES2AWT.setFrameSize(frame, bl, dimension);
            }
        }
    }

    protected void runTestGL(GLCapabilities gLCapabilities, final ResizeBy resizeBy, FrameLayout frameLayout) throws InterruptedException, InvocationTargetException {
        long l;
        Animator animator;
        Object object;
        Object object2;
        final Frame frame = new Frame("GearsES2 AWT Test");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        TestGearsES2AWT.setSize(resizeBy, frame, false, (Component)gLCanvas, new Dimension(width, height));
        switch (frameLayout) {
            case None: {
                frame.add((Component)gLCanvas);
                break;
            }
            case TextOnBottom: {
                object2 = new TextArea(2, 20);
                ((TextArea)object2).append("0123456789");
                ((TextArea)object2).append(Platform.getNewline());
                ((TextArea)object2).append("Some Text");
                ((TextArea)object2).append(Platform.getNewline());
                frame.setLayout(new BorderLayout());
                frame.add((Component)object2, "South");
                frame.add((Component)gLCanvas, "Center");
                break;
            }
            case BorderCenterSurrounded: {
                frame.setLayout(new BorderLayout());
                frame.add((Component)new Button("NORTH"), "North");
                frame.add((Component)new Button("SOUTH"), "South");
                frame.add((Component)new Button("EAST"), "East");
                frame.add((Component)new Button("WEST"), "West");
                frame.add((Component)gLCanvas, "Center");
                break;
            }
            case DoubleBorderCenterSurrounded: {
                object = new Container();
                ((Container)object).setLayout(new BorderLayout());
                ((Container)object).add((Component)new Button("north"), "North");
                ((Container)object).add((Component)new Button("south"), "South");
                ((Container)object).add((Component)new Button("east"), "East");
                ((Container)object).add((Component)new Button("west"), "West");
                ((Container)object).add((Component)gLCanvas, "Center");
                frame.setLayout(new BorderLayout());
                frame.add((Component)new Button("NORTH"), "North");
                frame.add((Component)new Button("SOUTH"), "South");
                frame.add((Component)new Button("EAST"), "East");
                frame.add((Component)new Button("WEST"), "West");
                frame.add((Component)object, "Center");
            }
        }
        frame.setTitle("Gears AWT Test (translucent " + !gLCapabilities.isBackgroundOpaque() + "), swapInterval " + swapInterval);
        object2 = new GearsES2(swapInterval);
        gLCanvas.addGLEventListener((GLEventListener)object2);
        object = new UITestCase.SnapshotGLEventListener(this);
        gLCanvas.addGLEventListener((GLEventListener)object);
        Animator animator2 = animator = useAnimator ? new Animator((GLAutoDrawable)gLCanvas) : null;
        if (useAnimator && exclusiveContext) {
            animator.setExclusiveContext(awtEDT);
        }
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter)).addTo((Component)gLCanvas);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter)).addTo((Component)frame);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (ResizeBy.Frame == resizeBy) {
                    frame.validate();
                } else {
                    frame.pack();
                }
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(frame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        if (useAnimator) {
            animator.start();
            Assert.assertTrue((boolean)animator.isStarted());
            Assert.assertTrue((boolean)animator.isAnimating());
            Assert.assertEquals((Object)(exclusiveContext ? awtEDT : null), (Object)gLCanvas.getExclusiveContextThread());
            animator.setUpdateFPSFrames(60, System.err);
        }
        System.err.println("canvas pos/siz: " + gLCanvas.getX() + "/" + gLCanvas.getY() + " " + gLCanvas.getWidth() + "x" + gLCanvas.getHeight());
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        if (null != rwsize) {
            Thread.sleep(500L);
            TestGearsES2AWT.setSize(resizeBy, frame, true, (Component)gLCanvas, rwsize);
            System.err.println("window resize pos/siz: " + gLCanvas.getX() + "/" + gLCanvas.getY() + " " + gLCanvas.getWidth() + "x" + gLCanvas.getHeight());
        }
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull((Object)frame);
        Assert.assertNotNull((Object)gLCanvas);
        if (useAnimator) {
            Assert.assertNotNull((Object)animator);
            Assert.assertEquals((Object)(exclusiveContext ? awtEDT : null), (Object)gLCanvas.getExclusiveContextThread());
            animator.stop();
            Assert.assertFalse((boolean)animator.isAnimating());
            Assert.assertFalse((boolean)animator.isStarted());
            Assert.assertEquals(null, (Object)gLCanvas.getExclusiveContextThread());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (shutdownRemoveGLCanvas) {
                    frame.remove((Component)gLCanvas);
                }
                if (shutdownDisposeFrame) {
                    frame.dispose();
                }
                if (shutdownSystemExit) {
                    System.exit(0);
                }
            }
        });
    }

    @Test
    public void test01() throws InterruptedException, InvocationTargetException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get((String)"GL3") : (forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (useMSAA) {
            gLCapabilities.setNumSamples(4);
            gLCapabilities.setSampleBuffers(true);
        }
        if (useStencil) {
            gLCapabilities.setStencilBits(1);
        }
        if (shallUseOffscreenFBOLayer) {
            gLCapabilities.setOnscreen(false);
        }
        if (shallUseOffscreenPBufferLayer) {
            gLCapabilities.setPBuffer(true);
        }
        this.runTestGL(gLCapabilities, resizeBy, frameLayout);
    }

    @Test
    public void test02_GLES2() throws InterruptedException, InvocationTargetException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GLES2")) {
            System.err.println("GLES2 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GLES2");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, resizeBy, frameLayout);
    }

    @Test
    public void test03_GL3() throws InterruptedException, InvocationTargetException {
        if (mainRun) {
            return;
        }
        if (!GLProfile.isAvailable((String)"GL3")) {
            System.err.println("GL3 n/a");
            return;
        }
        GLProfile gLProfile = GLProfile.get((String)"GL3");
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, resizeBy, frameLayout);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-rwidth")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (stringArray[i].equals("-rheight")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-layout")) {
                frameLayout = FrameLayout.valueOf(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-resizeBy")) {
                resizeBy = ResizeBy.valueOf(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-noanim")) {
                useAnimator = false;
                continue;
            }
            if (stringArray[i].equals("-layeredFBO")) {
                shallUseOffscreenFBOLayer = true;
                continue;
            }
            if (stringArray[i].equals("-layeredPBuffer")) {
                shallUseOffscreenPBufferLayer = true;
                continue;
            }
            if (stringArray[i].equals("-msaa")) {
                useMSAA = true;
                continue;
            }
            if (stringArray[i].equals("-stencil")) {
                useStencil = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-shutdownKeepGLCanvas")) {
                shutdownRemoveGLCanvas = false;
                continue;
            }
            if (stringArray[i].equals("-shutdownKeepFrame")) {
                shutdownDisposeFrame = false;
                continue;
            }
            if (stringArray[i].equals("-shutdownKeepAll")) {
                shutdownRemoveGLCanvas = false;
                shutdownDisposeFrame = false;
                continue;
            }
            if (!stringArray[i].equals("-shutdownSystemExit")) continue;
            shutdownSystemExit = true;
        }
        if (0 < n && 0 < n2) {
            rwsize = new Dimension(n, n2);
        }
        System.err.println("resize " + rwsize);
        System.err.println("frameLayout " + (Object)((Object)frameLayout));
        System.err.println("resizeBy " + (Object)((Object)resizeBy));
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceGL3 " + forceGL3);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        System.err.println("useMSAA " + useMSAA);
        System.err.println("useAnimator " + useAnimator);
        System.err.println("shallUseOffscreenFBOLayer     " + shallUseOffscreenFBOLayer);
        System.err.println("shallUseOffscreenPBufferLayer " + shallUseOffscreenPBufferLayer);
        if (bl) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main((String[])new String[]{TestGearsES2AWT.class.getName()});
    }

    static {
        frameLayout = FrameLayout.None;
        resizeBy = ResizeBy.Component;
        forceES2 = false;
        forceGL3 = false;
        mainRun = false;
        shallUseOffscreenFBOLayer = false;
        shallUseOffscreenPBufferLayer = false;
        useMSAA = false;
        useStencil = false;
        shutdownRemoveGLCanvas = true;
        shutdownDisposeFrame = true;
        shutdownSystemExit = false;
        swapInterval = 1;
        exclusiveContext = false;
        useAnimator = true;
        rwsize = null;
    }

    public static enum ResizeBy {
        Component,
        Frame;

    }

    public static enum FrameLayout {
        None,
        TextOnBottom,
        BorderCenterSurrounded,
        DoubleBorderCenterSurrounded;

    }
}

