/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.InputStream;
import java.net.URLConnection;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class TextureSequenceDemo01
implements TextureSequence {
    TextureSequence.TextureFrame frame = null;
    int textureUnit = 0;
    protected int[] texMinMagFilter = new int[]{9728, 9728};
    protected int[] texWrapST = new int[]{33071, 33071};
    final boolean useBuildInTexLookup;
    private String textureLookupFunctionName = "myTexture2D";

    public TextureSequenceDemo01(boolean bl) {
        this.useBuildInTexLookup = bl;
    }

    public void initGLResources(GL gL) throws GLException {
        if (null == this.frame) {
            URLConnection uRLConnection;
            TextureData textureData = null;
            try {
                uRLConnection = IOUtil.getResource((String)"jogl/util/data/av/test-ntsc01-160x90.png", (ClassLoader)this.getClass().getClassLoader());
                if (null != uRLConnection) {
                    textureData = TextureIO.newTextureData((GLProfile)GLProfile.getGL2ES2(), (InputStream)uRLConnection.getInputStream(), (boolean)false, (String)"png");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            uRLConnection = new Texture(gL, textureData);
            this.frame = new TextureSequence.TextureFrame((Texture)uRLConnection);
            uRLConnection.bind(gL);
            gL.glTexParameteri(uRLConnection.getTarget(), 10241, this.texMinMagFilter[0]);
            gL.glTexParameteri(uRLConnection.getTarget(), 10240, this.texMinMagFilter[1]);
            gL.glTexParameteri(uRLConnection.getTarget(), 10242, this.texWrapST[0]);
            gL.glTexParameteri(uRLConnection.getTarget(), 10243, this.texWrapST[1]);
        }
    }

    public void destroyGLResources(GL gL) {
        if (null != this.frame) {
            this.frame.getTexture().destroy(gL);
            this.frame = null;
        }
    }

    public void destroy(GL gL) throws GLException {
        this.frame.getTexture().destroy(gL);
        this.frame = null;
    }

    public int getTextureUnit() {
        return this.textureUnit;
    }

    public int[] getTextureMinMagFilter() {
        return this.texMinMagFilter;
    }

    public int[] getTextureWrapST() {
        return this.texWrapST;
    }

    public TextureSequence.TextureFrame getLastTexture() throws IllegalStateException {
        return this.frame;
    }

    public TextureSequence.TextureFrame getNextTexture(GL gL) throws IllegalStateException {
        return this.frame;
    }

    public String getRequiredExtensionsShaderStub() throws IllegalStateException {
        return "// TextTextureSequence: No extensions required\n";
    }

    public String getTextureSampler2DType() throws IllegalStateException {
        return "sampler2D";
    }

    public String getTextureLookupFunctionName(String string) throws IllegalStateException {
        if (this.useBuildInTexLookup) {
            return "texture2D";
        }
        if (null != string && string.length() > 0) {
            this.textureLookupFunctionName = string;
        }
        return this.textureLookupFunctionName;
    }

    public String getTextureLookupFragmentShaderImpl() throws IllegalStateException {
        if (this.useBuildInTexLookup) {
            return "";
        }
        return "\nvec4 " + this.textureLookupFunctionName + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n" + "  return texture2D(image, texCoord);\n" + "}\n\n";
    }
}

