/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug816OSXCALayerPos03aB729AWT
extends UITestCase {
    static long duration = 1600L;
    static int width = 640;
    static int height = 480;

    @Test
    public void test() throws InterruptedException, InvocationTargetException {
        long l;
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos03aB729AWT.getGLP());
        final Frame frame = new Frame("TestBug816OSXCALayerPos03aAWT");
        Assert.assertNotNull((Object)frame);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2(1));
        Animator animator = new Animator();
        animator.add((GLAutoDrawable)gLCanvas);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter)).addTo((Component)frame);
        final Checkbox checkbox = new Checkbox("Visible canvas", true);
        checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                gLCanvas.setVisible(checkbox.getState());
                System.out.println("Canvas visible: " + gLCanvas.isVisible());
                if (gLCanvas.isVisible()) {
                    frame.validate();
                }
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)gLCanvas, "Center");
        frame.add((Component)checkbox, "North");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(frame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLCanvas, true));
        animator.start();
        Assert.assertTrue((boolean)animator.isStarted());
        Assert.assertTrue((boolean)animator.isAnimating());
        animator.setUpdateFPSFrames(60, System.err);
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull((Object)frame);
        Assert.assertNotNull((Object)gLCanvas);
        Assert.assertNotNull((Object)animator);
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove((Component)gLCanvas);
                frame.dispose();
            }
        });
    }

    static GLProfile getGLP() {
        return GLProfile.getMaxProgrammableCore((boolean)true);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestBug816OSXCALayerPos03aB729AWT.class.getName()});
    }
}

