/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug664GLCanvasSetVisibleSwingAWT
extends UITestCase {
    static long durationPerTest = 500L;
    static boolean shallUseOffscreenFBOLayer = false;
    static boolean shallUseOffscreenPBufferLayer = false;
    static GLProfile glp;
    static int width;
    static int height;
    static boolean waitForKey;
    private volatile int frameCount = 0;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2ES2")) {
            glp = GLProfile.get((String)"GL2ES2");
            Assert.assertNotNull((Object)glp);
            width = 640;
            height = 480;
        } else {
            TestBug664GLCanvasSetVisibleSwingAWT.setTestSupported(false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected JPanel create(final JFrame[] jFrameArray, final int n, final int n2, final int n3) throws InterruptedException, InvocationTargetException {
        final JPanel[] jPanelArray = new JPanel[]{null};
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jPanelArray[0] = new JPanel();
                jPanelArray[0].setLayout(new BorderLayout());
                JFrame jFrame = new JFrame("JFrame #" + n3);
                jFrame.setDefaultCloseOperation(0);
                jFrame.getContentPane().add(jPanelArray[0]);
                jFrame.setSize(n, n2);
                jFrameArray[0] = jFrame;
            }
        });
        return jPanelArray[0];
    }

    protected void add(final Container container, final Component component, final JFrame jFrame) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                container.add(component, "Center");
                jFrame.pack();
                jFrame.validate();
            }
        });
    }

    protected void dispose(final GLCanvas gLCanvas) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                gLCanvas.destroy();
            }
        });
    }

    protected void setFrameVisible(final JFrame jFrame, final boolean bl) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(bl);
            }
        });
    }

    protected void setComponentVisible(final Component component, final boolean bl) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                component.setVisible(bl);
            }
        });
    }

    protected void dispose(final JFrame jFrame) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.dispose();
            }
        });
    }

    protected void runTestGL(boolean bl, GLCapabilities gLCapabilities) throws AWTException, InterruptedException, InvocationTargetException {
        for (int i = 0; i < 1; ++i) {
            Animator animator = new Animator();
            GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)gLCanvas);
            animator.add((GLAutoDrawable)gLCanvas);
            if (!bl) {
                gLCanvas.setShallUseOffscreenLayer(true);
            }
            Dimension dimension = new Dimension(width, height);
            gLCanvas.setMinimumSize(dimension);
            gLCanvas.setPreferredSize(dimension);
            gLCanvas.setSize(dimension);
            gLCanvas.addGLEventListener(new GLEventListener(){

                public void init(GLAutoDrawable gLAutoDrawable) {
                }

                public void dispose(GLAutoDrawable gLAutoDrawable) {
                }

                public void display(GLAutoDrawable gLAutoDrawable) {
                    TestBug664GLCanvasSetVisibleSwingAWT.this.frameCount++;
                }

                public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                }
            });
            GearsES2 gearsES2 = new GearsES2(1);
            gearsES2.setVerbose(false);
            gLCanvas.addGLEventListener((GLEventListener)gearsES2);
            JFrame[] jFrameArray = new JFrame[]{null};
            JPanel jPanel = this.create(jFrameArray, width, height, i);
            this.add(jPanel, (Component)gLCanvas, jFrameArray[0]);
            this.frameCount = 0;
            this.setFrameVisible(jFrameArray[0], true);
            Assert.assertTrue((String)"Component didn't become visible", (boolean)AWTRobotUtil.waitForVisible(gLCanvas, true));
            Assert.assertTrue((String)"Component didn't become realized", (boolean)AWTRobotUtil.waitForRealized(gLCanvas, true));
            animator.setUpdateFPSFrames(60, null);
            animator.start();
            animator.resetFPSCounter();
            System.err.println("Visible Part 1/3");
            while (animator.getTotalFPSDuration() < durationPerTest) {
                Thread.sleep(60L);
            }
            this.setComponentVisible((Component)gLCanvas, false);
            Assert.assertTrue((String)"Component didn't become invisible", (boolean)AWTRobotUtil.waitForVisible(gLCanvas, false));
            int n = this.frameCount;
            animator.resetFPSCounter();
            System.err.println("Invisible Part 2/3");
            while (animator.getTotalFPSDuration() < durationPerTest) {
                Thread.sleep(60L);
            }
            int n2 = this.frameCount;
            System.err.println("GLCanvas invisible frame count: Before " + n + ", after " + n2);
            Assert.assertTrue((String)("GLCanvas rendered more that 4 times while being invisible, before " + n + ", after " + n2), (4 >= n2 - n ? 1 : 0) != 0);
            this.setComponentVisible((Component)gLCanvas, true);
            Assert.assertTrue((String)"Component didn't become visible", (boolean)AWTRobotUtil.waitForVisible(gLCanvas, true));
            animator.resetFPSCounter();
            System.err.println("Visible Part 3/3");
            while (animator.getTotalFPSDuration() < durationPerTest) {
                Thread.sleep(60L);
            }
            System.err.println("GLCanvas isOffscreenLayerSurfaceEnabled: " + gLCanvas.isOffscreenLayerSurfaceEnabled() + ": " + gLCanvas.getChosenGLCapabilities());
            this.dispose(jFrameArray[0]);
        }
    }

    @Test
    public void test01Onscreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (shallUseOffscreenFBOLayer || shallUseOffscreenPBufferLayer || JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("Offscreen test requested or platform requires it.");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        if (shallUseOffscreenPBufferLayer) {
            gLCapabilities.setPBuffer(true);
            gLCapabilities.setOnscreen(true);
        }
        this.runTestGL(true, gLCapabilities);
    }

    @Test
    public void test02Offscreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (!JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("Platform doesn't support offscreen test.");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        if (shallUseOffscreenPBufferLayer) {
            gLCapabilities.setPBuffer(true);
            gLCapabilities.setOnscreen(true);
        }
        this.runTestGL(false, gLCapabilities);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    durationPerTest = Long.parseLong(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-layeredFBO")) {
                shallUseOffscreenFBOLayer = true;
                continue;
            }
            if (stringArray[i].equals("-layeredPBuffer")) {
                shallUseOffscreenPBufferLayer = true;
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        System.err.println("waitForKey                    " + waitForKey);
        System.err.println("shallUseOffscreenFBOLayer     " + shallUseOffscreenFBOLayer);
        System.err.println("shallUseOffscreenPBufferLayer " + shallUseOffscreenPBufferLayer);
        if (waitForKey) {
            UITestCase.waitForKey("Start");
        }
        JUnitCore.main((String[])new String[]{TestBug664GLCanvasSetVisibleSwingAWT.class.getName()});
    }

    static {
        waitForKey = false;
    }
}

