/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.FBOMix2DemosES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFBOMix2DemosES2NEWT
extends UITestCase {
    static long duration = 500L;
    static int swapInterval = 1;
    static boolean showFPS = false;
    static boolean forceES2 = false;
    static boolean doRotate = true;
    static boolean demo0Only = false;
    static int globalNumSamples = 0;
    static boolean mainRun = false;

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n) throws InterruptedException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        System.err.println("requested: vsync " + swapInterval + ", " + gLCapabilitiesImmutable);
        final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilitiesImmutable);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NEWT Test (translucent " + !gLCapabilitiesImmutable.isBackgroundOpaque() + "), swapInterval " + swapInterval);
        if (mainRun) {
            gLWindow.setSize(512, 512);
        } else {
            gLWindow.setSize(128, 128);
        }
        final FBOMix2DemosES2 fBOMix2DemosES2 = new FBOMix2DemosES2(swapInterval);
        fBOMix2DemosES2.setMSAA(n);
        fBOMix2DemosES2.setDoRotation(doRotate);
        fBOMix2DemosES2.setDemo0Only(demo0Only);
        gLWindow.addGLEventListener((GLEventListener)fBOMix2DemosES2);
        gLWindow.addGLEventListener(new GLEventListener(){
            int i = 0;
            int c = 0;
            int origS;

            public void init(GLAutoDrawable gLAutoDrawable) {
                this.origS = fBOMix2DemosES2.getMSAA();
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                if (mainRun) {
                    return;
                }
                final int n = gLAutoDrawable.getWidth();
                final int n2 = gLAutoDrawable.getHeight();
                ++this.c;
                if (n < 800) {
                    System.err.println("XXX: " + n + "x" + n2 + ", c " + this.c);
                    if (0 == this.c % 3) {
                        TestFBOMix2DemosES2NEWT.this.snapshot(this.i++, "msaa" + fBOMix2DemosES2.getMSAA(), gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                    }
                    if (3 == this.c) {
                        new Thread(){

                            @Override
                            public void run() {
                                fBOMix2DemosES2.setMSAA(4);
                            }
                        }.start();
                    } else if (6 == this.c) {
                        new Thread(){

                            @Override
                            public void run() {
                                fBOMix2DemosES2.setMSAA(8);
                            }
                        }.start();
                    } else if (9 == this.c) {
                        this.c = 0;
                        new Thread(){

                            @Override
                            public void run() {
                                gLWindow.setSize(n + 256, n2 + 256);
                                fBOMix2DemosES2.setMSAA(origS);
                            }
                        }.start();
                    }
                }
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener((KeyListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)quitAdapter);
        gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowResized(WindowEvent windowEvent) {
                System.err.println("window resized: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }

            public void windowMoved(WindowEvent windowEvent) {
                System.err.println("window moved:   " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight());
            }
        });
        gLWindow.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                System.err.println("*** " + keyEvent);
                if (keyEvent.getKeyChar() == 'f') {
                    new Thread(){

                        @Override
                        public void run() {
                            System.err.println("[set fullscreen  pre]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                            gLWindow.setFullscreen(!gLWindow.isFullscreen());
                            System.err.println("[set fullscreen post]: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", f " + gLWindow.isFullscreen() + ", a " + gLWindow.isAlwaysOnTop() + ", " + gLWindow.getInsets());
                        }
                    }.start();
                } else if (keyEvent.getKeyChar() == 'd') {
                    fBOMix2DemosES2.setDemo0Only(!fBOMix2DemosES2.getDemo0Only());
                } else {
                    int n = keyEvent.getKeyChar() - 48;
                    System.err.println("*** " + n);
                    if (0 <= n && n <= 8) {
                        System.err.println("MSAA: " + fBOMix2DemosES2.getMSAA() + " -> " + n);
                        fBOMix2DemosES2.setMSAA(n);
                    }
                }
            }
        });
        animator.start();
        gLWindow.setVisible(true);
        System.err.println("NW chosen: " + gLWindow.getDelegatedWindow().getChosenCapabilities());
        System.err.println("GL chosen: " + gLWindow.getChosenCapabilities());
        System.err.println("window pos/siz: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + ", " + gLWindow.getInsets());
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        gLWindow.destroy();
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, false));
    }

    @Test
    public void test01_Main() throws InterruptedException {
        if (mainRun) {
            GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
            gLCapabilities.setAlphaBits(1);
            this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, globalNumSamples);
        }
    }

    @Test
    public void test01() throws InterruptedException {
        if (mainRun) {
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2());
        gLCapabilities.setAlphaBits(1);
        this.runTestGL((GLCapabilitiesImmutable)gLCapabilities, 0);
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = false;
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-showFPS")) {
                showFPS = true;
                continue;
            }
            if (stringArray[i].equals("-samples")) {
                globalNumSamples = MiscUtils.atoi(stringArray[++i], globalNumSamples);
                continue;
            }
            if (stringArray[i].equals("-norotate")) {
                doRotate = false;
                continue;
            }
            if (stringArray[i].equals("-demo0Only")) {
                demo0Only = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-nomain")) continue;
            mainRun = false;
        }
        System.err.println("swapInterval " + swapInterval);
        System.err.println("forceES2 " + forceES2);
        if (bl) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main((String[])new String[]{TestFBOMix2DemosES2NEWT.class.getName()});
    }
}

