/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import javax.media.opengl.GL2ES2;

public abstract class UIShape {
    private final Vertex.Factory<? extends Vertex> vertexFactory;
    protected OutlineShape shape;
    protected static final int DIRTY_SHAPE = 1;
    protected int dirty = 1;
    private boolean down = false;
    protected boolean positionDirty = false;
    private float[] position = new float[]{0.0f, 0.0f, 0.0f};
    private float[] scale = new float[]{1.0f, 1.0f, 1.0f};

    public UIShape(Vertex.Factory<? extends Vertex> factory) {
        this.vertexFactory = factory;
        this.shape = new OutlineShape(factory);
    }

    public void clear() {
        this.clearImpl();
        this.shape.clear();
    }

    public abstract void render(GL2ES2 var1, RenderState var2, RegionRenderer var3, int var4, int[] var5, boolean var6);

    public void setScale(float f, float f2, float f3) {
        this.scale[0] = f;
        this.scale[1] = f2;
        this.scale[2] = f3;
    }

    public void setPosition(float f, float f2, float f3) {
        this.position[0] = f;
        this.position[1] = f2;
        this.position[2] = f3;
        this.positionDirty = true;
    }

    private void updatePosition() {
        float f = this.shape.getBounds().getLow()[0];
        float f2 = this.shape.getBounds().getLow()[1];
        float f3 = this.shape.getBounds().getLow()[2];
        System.out.println("Position was: " + this.position[0] + " " + this.position[1] + " " + this.position[2]);
        System.out.println("Position became: " + (this.position[0] - f) + " " + (this.position[1] - f2) + " " + (this.position[2] - f3));
        this.setPosition(this.position[0] - f, this.position[1] - f2, this.position[2] - f3);
        this.positionDirty = false;
    }

    public float[] getScale() {
        return this.scale;
    }

    public float[] getPosition() {
        return this.position;
    }

    protected abstract void clearImpl();

    protected abstract void createShape();

    public boolean updateShape() {
        if (this.isShapeDirty()) {
            this.shape.clear();
            this.createShape();
            if (this.positionDirty) {
                this.updatePosition();
            }
            this.dirty &= 0xFFFFFFFE;
            return true;
        }
        return false;
    }

    public final Vertex.Factory<? extends Vertex> getVertexFactory() {
        return this.vertexFactory;
    }

    public AABBox getBounds() {
        return this.shape.getBounds();
    }

    public OutlineShape getShape() {
        this.updateShape();
        return this.shape;
    }

    public boolean isShapeDirty() {
        return 0 != (this.dirty & 1);
    }

    public void setPressed(boolean bl) {
        this.down = bl;
    }

    public boolean isPressed() {
        return this.down;
    }

    public abstract void onClick();

    public abstract void onPressed();

    public abstract void onRelease();
}

