/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.graph.demos.ui.RIButton;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLRunnable;

public abstract class UIListenerBase01
implements GLEventListener {
    private GLReadBufferUtil screenshot;
    private RegionRenderer rRenderer;
    private boolean debug;
    private boolean trace;
    protected RIButton button;
    private KeyAction keyAction;
    private MouseAction mouseAction;
    private volatile GLAutoDrawable autoDrawable = null;
    private final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    private float xTran = -10.0f;
    private float yTran = 10.0f;
    private float ang = 0.0f;
    private float zoom = -70.0f;
    boolean ignoreInput = false;
    int screenshot_num = 0;

    public UIListenerBase01(RegionRenderer regionRenderer, boolean bl, boolean bl2) {
        this.rRenderer = regionRenderer;
        this.debug = bl;
        this.trace = bl2;
        this.screenshot = new GLReadBufferUtil(false, false);
    }

    public final RegionRenderer getRegionRenderer() {
        return this.rRenderer;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public final float getXTran() {
        return this.xTran;
    }

    public final float getYTran() {
        return this.yTran;
    }

    public final float getAngle() {
        return this.ang;
    }

    public final float[] getPosition() {
        return this.position;
    }

    public void setMatrix(float f, float f2, float f3, int n) {
        this.xTran = f;
        this.yTran = f2;
        this.ang = f3;
        this.zoom = n;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.getRegionRenderer().init(gL2ES2);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glViewport(n, n2, n3, n4);
        this.rRenderer.reshapePerspective(gL2ES2, 45.0f, n3, n4, 0.1f, 7000.0f);
        this.dumpMatrix();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = null;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.screenshot.dispose((GL)gL2ES2);
        this.rRenderer.destroy(gL2ES2);
    }

    public void zoom(int n) {
        this.zoom += (float)n;
        this.dumpMatrix();
    }

    public void move(float f, float f2) {
        this.xTran += f;
        this.yTran += f2;
        this.dumpMatrix();
    }

    public void rotate(float f) {
        this.ang += f;
        this.ang %= 360.0f;
        this.dumpMatrix();
    }

    void dumpMatrix() {
        System.err.println("Matrix: " + this.xTran + "/" + this.yTran + " x" + this.zoom + " @" + this.ang);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener((KeyListener)this.keyAction);
        }
        if (null == this.mouseAction) {
            this.mouseAction = new MouseAction();
            gLWindow.addMouseListener((MouseListener)this.mouseAction);
        }
    }

    public void detachFrom(GLWindow gLWindow) {
        if (null == this.keyAction) {
            return;
        }
        if (null == this.mouseAction) {
            return;
        }
        gLWindow.removeGLEventListener((GLEventListener)this);
        gLWindow.removeKeyListener((KeyListener)this.keyAction);
        gLWindow.removeMouseListener((MouseListener)this.mouseAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) throws GLException, IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("-%03dx%03d-Z%04d-T%04d-%s", gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), (int)Math.abs(this.zoom), 0, string3);
        String string4 = string + string2 + stringWriter + ".png";
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string4));
        }
    }

    public void setIgnoreInput(boolean bl) {
        this.ignoreInput = bl;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public class KeyAction
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (UIListenerBase01.this.ignoreInput) {
                return;
            }
            if (keyEvent.getKeyCode() == 49) {
                UIListenerBase01.this.zoom(10);
            } else if (keyEvent.getKeyCode() == 50) {
                UIListenerBase01.this.zoom(-10);
            } else if (keyEvent.getKeyCode() == 150) {
                UIListenerBase01.this.move(0.0f, -1.0f);
            } else if (keyEvent.getKeyCode() == 152) {
                UIListenerBase01.this.move(0.0f, 1.0f);
            } else if (keyEvent.getKeyCode() == 149) {
                UIListenerBase01.this.move(1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 151) {
                UIListenerBase01.this.move(-1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 52) {
                UIListenerBase01.this.button.setSpacing(UIListenerBase01.this.button.getSpacing() - 0.1f);
                System.err.println("Button Spacing: " + UIListenerBase01.this.button.getSpacing());
            } else if (keyEvent.getKeyCode() == 53) {
                UIListenerBase01.this.button.setSpacing(UIListenerBase01.this.button.getSpacing() + 0.1f);
                System.err.println("Button Spacing: " + UIListenerBase01.this.button.getSpacing());
            } else if (keyEvent.getKeyCode() == 54) {
                UIListenerBase01.this.button.setCorner(UIListenerBase01.this.button.getCorner() - 0.1f);
                System.err.println("Button Corner: " + UIListenerBase01.this.button.getCorner());
            } else if (keyEvent.getKeyCode() == 55) {
                UIListenerBase01.this.button.setCorner(UIListenerBase01.this.button.getCorner() + 0.1f);
                System.err.println("Button Corner: " + UIListenerBase01.this.button.getCorner());
            } else if (keyEvent.getKeyCode() == 48) {
                UIListenerBase01.this.rotate(1.0f);
            } else if (keyEvent.getKeyCode() == 57) {
                UIListenerBase01.this.rotate(-1.0f);
            } else if (keyEvent.getKeyCode() == 86) {
                if (null != UIListenerBase01.this.autoDrawable) {
                    UIListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            GL gL = gLAutoDrawable.getGL();
                            int n = gL.getSwapInterval();
                            n = n == 0 ? 1 : 0;
                            gL.setSwapInterval(n);
                            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                            if (null != gLAnimatorControl) {
                                gLAnimatorControl.resetFPSCounter();
                            }
                            System.err.println("Swap Interval: " + n);
                            return true;
                        }
                    });
                }
            } else if (keyEvent.getKeyCode() == 83) {
                UIListenerBase01.this.rotate(-1.0f);
                if (null != UIListenerBase01.this.autoDrawable) {
                    UIListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            try {
                                String string = 1 == UIListenerBase01.this.rRenderer.getRenderModes() ? "r2t0-msaa1" : "r2t1-msaa0";
                                UIListenerBase01.this.printScreen(gLAutoDrawable, "./", "demo-" + string, "snap" + UIListenerBase01.this.screenshot_num, false);
                                ++UIListenerBase01.this.screenshot_num;
                            }
                            catch (GLException gLException) {
                                gLException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            return true;
                        }
                    });
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class MouseAction
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            UIListenerBase01.this.button.setLabelColor(0.8f, 0.8f, 0.8f);
            UIListenerBase01.this.button.setButtonColor(0.1f, 0.1f, 0.1f);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            UIListenerBase01.this.button.setLabelColor(1.0f, 1.0f, 1.0f);
            UIListenerBase01.this.button.setButtonColor(0.6f, 0.6f, 0.6f);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
        }
    }
}

