/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.common.nio.Buffers;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.graph.demos.ui.UIShape;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLRunnable;

public class SceneUIController
implements GLEventListener {
    private ArrayList<UIShape> shapes = new ArrayList();
    private int count = 0;
    private int renderModes;
    private int[] texSize;
    private RegionRenderer renderer = null;
    private RenderState rs = null;
    private float[] translate = new float[3];
    private float[] scale = new float[3];
    private float[] rotation = new float[3];
    private float[] sceneClearColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private int activeId = -1;
    private SBCMouseListener sbcMouseListener = null;
    private GLAutoDrawable cDrawable = null;

    public SceneUIController() {
    }

    public void setRenderer(RegionRenderer regionRenderer, RenderState renderState, int n, int[] nArray) {
        this.renderer = regionRenderer;
        this.rs = renderState;
        this.renderModes = n;
        this.texSize = nArray;
    }

    public SceneUIController(RegionRenderer regionRenderer, RenderState renderState, int n, int[] nArray) {
        this.renderer = regionRenderer;
        this.rs = renderState;
        this.renderModes = n;
        this.texSize = nArray;
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.sbcMouseListener) {
            this.sbcMouseListener = new SBCMouseListener();
            gLWindow.addMouseListener((MouseListener)this.sbcMouseListener);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (null != this.sbcMouseListener) {
            gLWindow.removeMouseListener((MouseListener)this.sbcMouseListener);
        }
    }

    public ArrayList<UIShape> getShapes() {
        return this.shapes;
    }

    public void addShape(UIShape uIShape) {
        this.shapes.add(uIShape);
        ++this.count;
    }

    public void removeShape(UIShape uIShape) {
        boolean bl = this.shapes.remove(uIShape);
        if (bl) {
            --this.count;
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println("SceneUIController: init");
        this.cDrawable = gLAutoDrawable;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.render(gL2ES2, n, n2, this.renderModes, this.texSize, false);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println("SceneUIController: dispose");
        this.cDrawable = null;
        gLAutoDrawable.removeGLEventListener((GLEventListener)this);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.err.println("SceneUIController: reshape");
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.renderer.reshapePerspective(gL2ES2, 45.0f, n3, n4, 5.0f, 70.0f);
    }

    public UIShape getShape(GLAutoDrawable gLAutoDrawable, int n, int n2) {
        int n3 = gLAutoDrawable.getWidth();
        int n4 = gLAutoDrawable.getHeight();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        int n5 = this.checkSelection(gL2ES2, n, n2, n3, n4);
        if (n5 == -1) {
            return null;
        }
        return this.shapes.get(n5);
    }

    public UIShape getActiveUI() {
        if (this.activeId == -1) {
            return null;
        }
        return this.shapes.get(this.activeId);
    }

    public void release() {
        this.activeId = -1;
    }

    private int checkSelection(GL2ES2 gL2ES2, int n, int n2, int n3, int n4) {
        gL2ES2.glPixelStorei(3333, 4);
        gL2ES2.glPixelStorei(3317, 4);
        gL2ES2.glClearColor(this.sceneClearColor[0], this.sceneClearColor[1], this.sceneClearColor[2], this.sceneClearColor[3]);
        gL2ES2.glClear(16640);
        this.render(gL2ES2, n3, n4, 0, null, true);
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)4);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = IntBuffer.allocate(4);
        gL2ES2.glGetIntegerv(2978, intBuffer);
        gL2ES2.glReadPixels(n, intBuffer.get(3) - n2, 1, 1, 6408, 5121, (Buffer)byteBuffer);
        int n5 = byteBuffer.get(0) & 0xFF;
        int n6 = Math.round((float)n5 / 255.0f * (float)(this.count + 2) - 1.0f);
        if (n6 < 0 || n6 >= this.count) {
            return -1;
        }
        return n6;
    }

    private void render(GL2ES2 gL2ES2, int n, int n2, int n3, int[] nArray, boolean bl) {
        this.renderer.reshapePerspective(null, 45.0f, n, n2, 0.1f, 7000.0f);
        for (int i = 0; i < this.count; ++i) {
            if (bl) {
                float f = i + 1;
                this.renderer.setColorStatic(gL2ES2, f / (float)(this.count + 2), f / (float)(this.count + 2), f / (float)(this.count + 2));
            }
            float[] fArray = this.shapes.get(i).getScale();
            float[] fArray2 = this.shapes.get(i).getPosition();
            this.renderer.resetModelview(null);
            this.renderer.translate(null, this.translate[0] + fArray2[0], this.translate[1] + fArray2[1], this.translate[2] + fArray2[2]);
            this.renderer.scale(gL2ES2, fArray[0], fArray[1], fArray[2]);
            this.renderer.rotate(gL2ES2, this.rotation[0], 1.0f, 0.0f, 0.0f);
            this.renderer.rotate(gL2ES2, this.rotation[1], 0.0f, 1.0f, 0.0f);
            this.renderer.rotate(gL2ES2, this.rotation[2], 0.0f, 0.0f, 1.0f);
            this.shapes.get(i).render(gL2ES2, this.rs, this.renderer, n3, nArray, bl);
            this.renderer.rotate(gL2ES2, -this.rotation[0], 1.0f, 0.0f, 0.0f);
            this.renderer.rotate(gL2ES2, -this.rotation[1], 0.0f, 1.0f, 0.0f);
            this.renderer.rotate(gL2ES2, -this.rotation[2], 0.0f, 0.0f, 1.0f);
        }
    }

    public void setTranslate(float f, float f2, float f3) {
        this.translate[0] = f;
        this.translate[1] = f2;
        this.translate[2] = f3;
    }

    public void setScale(float f, float f2, float f3) {
        this.scale[0] = f;
        this.scale[1] = f2;
        this.scale[2] = f3;
    }

    public void setRotation(float f, float f2, float f3) {
        this.rotation[0] = f;
        this.rotation[1] = f2;
        this.rotation[2] = f3;
    }

    public float[] getSceneClearColor() {
        return this.sceneClearColor;
    }

    public void setSceneClearColor(float f, float f2, float f3, float f4) {
        this.sceneClearColor[0] = f;
        this.sceneClearColor[1] = f2;
        this.sceneClearColor[2] = f3;
        this.sceneClearColor[3] = f4;
    }

    private class SBCMouseListener
    implements MouseListener {
        int mouseX = -1;
        int mouseY = -1;

        private SBCMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            UIShape uIShape = SceneUIController.this.getActiveUI();
            if (uIShape != null) {
                uIShape.onClick();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (null == SceneUIController.this.cDrawable) {
                return;
            }
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            GLRunnable gLRunnable = new GLRunnable(){

                public boolean run(GLAutoDrawable gLAutoDrawable) {
                    UIShape uIShape = SceneUIController.this.getShape(gLAutoDrawable, SBCMouseListener.this.mouseX, SBCMouseListener.this.mouseY);
                    if (null != uIShape) {
                        SceneUIController.this.activeId = SceneUIController.this.getShapes().indexOf(uIShape);
                    } else {
                        SceneUIController.this.activeId = -1;
                    }
                    return false;
                }
            };
            SceneUIController.this.cDrawable.invoke(true, gLRunnable);
            UIShape uIShape = SceneUIController.this.getActiveUI();
            if (uIShape != null) {
                uIShape.setPressed(true);
                uIShape.onPressed();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            UIShape uIShape = SceneUIController.this.getActiveUI();
            if (uIShape != null) {
                uIShape.setPressed(false);
                uIShape.onRelease();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
        }
    }
}

