/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.Renderer;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.graph.demos.MSAATool;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.media.opengl.FPSCounter;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLRunnable;

public abstract class GPURendererListenerBase01
implements GLEventListener {
    private GLReadBufferUtil screenshot;
    private Renderer renderer;
    private int renderModes;
    private boolean debug;
    private boolean trace;
    protected GLRegion region;
    private KeyAction keyAction;
    private volatile GLAutoDrawable autoDrawable = null;
    private final float[] position = new float[]{0.0f, 0.0f, 0.0f};
    private float xTran = -10.0f;
    private float yTran = 10.0f;
    private float ang = 0.0f;
    private float zoom = -70.0f;
    private int[] texSize = new int[]{400};
    protected volatile float weight = 1.0f;
    boolean ignoreInput = false;
    int screenshot_num = 0;

    public GPURendererListenerBase01(Renderer renderer, int n, boolean bl, boolean bl2) {
        this.renderer = renderer;
        this.renderModes = n;
        this.debug = bl;
        this.trace = bl2;
        this.screenshot = new GLReadBufferUtil(false, false);
    }

    public final Renderer getRenderer() {
        return this.renderer;
    }

    public final int getRenderModes() {
        return this.renderModes;
    }

    public final float getZoom() {
        return this.zoom;
    }

    public final float getXTran() {
        return this.xTran;
    }

    public final float getYTran() {
        return this.yTran;
    }

    public final float getAngle() {
        return this.ang;
    }

    public final int[] getTexSize() {
        return this.texSize;
    }

    public final float[] getPosition() {
        return this.position;
    }

    public void setMatrix(float f, float f2, float f3, int n, int n2) {
        this.xTran = f;
        this.yTran = f2;
        this.ang = f3;
        this.zoom = n;
        this.texSize[0] = n2;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        System.err.println("*** " + gL2ES2.getContext().getGLVersion());
        System.err.println("*** GLDebugMessage " + gL2ES2.getContext().isGLDebugMessageEnabled());
        MSAATool.dump(gLAutoDrawable);
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.getRenderer().init(gL2ES2);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glViewport(n, n2, n3, n4);
        this.renderer.reshapePerspective(gL2ES2, 45.0f, n3, n4, 0.1f, 7000.0f);
        this.dumpMatrix();
        System.err.println("Reshape: " + this.renderer.getRenderState());
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.autoDrawable = null;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null != this.region) {
            this.region.destroy(gL2ES2, this.renderer.getRenderState());
        }
        this.screenshot.dispose((GL)gL2ES2);
        this.renderer.destroy(gL2ES2);
    }

    public void zoom(int n) {
        this.zoom += (float)n;
        this.dumpMatrix();
    }

    public void move(float f, float f2) {
        this.xTran += f;
        this.yTran += f2;
        this.dumpMatrix();
    }

    public void rotate(float f) {
        this.ang += f;
        this.ang %= 360.0f;
        this.dumpMatrix();
    }

    public void editGlobalWeight(float f) {
        if (!Renderer.isWeightValid((float)(this.weight + f))) {
            return;
        }
        this.weight += f;
        System.err.println("Global Weight: " + this.weight);
    }

    void dumpMatrix() {
        System.err.println("Matrix: " + this.xTran + "/" + this.yTran + " x" + this.zoom + " @" + this.ang);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.keyAction) {
            this.keyAction = new KeyAction();
            gLWindow.addKeyListener((KeyListener)this.keyAction);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (null == this.keyAction) {
            return;
        }
        gLWindow.removeKeyListener((KeyListener)this.keyAction);
    }

    public void printScreen(GLAutoDrawable gLAutoDrawable, String string, String string2, String string3, boolean bl) throws GLException, IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("-%03dx%03d-Z%04d-T%04d-%s", gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight(), (int)Math.abs(this.zoom), this.texSize[0], string3);
        String string4 = string + string2 + stringWriter + ".png";
        if (this.screenshot.readPixels(gLAutoDrawable.getGL(), false)) {
            this.screenshot.write(new File(string4));
        }
    }

    public void setIgnoreInput(boolean bl) {
        this.ignoreInput = bl;
    }

    public boolean getIgnoreInput() {
        return this.ignoreInput;
    }

    public class KeyAction
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
            if (GPURendererListenerBase01.this.ignoreInput) {
                return;
            }
            if (keyEvent.getKeyCode() == 49) {
                GPURendererListenerBase01.this.zoom(10);
            } else if (keyEvent.getKeyCode() == 50) {
                GPURendererListenerBase01.this.zoom(-10);
            } else if (keyEvent.getKeyCode() == 150) {
                GPURendererListenerBase01.this.move(0.0f, -1.0f);
            } else if (keyEvent.getKeyCode() == 152) {
                GPURendererListenerBase01.this.move(0.0f, 1.0f);
            } else if (keyEvent.getKeyCode() == 149) {
                GPURendererListenerBase01.this.move(1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 151) {
                GPURendererListenerBase01.this.move(-1.0f, 0.0f);
            } else if (keyEvent.getKeyCode() == 54) {
                int[] nArray = GPURendererListenerBase01.this.texSize;
                nArray[0] = nArray[0] - 10;
                System.err.println("Tex Size: " + GPURendererListenerBase01.this.texSize[0]);
            } else if (keyEvent.getKeyCode() == 55) {
                int[] nArray = GPURendererListenerBase01.this.texSize;
                nArray[0] = nArray[0] + 10;
                System.err.println("Tex Size: " + GPURendererListenerBase01.this.texSize[0]);
            } else if (keyEvent.getKeyCode() == 48) {
                GPURendererListenerBase01.this.rotate(1.0f);
            } else if (keyEvent.getKeyCode() == 57) {
                GPURendererListenerBase01.this.rotate(-1.0f);
            } else if (keyEvent.getKeyCode() == 81) {
                GPURendererListenerBase01.this.editGlobalWeight(-0.1f);
            } else if (keyEvent.getKeyCode() == 87) {
                GPURendererListenerBase01.this.editGlobalWeight(0.1f);
            } else if (keyEvent.getKeyCode() == 86) {
                if (null != GPURendererListenerBase01.this.autoDrawable) {
                    GPURendererListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            GL gL = gLAutoDrawable.getGL();
                            int n = gL.getSwapInterval();
                            n = n == 0 ? 1 : 0;
                            gL.setSwapInterval(n);
                            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                            if (null != gLAnimatorControl) {
                                gLAnimatorControl.resetFPSCounter();
                            }
                            if (gLAutoDrawable instanceof FPSCounter) {
                                ((FPSCounter)gLAutoDrawable).resetFPSCounter();
                            }
                            System.err.println("Swap Interval: " + n);
                            return true;
                        }
                    });
                }
            } else if (keyEvent.getKeyCode() == 83) {
                GPURendererListenerBase01.this.rotate(-1.0f);
                if (null != GPURendererListenerBase01.this.autoDrawable) {
                    GPURendererListenerBase01.this.autoDrawable.invoke(false, new GLRunnable(){

                        public boolean run(GLAutoDrawable gLAutoDrawable) {
                            try {
                                String string = Region.isVBAA((int)GPURendererListenerBase01.this.renderModes) ? "vbaa0-msaa1" : "vbaa1-msaa0" + (Region.isNonUniformWeight((int)GPURendererListenerBase01.this.renderModes) ? "-vc" : "-uc");
                                GPURendererListenerBase01.this.printScreen(gLAutoDrawable, "./", "demo-" + string, "snap" + GPURendererListenerBase01.this.screenshot_num, false);
                                ++GPURendererListenerBase01.this.screenshot_num;
                            }
                            catch (GLException gLException) {
                                gLException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            return true;
                        }
                    });
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

