/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.bugs;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.LandscapeES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;

public class Bug735Inv2AppletAWT
extends Applet
implements Runnable {
    public static int AWT = 0;
    public static int NEWT = 1;
    public static int APPLET_WIDTH = 500;
    public static int APPLET_HEIGHT = 290;
    public static int TARGET_FPS = 120;
    public static int TOOLKIT = NEWT;
    public static boolean IGNORE_AWT_REPAINT = false;
    public static boolean USE_ECT = false;
    public static int SWAP_INTERVAL = 1;
    static boolean waitForKey = false;
    private static Frame frame;
    private static Bug735Inv2AppletAWT applet;
    private GLCanvas awtCanvas;
    private GLWindow newtWindow;
    private GLAutoDrawable glad;
    private NewtCanvasAWT newtCanvas;
    private GLEventListener demo;
    private int width;
    private int height;
    private Thread thread;
    private long frameRatePeriod = 1000000000L / (long)TARGET_FPS;
    private int frameCount;

    @Override
    public void init() {
        this.setSize(APPLET_WIDTH, APPLET_HEIGHT);
        this.setPreferredSize(new Dimension(APPLET_WIDTH, APPLET_HEIGHT));
        this.width = APPLET_WIDTH;
        this.height = APPLET_HEIGHT;
        this.initGL();
    }

    @Override
    public void start() {
        this.initDraw();
        this.thread = new Thread((Runnable)this, "Animation Thread");
        this.thread.start();
    }

    @Override
    public void run() {
        int n = 0;
        long l = System.nanoTime();
        long l2 = 0L;
        this.frameCount = 1;
        while (Thread.currentThread() == this.thread) {
            if (this.frameCount == 1) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Bug735Inv2AppletAWT.this.requestFocusInWindow();
                    }
                });
                if (USE_ECT) {
                    this.glad.setExclusiveContextThread(this.thread);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.requestDraw(countDownLatch);
            try {
                countDownLatch.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            long l3 = System.nanoTime();
            long l4 = l3 - l;
            long l5 = this.frameRatePeriod - l4 - l2;
            if (l5 > 0L) {
                try {
                    Thread.sleep(l5 / 1000000L, (int)(l5 % 1000000L));
                    n = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = System.nanoTime() - l3 - l5;
            } else {
                l2 = 0L;
                if (++n > 15) {
                    Thread.yield();
                    n = 0;
                }
            }
            l = System.nanoTime();
        }
    }

    public void requestDraw(CountDownLatch countDownLatch) {
        this.glad.display();
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
    }

    private void initGL() {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setBackgroundOpaque(true);
        gLCapabilities.setOnscreen(true);
        gLCapabilities.setSampleBuffers(false);
        if (TOOLKIT == AWT) {
            this.awtCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            this.awtCanvas.setBounds(0, 0, Bug735Inv2AppletAWT.applet.width, Bug735Inv2AppletAWT.applet.height);
            this.awtCanvas.setBackground(new Color(-3355444, true));
            this.awtCanvas.setFocusable(true);
            applet.setLayout(new BorderLayout());
            applet.add((Component)this.awtCanvas, "Center");
            if (IGNORE_AWT_REPAINT) {
                this.awtCanvas.setIgnoreRepaint(true);
            }
            this.glad = this.awtCanvas;
        } else if (TOOLKIT == NEWT) {
            this.newtWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            this.newtCanvas = new NewtCanvasAWT((Window)this.newtWindow);
            this.newtCanvas.setBounds(0, 0, Bug735Inv2AppletAWT.applet.width, Bug735Inv2AppletAWT.applet.height);
            this.newtCanvas.setBackground(new Color(-3355444, true));
            this.newtCanvas.setFocusable(true);
            applet.setLayout(new BorderLayout());
            applet.add((Component)this.newtCanvas, "Center");
            if (IGNORE_AWT_REPAINT) {
                this.newtCanvas.setIgnoreRepaint(true);
            }
            this.glad = this.newtWindow;
        }
        this.demo = new LandscapeES2(SWAP_INTERVAL);
        this.glad.addGLEventListener(this.demo);
    }

    private void initDraw() {
        if (TOOLKIT == AWT) {
            this.awtCanvas.setVisible(true);
            this.awtCanvas.display();
            if (this.awtCanvas.getDelegatedDrawable().isRealized()) {
                this.awtCanvas.requestFocus();
            }
        } else if (TOOLKIT == NEWT) {
            this.newtCanvas.setVisible(true);
            this.newtWindow.display();
            if (this.newtWindow.isRealized()) {
                this.newtCanvas.requestFocus();
            }
        }
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-vsync")) {
                SWAP_INTERVAL = MiscUtils.atoi(stringArray[++i], SWAP_INTERVAL);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                USE_ECT = true;
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        System.err.println("swapInterval " + SWAP_INTERVAL);
        System.err.println("exclusiveContext " + USE_ECT);
        if (waitForKey) {
            UITestCase.waitForKey("Start");
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        frame = new Frame(graphicsDevice.getDefaultConfiguration());
        frame.setBackground(new Color(204, 204, 204));
        frame.setTitle("TestBug735Inv2AppletAWT");
        try {
            serializable = Thread.currentThread().getContextClassLoader().loadClass(Bug735Inv2AppletAWT.class.getName());
            applet = (Bug735Inv2AppletAWT)serializable.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        frame.setLayout(null);
        frame.add(applet);
        frame.pack();
        frame.setResizable(false);
        applet.init();
        serializable = frame.getInsets();
        int n = Bug735Inv2AppletAWT.applet.width + ((Insets)serializable).left + ((Insets)serializable).right;
        int n2 = Bug735Inv2AppletAWT.applet.height + ((Insets)serializable).top + ((Insets)serializable).bottom;
        frame.setSize(n, n2);
        Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
        frame.setLocation(rectangle.x + (rectangle.width - Bug735Inv2AppletAWT.applet.width) / 2, rectangle.y + (rectangle.height - Bug735Inv2AppletAWT.applet.height) / 2);
        int n3 = n2 - ((Insets)serializable).top - ((Insets)serializable).bottom;
        applet.setBounds((n - Bug735Inv2AppletAWT.applet.width) / 2, ((Insets)serializable).top + (n3 - Bug735Inv2AppletAWT.applet.height) / 2, Bug735Inv2AppletAWT.applet.width, Bug735Inv2AppletAWT.applet.height);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
        applet.start();
    }
}

