/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.openal.ALException;
import com.jogamp.openal.util.WAVData;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class WAVLoader {
    public static WAVData loadFromFile(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        return WAVLoader.loadFromStreamImpl(fileInputStream);
    }

    public static WAVData loadFromStream(InputStream inputStream) throws IOException {
        return WAVLoader.loadFromStreamImpl(inputStream);
    }

    private static long readUnsignedIntLittleEndian(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    private static short readUnsignedShortLittleEndian(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[2];
        dataInputStream.readFully(byArray);
        return (short)(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WAVData loadFromStreamImpl(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        try {
            int n;
            if (dataInputStream.readInt() != 1380533830) {
                throw new ALException("Invalid WAV header");
            }
            WAVLoader.readUnsignedIntLittleEndian(dataInputStream);
            if (dataInputStream.readInt() != 1463899717) {
                throw new ALException("Invalid WAV header");
            }
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            int n3 = 0;
            long l = 0L;
            long l2 = 0L;
            block8: while (!bl2) {
                n = dataInputStream.readInt();
                l2 = WAVLoader.readUnsignedIntLittleEndian(dataInputStream);
                switch (n) {
                    case 1718449184: {
                        bl = true;
                        WAVLoader.readUnsignedShortLittleEndian(dataInputStream);
                        n2 = WAVLoader.readUnsignedShortLittleEndian(dataInputStream);
                        l = WAVLoader.readUnsignedIntLittleEndian(dataInputStream);
                        WAVLoader.readUnsignedIntLittleEndian(dataInputStream);
                        WAVLoader.readUnsignedShortLittleEndian(dataInputStream);
                        n3 = WAVLoader.readUnsignedShortLittleEndian(dataInputStream);
                        dataInputStream.skip(l2 - 16L);
                        continue block8;
                    }
                    case 1717658484: {
                        dataInputStream.skip(l2);
                        continue block8;
                    }
                    case 1684108385: {
                        if (!bl) {
                            throw new ALException("WAV fmt chunks must be before data chunks");
                        }
                        bl2 = true;
                        continue block8;
                    }
                }
                dataInputStream.skip(l2);
            }
            n = n2;
            int n4 = n3;
            float f = l;
            WAVData wAVData = WAVData.loadFromStream(inputStream, -1, n, n4, Math.round(f), ByteOrder.LITTLE_ENDIAN, false);
            return wAVData;
        }
        finally {
            dataInputStream.close();
        }
    }
}

