/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.awt;

import com.jogamp.opengl.util.GLPixelBuffer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;

public class AWTGLPixelBuffer
extends GLPixelBuffer {
    public static final GLPixelBuffer.GLPixelAttributes awtPixelAttributesIntRGBA4 = new GLPixelBuffer.GLPixelAttributes(4, 32993, 5121);
    public static final GLPixelBuffer.GLPixelAttributes awtPixelAttributesIntRGB3 = new GLPixelBuffer.GLPixelAttributes(3, 32993, 5121);
    public final BufferedImage image;

    public AWTGLPixelBuffer(GLPixelBuffer.GLPixelAttributes gLPixelAttributes, int n, int n2, int n3, boolean bl, BufferedImage bufferedImage, Buffer buffer, boolean bl2) {
        super(gLPixelAttributes, n, n2, n3, bl, buffer, bl2);
        this.image = bufferedImage;
    }

    @Override
    public void dispose() {
        this.image.flush();
        super.dispose();
    }

    public BufferedImage getAlignedImage(int n, int n2) throws IllegalArgumentException {
        if (n * n2 > this.image.getWidth() * this.image.getHeight()) {
            throw new IllegalArgumentException("Requested size exceeds image size: " + n + "x" + n2 + " > " + this.image.getWidth() + "x" + this.image.getHeight());
        }
        if (n == this.image.getWidth()) {
            if (n2 == this.image.getHeight()) {
                return this.image;
            }
            return this.image.getSubimage(0, 0, n, n2);
        }
        ColorModel colorModel = this.image.getColorModel();
        WritableRaster writableRaster = this.image.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = new SinglePixelPackedSampleModel(dataBuffer.getDataType(), n, n2, n, singlePixelPackedSampleModel.getBitMasks());
        WritableRaster writableRaster2 = WritableRaster.createWritableRaster(singlePixelPackedSampleModel2, dataBuffer, null);
        return new BufferedImage(colorModel, writableRaster2, colorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        stringBuilder = super.toString(stringBuilder);
        stringBuilder.append(", allowRowStride ").append(this.allowRowStride).append(", image [").append(this.image.getWidth()).append("x").append(this.image.getHeight()).append(", ").append(this.image.toString()).append("]");
        return stringBuilder;
    }

    @Override
    public String toString() {
        return "AWTGLPixelBuffer[" + this.toString(null).toString() + "]";
    }

    public static class SingleAWTGLPixelBufferProvider
    extends AWTGLPixelBufferProvider
    implements GLPixelBuffer.SingletonGLPixelBufferProvider {
        private AWTGLPixelBuffer singleRGBA4 = null;
        private AWTGLPixelBuffer singleRGB3 = null;

        public SingleAWTGLPixelBufferProvider(boolean bl) {
            super(bl);
        }

        @Override
        public AWTGLPixelBuffer allocate(GL gL, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, int n, int n2, int n3, boolean bl, int n4) {
            if (4 == gLPixelAttributes.componentCount) {
                if (null == this.singleRGBA4 || this.singleRGBA4.requiresNewBuffer(gL, n, n2, n4)) {
                    this.singleRGBA4 = this.allocateImpl(gLPixelAttributes, n, n2, n3, bl, n4);
                }
                return this.singleRGBA4;
            }
            if (null == this.singleRGB3 || this.singleRGB3.requiresNewBuffer(gL, n, n2, n4)) {
                this.singleRGB3 = this.allocateImpl(gLPixelAttributes, n, n2, n3, bl, n4);
            }
            return this.singleRGB3;
        }

        private AWTGLPixelBuffer allocateImpl(GLPixelBuffer.GLPixelAttributes gLPixelAttributes, int n, int n2, int n3, boolean bl, int n4) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 4 == gLPixelAttributes.componentCount ? 2 : 1);
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            return new AWTGLPixelBuffer(gLPixelAttributes, n, n2, n3, bl, bufferedImage, intBuffer, this.getAllowRowStride());
        }

        @Override
        public AWTGLPixelBuffer getSingleBuffer(GLPixelBuffer.GLPixelAttributes gLPixelAttributes) {
            return 4 == gLPixelAttributes.componentCount ? this.singleRGBA4 : this.singleRGB3;
        }

        @Override
        public AWTGLPixelBuffer initSingleton(int n, int n2, int n3, int n4, boolean bl) {
            if (4 == n) {
                if (null != this.singleRGBA4) {
                    return null;
                }
                this.singleRGBA4 = this.allocateImpl(awtPixelAttributesIntRGBA4, n2, n3, n4, bl, 0);
                return this.singleRGBA4;
            }
            if (null != this.singleRGB3) {
                return null;
            }
            this.singleRGB3 = this.allocateImpl(awtPixelAttributesIntRGB3, n2, n3, n4, bl, 0);
            return this.singleRGB3;
        }
    }

    public static class AWTGLPixelBufferProvider
    implements GLPixelBuffer.GLPixelBufferProvider {
        private final boolean allowRowStride;

        public AWTGLPixelBufferProvider(boolean bl) {
            this.allowRowStride = bl;
        }

        @Override
        public boolean getAllowRowStride() {
            return this.allowRowStride;
        }

        @Override
        public GLPixelBuffer.GLPixelAttributes getAttributes(GL gL, int n) {
            return 4 == n ? awtPixelAttributesIntRGBA4 : awtPixelAttributesIntRGB3;
        }

        @Override
        public AWTGLPixelBuffer allocate(GL gL, GLPixelBuffer.GLPixelAttributes gLPixelAttributes, int n, int n2, int n3, boolean bl, int n4) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 4 == gLPixelAttributes.componentCount ? 2 : 1);
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            return new AWTGLPixelBuffer(gLPixelAttributes, n, n2, n3, bl, bufferedImage, intBuffer, this.allowRowStride);
        }
    }
}

