/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializer<T>
extends Serializer<T> {
    static final Object[] noArgs = new Object[0];
    private final Kryo kryo;
    private CachedProperty[] properties;
    Object access;

    public BeanSerializer(Kryo kryo, Class clazz) {
        BeanInfo beanInfo;
        this.kryo = kryo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new KryoException("Error getting bean info.", introspectionException);
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        Arrays.sort(propertyDescriptorArray, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
                return propertyDescriptor.getName().compareTo(propertyDescriptor2.getName());
            }
        });
        ArrayList arrayList = new ArrayList(propertyDescriptorArray.length);
        for (PropertyDescriptor object : propertyDescriptorArray) {
            String string = object.getName();
            if (string.equals("class")) continue;
            Method method = object.getReadMethod();
            Method method2 = object.getWriteMethod();
            if (method == null || method2 == null) continue;
            Serializer serializer = null;
            Class<?> clazz2 = method.getReturnType();
            if (kryo.isFinal(clazz2)) {
                serializer = kryo.getRegistration(clazz2).getSerializer();
            }
            CachedProperty cachedProperty = new CachedProperty();
            cachedProperty.name = string;
            cachedProperty.getMethod = method;
            cachedProperty.setMethod = method2;
            cachedProperty.serializer = serializer;
            cachedProperty.setMethodType = method2.getParameterTypes()[0];
            arrayList.add(cachedProperty);
        }
        this.properties = arrayList.toArray(new CachedProperty[arrayList.size()]);
        try {
            this.access = MethodAccess.get(clazz);
            for (CachedProperty cachedProperty : this.properties) {
                cachedProperty.getterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.getMethod.getName());
                cachedProperty.setterAccessIndex = ((MethodAccess)this.access).getIndex(cachedProperty.setMethod.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void write(Kryo kryo, Output output, T t) {
        Class<?> clazz = t.getClass();
        for (CachedProperty cachedProperty : this.properties) {
            Object object;
            try {
                Object object2 = cachedProperty.get(t);
                object = cachedProperty.serializer;
                if (object != null) {
                    kryo.writeObjectOrNull(output, object2, (Serializer)object);
                    continue;
                }
                kryo.writeClassAndObject(output, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new KryoException("Error accessing getter method: " + cachedProperty + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new KryoException("Error invoking getter method: " + cachedProperty + " (" + clazz.getName() + ")", invocationTargetException);
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(cachedProperty + " (" + clazz.getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                object = new KryoException(runtimeException);
                ((KryoException)object).addTrace(cachedProperty + " (" + clazz.getName() + ")");
                throw object;
            }
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> clazz) {
        T t = kryo.newInstance(clazz);
        kryo.reference(t);
        for (CachedProperty cachedProperty : this.properties) {
            Object object;
            try {
                object = cachedProperty.serializer;
                Object object2 = object != null ? kryo.readObjectOrNull(input, cachedProperty.setMethodType, (Serializer)object) : kryo.readClassAndObject(input);
                cachedProperty.set(t, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new KryoException("Error accessing setter method: " + cachedProperty + " (" + t.getClass().getName() + ")", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new KryoException("Error invoking setter method: " + cachedProperty + " (" + t.getClass().getName() + ")", invocationTargetException);
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(cachedProperty + " (" + t.getClass().getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                object = new KryoException(runtimeException);
                ((KryoException)object).addTrace(cachedProperty + " (" + t.getClass().getName() + ")");
                throw object;
            }
        }
        return t;
    }

    @Override
    public T copy(Kryo kryo, T t) {
        Object obj = kryo.newInstance(t.getClass());
        for (CachedProperty cachedProperty : this.properties) {
            try {
                Object object = cachedProperty.get(t);
                cachedProperty.set(obj, object);
            }
            catch (KryoException kryoException) {
                kryoException.addTrace(cachedProperty + " (" + obj.getClass().getName() + ")");
                throw kryoException;
            }
            catch (RuntimeException runtimeException) {
                KryoException kryoException = new KryoException(runtimeException);
                kryoException.addTrace(cachedProperty + " (" + obj.getClass().getName() + ")");
                throw kryoException;
            }
            catch (Exception exception) {
                throw new KryoException("Error copying bean property: " + cachedProperty + " (" + obj.getClass().getName() + ")", exception);
            }
        }
        return (T)obj;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CachedProperty<X> {
        String name;
        Method getMethod;
        Method setMethod;
        Class setMethodType;
        Serializer serializer;
        int getterAccessIndex;
        int setterAccessIndex;

        CachedProperty() {
        }

        public String toString() {
            return this.name;
        }

        Object get(Object object) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                return ((MethodAccess)BeanSerializer.this.access).invoke(object, this.getterAccessIndex, new Object[0]);
            }
            return this.getMethod.invoke(object, noArgs);
        }

        void set(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
            if (BeanSerializer.this.access != null) {
                ((MethodAccess)BeanSerializer.this.access).invoke(object, this.setterAccessIndex, object2);
                return;
            }
            this.setMethod.invoke(object, object2);
        }
    }
}

