/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.jsonbeans.JsonReader;
import com.esotericsoftware.jsonbeans.JsonSerializable;
import com.esotericsoftware.jsonbeans.JsonSerializer;
import com.esotericsoftware.jsonbeans.JsonWriter;
import com.esotericsoftware.jsonbeans.ObjectMap;
import com.esotericsoftware.jsonbeans.OrderedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Json {
    private static final boolean debug = false;
    private JsonWriter writer;
    private String typeName = "class";
    private boolean usePrototypes = true;
    private JsonWriter.OutputType outputType;
    private final ObjectMap<Class, ObjectMap<String, FieldMetadata>> typeToFields = new ObjectMap();
    private final ObjectMap<String, Class> tagToClass = new ObjectMap();
    private final ObjectMap<Class, String> classToTag = new ObjectMap();
    private final ObjectMap<Class, JsonSerializer> classToSerializer = new ObjectMap();
    private final ObjectMap<Class, Object[]> classToDefaultValues = new ObjectMap();
    private boolean ignoreUnknownFields;

    public Json() {
        this.outputType = JsonWriter.OutputType.minimal;
    }

    public Json(JsonWriter.OutputType outputType) {
        this.outputType = outputType;
    }

    public void setIgnoreUnknownFields(boolean bl) {
        this.ignoreUnknownFields = bl;
    }

    public void setOutputType(JsonWriter.OutputType outputType) {
        this.outputType = outputType;
    }

    public void addClassTag(String string, Class clazz) {
        this.tagToClass.put(string, clazz);
        this.classToTag.put(clazz, string);
    }

    public Class getClass(String string) {
        Class clazz = this.tagToClass.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JsonException(classNotFoundException);
        }
    }

    public String getTag(Class clazz) {
        String string = this.classToTag.get(clazz);
        if (string != null) {
            return string;
        }
        return clazz.getName();
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public <T> void setSerializer(Class<T> clazz, JsonSerializer<T> jsonSerializer) {
        this.classToSerializer.put(clazz, jsonSerializer);
    }

    public <T> JsonSerializer<T> getSerializer(Class<T> clazz) {
        return this.classToSerializer.get(clazz);
    }

    public void setUsePrototypes(boolean bl) {
        this.usePrototypes = bl;
    }

    public void setElementType(Class clazz, String string, Class clazz2) {
        FieldMetadata fieldMetadata;
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        if ((fieldMetadata = objectMap.get(string)) == null) {
            throw new JsonException("Field not found: " + string + " (" + clazz.getName() + ")");
        }
        fieldMetadata.elementType = clazz2;
    }

    private ObjectMap<String, FieldMetadata> cacheFields(Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Collections.addAll(arrayList, clazz2.getDeclaredFields());
        }
        ObjectMap<String, FieldMetadata> objectMap = new ObjectMap<String, FieldMetadata>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)arrayList.get(i);
            int n2 = field.getModifiers();
            if (Modifier.isTransient(n2) || Modifier.isStatic(n2) || field.isSynthetic()) continue;
            if (!field.isAccessible()) {
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {
                    continue;
                }
            }
            objectMap.put(field.getName(), new FieldMetadata(field));
        }
        this.typeToFields.put(clazz, objectMap);
        return objectMap;
    }

    public String toJson(Object object) {
        return this.toJson(object, object == null ? null : object.getClass(), (Class)null);
    }

    public String toJson(Object object, Class clazz) {
        return this.toJson(object, clazz, (Class)null);
    }

    public String toJson(Object object, Class clazz, Class clazz2) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, clazz, clazz2, stringWriter);
        return stringWriter.toString();
    }

    public void toJson(Object object, Writer writer) {
        this.toJson(object, object == null ? null : object.getClass(), null, writer);
    }

    public void toJson(Object object, Class clazz, Writer writer) {
        this.toJson(object, clazz, null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(Object object, Class clazz, Class clazz2, Writer writer) {
        if (!(writer instanceof JsonWriter)) {
            writer = new JsonWriter(writer);
        }
        ((JsonWriter)writer).setOutputType(this.outputType);
        this.writer = (JsonWriter)writer;
        try {
            this.writeValue(object, clazz, clazz2);
        }
        finally {
            this.writer = null;
        }
    }

    public void writeFields(Object object) {
        Class<?> clazz = object.getClass();
        Object[] objectArray = this.getDefaultValues(clazz);
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        int n = 0;
        for (FieldMetadata fieldMetadata : objectMap.values()) {
            Object object2;
            Field field = fieldMetadata.field;
            try {
                Object object3 = field.get(object);
                if (objectArray != null) {
                    object2 = objectArray[n++];
                    if (object3 == null && object2 == null || object3 != null && object2 != null && object3.equals(object2)) continue;
                }
                this.writer.name(field.getName());
                this.writeValue(object3, field.getType(), fieldMetadata.elementType);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (JsonException jsonException) {
                jsonException.addTrace(field + " (" + clazz.getName() + ")");
                throw jsonException;
            }
            catch (Exception exception) {
                object2 = new JsonException(exception);
                ((JsonException)object2).addTrace(field + " (" + clazz.getName() + ")");
                throw object2;
            }
        }
    }

    private Object[] getDefaultValues(Class clazz) {
        Object object;
        if (!this.usePrototypes) {
            return null;
        }
        if (this.classToDefaultValues.containsKey(clazz)) {
            return this.classToDefaultValues.get(clazz);
        }
        try {
            object = this.newInstance(clazz);
        }
        catch (Exception exception) {
            this.classToDefaultValues.put(clazz, null);
            return null;
        }
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        Object[] objectArray = new Object[objectMap.size];
        this.classToDefaultValues.put(clazz, objectArray);
        int n = 0;
        for (FieldMetadata fieldMetadata : objectMap.values()) {
            Field field = fieldMetadata.field;
            try {
                objectArray[n++] = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (JsonException jsonException) {
                jsonException.addTrace(field + " (" + clazz.getName() + ")");
                throw jsonException;
            }
            catch (RuntimeException runtimeException) {
                JsonException jsonException = new JsonException(runtimeException);
                jsonException.addTrace(field + " (" + clazz.getName() + ")");
                throw jsonException;
            }
        }
        return objectArray;
    }

    public void writeField(Object object, String string) {
        this.writeField(object, string, string, null);
    }

    public void writeField(Object object, String string, Class clazz) {
        this.writeField(object, string, string, clazz);
    }

    public void writeField(Object object, String string, String string2) {
        this.writeField(object, string, string2, null);
    }

    public void writeField(Object object, String string, String string2, Class clazz) {
        FieldMetadata fieldMetadata;
        Class<?> clazz2 = object.getClass();
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz2);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz2);
        }
        if ((fieldMetadata = objectMap.get(string)) == null) {
            throw new JsonException("Field not found: " + string + " (" + clazz2.getName() + ")");
        }
        Field field = fieldMetadata.field;
        if (clazz == null) {
            clazz = fieldMetadata.elementType;
        }
        try {
            this.writer.name(string2);
            this.writeValue(field.get(object), field.getType(), clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz2.getName() + ")", illegalAccessException);
        }
        catch (JsonException jsonException) {
            jsonException.addTrace(field + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
        catch (Exception exception) {
            JsonException jsonException = new JsonException(exception);
            jsonException.addTrace(field + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
    }

    public void writeValue(String string, Object object) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeValue(object, object.getClass(), null);
    }

    public void writeValue(String string, Object object, Class clazz) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeValue(object, clazz, null);
    }

    public void writeValue(String string, Object object, Class clazz, Class clazz2) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeValue(object, clazz, clazz2);
    }

    public void writeValue(Object object) {
        this.writeValue(object, object.getClass(), null);
    }

    public void writeValue(Object object, Class clazz) {
        this.writeValue(object, clazz, null);
    }

    public void writeValue(Object object, Class clazz, Class clazz2) {
        try {
            if (object == null) {
                this.writer.value(null);
                return;
            }
            Class<?> clazz3 = object.getClass();
            if (clazz3.isPrimitive() || clazz3 == String.class || clazz3 == Integer.class || clazz3 == Boolean.class || clazz3 == Float.class || clazz3 == Long.class || clazz3 == Double.class || clazz3 == Short.class || clazz3 == Byte.class || clazz3 == Character.class) {
                this.writer.value(object);
                return;
            }
            if (object instanceof JsonSerializable) {
                this.writeObjectStart(clazz3, clazz);
                ((JsonSerializable)object).write(this);
                this.writeObjectEnd();
                return;
            }
            JsonSerializer jsonSerializer = this.classToSerializer.get(clazz3);
            if (jsonSerializer != null) {
                jsonSerializer.write(this, object, clazz);
                return;
            }
            if (object instanceof Collection) {
                if (clazz != null && clazz3 != clazz) {
                    throw new JsonException("Serialization of a Collection other than the known type is not supported.\nKnown type: " + clazz + "\nActual type: " + clazz3);
                }
                this.writeArrayStart();
                for (Object e : (Collection)object) {
                    this.writeValue(e, clazz2, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (clazz3.isArray()) {
                if (clazz2 == null) {
                    clazz2 = clazz3.getComponentType();
                }
                int n = Array.getLength(object);
                this.writeArrayStart();
                for (int i = 0; i < n; ++i) {
                    this.writeValue(Array.get(object, i), clazz2, null);
                }
                this.writeArrayEnd();
                return;
            }
            if (object instanceof OrderedMap) {
                if (clazz == null) {
                    clazz = OrderedMap.class;
                }
                this.writeObjectStart(clazz3, clazz);
                OrderedMap orderedMap = (OrderedMap)object;
                for (Object k : orderedMap.orderedKeys()) {
                    this.writer.name(this.convertToString(k));
                    this.writeValue(orderedMap.get(k), clazz2, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof ObjectMap) {
                if (clazz == null) {
                    clazz = OrderedMap.class;
                }
                this.writeObjectStart(clazz3, clazz);
                for (ObjectMap.Entry entry : ((ObjectMap)object).entries()) {
                    this.writer.name(this.convertToString(entry.key));
                    this.writeValue(entry.value, clazz2, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (object instanceof Map) {
                if (clazz == null) {
                    clazz = OrderedMap.class;
                }
                this.writeObjectStart(clazz3, clazz);
                for (Map.Entry entry : ((Map)object).entrySet()) {
                    this.writer.name(this.convertToString(entry.getKey()));
                    this.writeValue(entry.getValue(), clazz2, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (clazz3.isEnum()) {
                this.writer.value(object);
                return;
            }
            this.writeObjectStart(clazz3, clazz);
            this.writeFields(object);
            this.writeObjectEnd();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeObjectStart(String string) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeObjectStart();
    }

    public void writeObjectStart(String string, Class clazz, Class clazz2) {
        try {
            this.writer.name(string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        this.writeObjectStart(clazz, clazz2);
    }

    public void writeObjectStart() {
        try {
            this.writer.object();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeObjectStart(Class clazz, Class clazz2) {
        try {
            this.writer.object();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
        if (clazz2 == null || clazz2 != clazz) {
            this.writeType(clazz);
        }
    }

    public void writeObjectEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeArrayStart(String string) {
        try {
            this.writer.name(string);
            this.writer.array();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeArrayStart() {
        try {
            this.writer.array();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeArrayEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public void writeType(Class clazz) {
        if (this.typeName == null) {
            return;
        }
        String string = this.classToTag.get(clazz);
        if (string == null) {
            string = clazz.getName();
        }
        try {
            this.writer.set(this.typeName, string);
        }
        catch (IOException iOException) {
            throw new JsonException(iOException);
        }
    }

    public <T> T fromJson(Class<T> clazz, Reader reader) {
        return this.readValue(clazz, null, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, Reader reader) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(reader));
    }

    public <T> T fromJson(Class<T> clazz, InputStream inputStream) {
        return this.readValue(clazz, null, new JsonReader().parse(inputStream));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, InputStream inputStream) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(inputStream));
    }

    public <T> T fromJson(Class<T> clazz, char[] cArray, int n, int n2) {
        return this.readValue(clazz, null, new JsonReader().parse(cArray, n, n2));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, char[] cArray, int n, int n2) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(cArray, n, n2));
    }

    public <T> T fromJson(Class<T> clazz, String string) {
        return this.readValue(clazz, null, new JsonReader().parse(string));
    }

    public <T> T fromJson(Class<T> clazz, Class clazz2, String string) {
        return this.readValue(clazz, clazz2, new JsonReader().parse(string));
    }

    public void readField(Object object, String string, Object object2) {
        this.readField(object, string, string, null, object2);
    }

    public void readField(Object object, String string, Class clazz, Object object2) {
        this.readField(object, string, string, clazz, object2);
    }

    public void readField(Object object, String string, String string2, Object object2) {
        this.readField(object, string, string2, null, object2);
    }

    public void readField(Object object, String string, String string2, Class clazz, Object object2) {
        FieldMetadata fieldMetadata;
        OrderedMap orderedMap = (OrderedMap)object2;
        Class<?> clazz2 = object.getClass();
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz2);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz2);
        }
        if ((fieldMetadata = objectMap.get(string)) == null) {
            throw new JsonException("Field not found: " + string + " (" + clazz2.getName() + ")");
        }
        Field field = fieldMetadata.field;
        Object v = orderedMap.get(string2);
        if (v == null) {
            return;
        }
        if (clazz == null) {
            clazz = fieldMetadata.elementType;
        }
        try {
            field.set(object, this.readValue(field.getType(), clazz, v));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz2.getName() + ")", illegalAccessException);
        }
        catch (JsonException jsonException) {
            jsonException.addTrace(field.getName() + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
        catch (RuntimeException runtimeException) {
            JsonException jsonException = new JsonException(runtimeException);
            jsonException.addTrace(field.getName() + " (" + clazz2.getName() + ")");
            throw jsonException;
        }
    }

    public void readFields(Object object, Object object2) {
        OrderedMap orderedMap = (OrderedMap)object2;
        Class<?> clazz = object.getClass();
        ObjectMap<String, FieldMetadata> objectMap = this.typeToFields.get(clazz);
        if (objectMap == null) {
            objectMap = this.cacheFields(clazz);
        }
        for (ObjectMap.Entry entry : orderedMap.entries()) {
            FieldMetadata fieldMetadata = objectMap.get((String)entry.key);
            if (fieldMetadata == null) {
                if (this.ignoreUnknownFields) continue;
                throw new JsonException("Field not found: " + (String)entry.key + " (" + clazz.getName() + ")");
            }
            Field field = fieldMetadata.field;
            if (entry.value == null) continue;
            try {
                field.set(object, this.readValue(field.getType(), fieldMetadata.elementType, entry.value));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + clazz.getName() + ")", illegalAccessException);
            }
            catch (JsonException jsonException) {
                jsonException.addTrace(field.getName() + " (" + clazz.getName() + ")");
                throw jsonException;
            }
            catch (RuntimeException runtimeException) {
                JsonException jsonException = new JsonException(runtimeException);
                jsonException.addTrace(field.getName() + " (" + clazz.getName() + ")");
                throw jsonException;
            }
        }
    }

    public <T> T readValue(String string, Class<T> clazz, Object object) {
        OrderedMap orderedMap = (OrderedMap)object;
        return this.readValue(clazz, null, orderedMap.get(string));
    }

    public <T> T readValue(String string, Class<T> clazz, T t, Object object) {
        OrderedMap orderedMap = (OrderedMap)object;
        Object v = orderedMap.get(string);
        if (v == null) {
            return t;
        }
        return this.readValue(clazz, null, v);
    }

    public <T> T readValue(String string, Class<T> clazz, Class clazz2, Object object) {
        OrderedMap orderedMap = (OrderedMap)object;
        return this.readValue(clazz, clazz2, orderedMap.get(string));
    }

    public <T> T readValue(String string, Class<T> clazz, Class clazz2, T t, Object object) {
        OrderedMap orderedMap = (OrderedMap)object;
        Object v = orderedMap.get(string);
        if (v == null) {
            return t;
        }
        return this.readValue(clazz, clazz2, v);
    }

    public <T> T readValue(Class<T> clazz, Class clazz2, T t, Object object) {
        return this.readValue(clazz, clazz2, object);
    }

    public <T> T readValue(Class<T> clazz, Object object) {
        return this.readValue(clazz, null, object);
    }

    public <T> T readValue(Class<T> clazz, Class clazz2, Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof OrderedMap) {
            Object object3;
            Object object4;
            OrderedMap orderedMap;
            block45: {
                String string;
                orderedMap = (OrderedMap)object;
                String string2 = string = this.typeName == null ? null : (String)orderedMap.remove(this.typeName);
                if (string != null) {
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = this.tagToClass.get(string);
                        if (clazz != null) break block45;
                        throw new JsonException(classNotFoundException);
                    }
                }
            }
            if (clazz != null) {
                object4 = this.classToSerializer.get(clazz);
                if (object4 != null) {
                    return object4.read(this, orderedMap, clazz);
                }
                object3 = this.newInstance(clazz);
                if (object3 instanceof JsonSerializable) {
                    ((JsonSerializable)object3).read(this, orderedMap);
                    return (T)object3;
                }
                if (object3 instanceof HashMap) {
                    HashMap hashMap = (HashMap)object3;
                    for (ObjectMap.Entry entry : orderedMap.entries()) {
                        hashMap.put(entry.key, this.readValue(clazz2, null, entry.value));
                    }
                    return (T)hashMap;
                }
            } else {
                object3 = new OrderedMap();
            }
            if (object3 instanceof ObjectMap) {
                object4 = (ObjectMap)object3;
                for (String string : orderedMap.orderedKeys()) {
                    ((ObjectMap)object4).put(string, this.readValue(clazz2, null, orderedMap.get(string)));
                }
                return (T)object4;
            }
            this.readFields(object3, orderedMap);
            return (T)object3;
        }
        if (clazz != null && (object2 = this.classToSerializer.get(clazz)) != null) {
            return object2.read(this, object, clazz);
        }
        if (object instanceof ArrayList) {
            object2 = (ArrayList)object;
            if (clazz == null || clazz.isAssignableFrom(ArrayList.class)) {
                ArrayList arrayList = new ArrayList(((ArrayList)object2).size());
                int n = ((ArrayList)object2).size();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(this.readValue(clazz2, null, ((ArrayList)object2).get(i)));
                }
                return (T)arrayList;
            }
            if (clazz.isArray()) {
                Class<?> clazz3 = clazz.getComponentType();
                if (clazz2 == null) {
                    clazz2 = clazz3;
                }
                Object object5 = Array.newInstance(clazz3, ((ArrayList)object2).size());
                int n = ((ArrayList)object2).size();
                for (int i = 0; i < n; ++i) {
                    Array.set(object5, i, this.readValue(clazz2, null, ((ArrayList)object2).get(i)));
                }
                return (T)object5;
            }
            throw new JsonException("Unable to convert value to required type: " + object + " (" + clazz.getName() + ")");
        }
        if (object instanceof Float) {
            object2 = (Float)object;
            try {
                if (clazz == null || clazz == Float.TYPE || clazz == Float.class) {
                    return (T)object2;
                }
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return (T)Integer.valueOf(((Float)object2).intValue());
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return (T)Long.valueOf(((Float)object2).longValue());
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return (T)Double.valueOf(((Float)object2).doubleValue());
                }
                if (clazz == Short.TYPE || clazz == Short.class) {
                    return (T)Short.valueOf(((Float)object2).shortValue());
                }
                if (clazz == Byte.TYPE || clazz == Byte.class) {
                    return (T)Byte.valueOf(((Float)object2).byteValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object = String.valueOf(object);
        }
        if (object instanceof Boolean) {
            object = String.valueOf(object);
        }
        if (object instanceof String) {
            object2 = (String)object;
            if (clazz == null || clazz == String.class) {
                return (T)object;
            }
            try {
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    return (T)Integer.valueOf((String)object2);
                }
                if (clazz == Float.TYPE || clazz == Float.class) {
                    return (T)Float.valueOf((String)object2);
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    return (T)Long.valueOf((String)object2);
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    return (T)Double.valueOf((String)object2);
                }
                if (clazz == Short.TYPE || clazz == Short.class) {
                    return (T)Short.valueOf((String)object2);
                }
                if (clazz == Byte.TYPE || clazz == Byte.class) {
                    return (T)Byte.valueOf((String)object2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return (T)Boolean.valueOf((String)object2);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return (T)Character.valueOf(((String)object2).charAt(0));
            }
            if (clazz.isEnum()) {
                Object[] objectArray = clazz.getEnumConstants();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!((String)object2).equals(objectArray[i].toString())) continue;
                    return (T)objectArray[i];
                }
            }
            if (clazz == CharSequence.class) {
                return (T)object2;
            }
            throw new JsonException("Unable to convert value to required type: " + object + " (" + clazz.getName() + ")");
        }
        return null;
    }

    private String convertToString(Object object) {
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    private Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Exception exception2;
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz.isArray()) {
                    throw new JsonException("Encountered JSON object when expected array of type: " + clazz.getName(), exception);
                }
                if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                    throw new JsonException("Class cannot be created (non-static member class): " + clazz.getName(), exception);
                }
                throw new JsonException("Class cannot be created (missing no-arg constructor): " + clazz.getName(), exception);
            }
            catch (Exception exception3) {
                exception2 = exception3;
            }
            throw new JsonException("Error constructing instance of class: " + clazz.getName(), exception2);
        }
    }

    public String prettyPrint(Object object) {
        return this.prettyPrint(object, 0);
    }

    public String prettyPrint(String string) {
        return this.prettyPrint(string, 0);
    }

    public String prettyPrint(Object object, int n) {
        return this.prettyPrint(this.toJson(object), n);
    }

    public String prettyPrint(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(512);
        this.prettyPrint(new JsonReader().parse(string), stringBuilder, 0, n);
        return stringBuilder.toString();
    }

    private void prettyPrint(Object object, StringBuilder stringBuilder, int n, int n2) {
        if (object instanceof OrderedMap) {
            OrderedMap orderedMap = (OrderedMap)object;
            if (orderedMap.size == 0) {
                stringBuilder.append("{}");
            } else {
                boolean bl = !Json.isFlat(orderedMap);
                int n3 = stringBuilder.length();
                block0: while (true) {
                    stringBuilder.append(bl ? "{\n" : "{ ");
                    int n4 = 0;
                    for (String string : orderedMap.orderedKeys()) {
                        if (bl) {
                            Json.indent(n, stringBuilder);
                        }
                        stringBuilder.append(this.outputType.quoteName(string));
                        stringBuilder.append(": ");
                        this.prettyPrint(orderedMap.get(string), stringBuilder, n + 1, n2);
                        if (n4++ < orderedMap.size - 1) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(bl ? (char)'\n' : ' ');
                        if (bl || stringBuilder.length() - n3 <= n2) continue;
                        stringBuilder.setLength(n3);
                        bl = true;
                        continue block0;
                    }
                    break;
                }
                if (bl) {
                    Json.indent(n - 1, stringBuilder);
                }
                stringBuilder.append('}');
            }
        } else if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.size() == 0) {
                stringBuilder.append("[]");
            } else {
                boolean bl = !Json.isFlat(arrayList);
                int n5 = stringBuilder.length();
                block2: while (true) {
                    stringBuilder.append(bl ? "[\n" : "[ ");
                    int n6 = arrayList.size();
                    for (int i = 0; i < n6; ++i) {
                        if (bl) {
                            Json.indent(n, stringBuilder);
                        }
                        this.prettyPrint(arrayList.get(i), stringBuilder, n + 1, n2);
                        if (i < arrayList.size() - 1) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(bl ? (char)'\n' : ' ');
                        if (bl || stringBuilder.length() - n5 <= n2) continue;
                        stringBuilder.setLength(n5);
                        bl = true;
                        continue block2;
                    }
                    break;
                }
                if (bl) {
                    Json.indent(n - 1, stringBuilder);
                }
                stringBuilder.append(']');
            }
        } else if (object instanceof String) {
            stringBuilder.append(this.outputType.quoteValue((String)object));
        } else if (object instanceof Float) {
            Float f = (Float)object;
            int n7 = f.intValue();
            stringBuilder.append(f.floatValue() - (float)n7 == 0.0f ? Integer.valueOf(n7) : object);
        } else if (object instanceof Boolean) {
            stringBuilder.append(object);
        } else if (object == null) {
            stringBuilder.append("null");
        } else {
            throw new JsonException("Unknown object type: " + object.getClass());
        }
    }

    private static boolean isFlat(ObjectMap<?, ?> objectMap) {
        for (ObjectMap.Entry<?, ?> entry : objectMap.entries()) {
            if (entry.value instanceof ObjectMap) {
                return false;
            }
            if (!(entry.value instanceof ArrayList)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFlat(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList.get(i);
            if (e instanceof ObjectMap) {
                return false;
            }
            if (!(e instanceof ArrayList)) continue;
            return false;
        }
        return true;
    }

    private static void indent(int n, StringBuilder stringBuilder) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
        }
    }

    private static class FieldMetadata {
        public Field field;
        public Class elementType;

        public FieldMetadata(Field field) {
            this.field = field;
        }
    }
}

