/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLProfile;
import org.junit.Assert;

public class NEWTGLContext {
    public static WindowContext createOffscreenWindow(GLCapabilities gLCapabilities, int n, int n2, boolean bl) throws InterruptedException {
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)window);
        window.setSize(n, n2);
        window.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(window, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, true));
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable((NativeSurface)window);
        Assert.assertNotNull((Object)gLDrawable);
        gLDrawable.setRealized(true);
        Assert.assertTrue((boolean)gLDrawable.isRealized());
        GLContext gLContext = gLDrawable.createContext(null);
        Assert.assertNotNull((Object)gLContext);
        gLContext.enableGLDebugMessage(bl);
        int n3 = gLContext.makeCurrent();
        Assert.assertTrue((2 == n3 || 1 == n3 ? 1 : 0) != 0);
        return new WindowContext(window, gLDrawable, gLContext);
    }

    public static WindowContext createOnscreenWindow(GLCapabilities gLCapabilities, int n, int n2, boolean bl) throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)window);
        window.setSize(n, n2);
        window.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(window, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, true));
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable((NativeSurface)window);
        Assert.assertNotNull((Object)gLDrawable);
        gLDrawable.setRealized(true);
        Assert.assertTrue((boolean)gLDrawable.isRealized());
        GLContext gLContext = gLDrawable.createContext(null);
        Assert.assertNotNull((Object)gLContext);
        gLContext.enableGLDebugMessage(bl);
        int n3 = gLContext.makeCurrent();
        Assert.assertTrue((2 == n3 || 1 == n3 ? 1 : 0) != 0);
        return new WindowContext(window, gLDrawable, gLContext);
    }

    public static void destroyWindow(WindowContext windowContext) {
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        Assert.assertNotNull((Object)windowContext.context);
        windowContext.context.destroy();
        Assert.assertNotNull((Object)gLDrawable);
        gLDrawable.setRealized(false);
        Assert.assertNotNull((Object)windowContext.window);
        windowContext.window.destroy();
    }

    public static class WindowContext {
        public final Window window;
        public final GLDrawable drawable;
        public final GLContext context;

        public WindowContext(Window window, GLDrawable gLDrawable, GLContext gLContext) {
            this.window = window;
            this.drawable = gLDrawable;
            this.context = gLContext;
        }
    }
}

