/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.util;

import com.jogamp.opengl.test.junit.util.KeyEventCountAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;

public class AWTKeyAdapter
extends KeyAdapter
implements KeyEventCountAdapter {
    String prefix;
    int keyPressed;
    int keyReleased;
    boolean pressed;
    List<EventObject> queue = new ArrayList<EventObject>();
    boolean verbose = true;

    public AWTKeyAdapter(String string) {
        this.prefix = string;
        this.reset();
    }

    @Override
    public synchronized void setVerbose(boolean bl) {
        this.verbose = false;
    }

    @Override
    public synchronized boolean isPressed() {
        return this.pressed;
    }

    @Override
    public synchronized int getCount() {
        return this.keyReleased;
    }

    @Override
    public synchronized int getKeyPressedCount(boolean bl) {
        return this.keyPressed;
    }

    @Override
    public synchronized int getKeyReleasedCount(boolean bl) {
        return this.keyReleased;
    }

    @Override
    public synchronized List<EventObject> getQueued() {
        return this.queue;
    }

    @Override
    public synchronized int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public synchronized void reset() {
        this.keyPressed = 0;
        this.keyReleased = 0;
        this.pressed = false;
        this.queue.clear();
    }

    @Override
    public synchronized void keyPressed(KeyEvent keyEvent) {
        this.pressed = true;
        ++this.keyPressed;
        this.queue.add(keyEvent);
        if (this.verbose) {
            System.err.println("KEY AWT PRESSED [" + this.pressed + "]: " + this.prefix + ", " + keyEvent);
        }
    }

    @Override
    public synchronized void keyReleased(KeyEvent keyEvent) {
        this.pressed = false;
        ++this.keyReleased;
        this.queue.add(keyEvent);
        if (this.verbose) {
            System.err.println("KEY AWT RELEASED [" + this.pressed + "]: " + this.prefix + ", " + keyEvent);
        }
    }

    public String toString() {
        return this.prefix + "[pressed " + this.pressed + ", keyReleased " + this.keyReleased + "]";
    }
}

