/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTranslucentParentingAWT
extends UITestCase {
    static Dimension size;
    static long durationPerTest;
    static long waitAdd2nd;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        size = new Dimension(400, 200);
        glCaps = new GLCapabilities(null);
        glCaps.setBackgroundOpaque(false);
    }

    @Test
    public void testWindowParenting1AWTOneNewtChild01() throws InterruptedException, InvocationTargetException {
        this.testWindowParenting1AWTOneNewtChild();
    }

    static Frame getTranslucentFrame() {
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        block2: for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i].getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[j];
                ColorModel colorModel = graphicsConfiguration2.getColorModel(3);
                boolean bl = null != colorModel ? colorModel.getTransparency() == 3 : false;
                boolean bl2 = false;
                try {
                    bl2 = (Boolean)ReflectionUtil.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"isTranslucencyCapable", (Class[])new Class[]{GraphicsConfiguration.class}, (Object[])new Object[]{graphicsConfiguration2}, (ClassLoader)GraphicsConfiguration.class.getClassLoader());
                    System.err.println("com.sun.awt.AWTUtilities.isTranslucencyCapable(config) passed: " + bl2);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("com.sun.awt.AWTUtilities.isTranslucencyCapable(config) failed: " + runtimeException.getMessage());
                }
                System.err.println(i + ":" + j + " " + graphicsConfiguration2 + ", " + colorModel + ", capable " + bl + "/" + bl2);
                if (!bl || !bl2) continue;
                graphicsConfiguration = graphicsConfigurationArray[j];
                System.err.println("Chosen " + i + ":" + j + " " + graphicsConfiguration2 + ", " + colorModel + ", capable " + bl + "/" + bl2);
                continue block2;
            }
        }
        Frame frame = new Frame(graphicsConfiguration);
        if (null != graphicsConfiguration) {
            frame.setUndecorated(true);
            frame.setBackground(new Color(0, 0, 0, 0));
        }
        frame.setTitle("AWT Parent Frame (opaque: " + (null == graphicsConfiguration) + ")");
        return frame;
    }

    public void testWindowParenting1AWTOneNewtChild() throws InterruptedException, InvocationTargetException {
        final Frame frame = TestTranslucentParentingAWT.getTranslucentFrame();
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)glCaps);
        gLWindow.setUpdateFPSFrames(1, null);
        gLWindow.setUndecorated(true);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(frame.getGraphicsConfiguration(), (Window)gLWindow);
        newtCanvasAWT.setPreferredSize(size);
        GearsES2 gearsES2 = new GearsES2(1);
        TestTranslucentParentingAWT.setDemoFields(gearsES2, gLWindow, false);
        gLWindow.addGLEventListener((GLEventListener)gearsES2);
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        Container container = new Container();
        container.setLayout(new BorderLayout());
        container.add((Component)newtCanvasAWT, "Center");
        container.setVisible(true);
        frame.setLayout(new BorderLayout());
        frame.add((Component)container, "East");
        frame.add((Component)new Label("center"), "Center");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setLocation(0, 0);
                frame.setSize((int)size.getWidth(), (int)size.getHeight());
                frame.pack();
                frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)newtCanvasAWT.getNativeWindow(), (Object)gLWindow.getParent());
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertNotNull((Object)animator.getThread());
        Thread.sleep(durationPerTest);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals(null, (Object)animator.getThread());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.dispose();
            }
        });
        gLWindow.destroy();
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull((Object)gLEventListener);
        Assert.assertNotNull((Object)gLWindow);
        Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitAdd2nd = MiscUtils.atol(stringArray[++i], waitAdd2nd);
        }
        String string = TestTranslucentParentingAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 400L;
        waitAdd2nd = 200L;
    }
}

