/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.parenting;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.newt.parenting.NewtAWTReparentingKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.AWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NEWTFocusAdapter;
import com.jogamp.opengl.test.junit.util.NEWTKeyAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.SwingUtilities;
import jogamp.newt.driver.DriverClearFocus;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestParentingFocusTraversal01AWT
extends UITestCase {
    static Dimension glSize;
    static Dimension fSize;
    static int numFocus;
    static long durationPerTest;
    static GLCapabilities glCaps;
    static boolean manual;
    static boolean forceGL3;

    @BeforeClass
    public static void initClass() {
        glSize = new Dimension(200, 200);
        fSize = new Dimension(300, 300);
        glCaps = new GLCapabilities(forceGL3 ? GLProfile.get((String)"GL3") : null);
    }

    @Test
    public void testWindowParentingAWTFocusTraversal01Onscreen() throws InterruptedException, InvocationTargetException, AWTException {
        this.testWindowParentingAWTFocusTraversal(true);
    }

    @Test
    public void testWindowParentingAWTFocusTraversal02Offscreen() throws InterruptedException, InvocationTargetException, AWTException {
        this.testWindowParentingAWTFocusTraversal(false);
    }

    public void testWindowParentingAWTFocusTraversal(boolean bl) throws InterruptedException, InvocationTargetException, AWTException {
        Robot robot = new Robot();
        Object object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object object2 = ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(1);
        Object object3 = AWTKeyStroke.getAWTKeyStroke(8, 0, false);
        Assert.assertNotNull((Object)object3);
        final GLWindow gLWindow = new HashSet<AWTKeyStroke>((Collection<AWTKeyStroke>)object2);
        gLWindow.add((AWTKeyStroke)object3);
        ((KeyboardFocusManager)object).setDefaultFocusTraversalKeys(1, (Set<? extends AWTKeyStroke>)gLWindow);
        object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        object2 = ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(0);
        object3 = ((KeyboardFocusManager)object).getDefaultFocusTraversalKeys(1);
        gLWindow = object2.iterator();
        while (gLWindow.hasNext()) {
            System.err.println("FTKL.fwd-keys: " + gLWindow.next());
        }
        gLWindow = object3.iterator();
        while (gLWindow.hasNext()) {
            System.err.println("FTKL.bwd-keys: " + gLWindow.next());
        }
        object = new Frame("AWT Parent Frame");
        object2 = new Button("WEST");
        object3 = new Button("EAST");
        gLWindow = GLWindow.create((GLCapabilitiesImmutable)glCaps);
        gLWindow.setUpdateFPSFrames(1, null);
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((com.jogamp.newt.Window)gLWindow);
        newtCanvasAWT.setPreferredSize(glSize);
        newtCanvasAWT.setShallUseOffscreenLayer(!bl);
        newtCanvasAWT.setFocusable(true);
        NEWTFocusAdapter nEWTFocusAdapter = new NEWTFocusAdapter("GLWindow1");
        gLWindow.addWindowListener((WindowListener)nEWTFocusAdapter);
        AWTFocusAdapter aWTFocusAdapter = new AWTFocusAdapter("WEST");
        ((Component)object2).addFocusListener(aWTFocusAdapter);
        AWTFocusAdapter aWTFocusAdapter2 = new AWTFocusAdapter("EAST");
        ((Component)object3).addFocusListener(aWTFocusAdapter2);
        NEWTKeyAdapter nEWTKeyAdapter = new NEWTKeyAdapter("GLWindow1");
        gLWindow.addKeyListener((KeyListener)nEWTKeyAdapter);
        AWTKeyAdapter aWTKeyAdapter = new AWTKeyAdapter("West");
        ((Component)object2).addKeyListener(aWTKeyAdapter);
        AWTKeyAdapter aWTKeyAdapter2 = new AWTKeyAdapter("East");
        ((Component)object3).addKeyListener(aWTKeyAdapter2);
        GearsES2 gearsES2 = new GearsES2(1);
        TestParentingFocusTraversal01AWT.setDemoFields(gearsES2, gLWindow, false);
        gLWindow.addGLEventListener((GLEventListener)gearsES2);
        gLWindow.addKeyListener((KeyListener)new NewtAWTReparentingKeyAdapter((Frame)object, newtCanvasAWT, gLWindow, null));
        gLWindow.addKeyListener((KeyListener)new KeyAdapter((Button)object3, (Button)object2){
            final /* synthetic */ Button val$cEast;
            final /* synthetic */ Button val$cWest;
            {
                this.val$cEast = button;
                this.val$cWest = button2;
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isPrintableKey() || keyEvent.isAutoRepeat()) {
                    return;
                }
                if (keyEvent.getKeyChar() == 'c') {
                    System.err.println("Focus Clear");
                    if (gLWindow.getDelegatedWindow() instanceof DriverClearFocus) {
                        ((DriverClearFocus)gLWindow.getDelegatedWindow()).clearFocus();
                    }
                } else if (keyEvent.getKeyChar() == 'e') {
                    System.err.println("Focus East");
                    try {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                val$cEast.requestFocusInWindow();
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (keyEvent.getKeyChar() == 'w') {
                    System.err.println("Focus West");
                    try {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                val$cWest.requestFocusInWindow();
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)object2, "West");
        ((Container)object).add((Component)newtCanvasAWT, "Center");
        ((Container)object).add((Component)object3, "East");
        SwingUtilities.invokeAndWait(new Runnable((Frame)object){
            final /* synthetic */ Frame val$frame1;
            {
                this.val$frame1 = frame;
            }

            @Override
            public void run() {
                this.val$frame1.setLocation(0, 0);
                this.val$frame1.setSize(fSize);
                this.val$frame1.validate();
                this.val$frame1.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertEquals((Object)newtCanvasAWT.getNativeWindow(), (Object)gLWindow.getParent());
        AWTRobotUtil.clearAWTFocus(robot);
        Assert.assertTrue((boolean)AWTRobotUtil.toFrontAndRequestFocus(robot, (Window)object));
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertNotNull((Object)animator.getThread());
        if (manual) {
            Thread.sleep(durationPerTest);
        } else {
            AWTRobotUtil.assertRequestFocusAndWait(robot, object2, object2, aWTFocusAdapter, null);
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 9, object2, null);
            Assert.assertTrue((String)"Did not gain focus", (boolean)AWTRobotUtil.waitForFocus(gLWindow, nEWTFocusAdapter, aWTFocusAdapter));
            Assert.assertEquals((Object)true, (Object)nEWTFocusAdapter.focusGained());
            Assert.assertEquals((Object)true, (Object)aWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 9, gLWindow, null);
            Assert.assertTrue((String)"Did not gain focus", (boolean)AWTRobotUtil.waitForFocus(object3, aWTFocusAdapter2, nEWTFocusAdapter));
            Assert.assertEquals((Object)true, (Object)aWTFocusAdapter2.focusGained());
            Assert.assertEquals((Object)true, (Object)nEWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 8, object3, null);
            Assert.assertTrue((String)"Did not gain focus", (boolean)AWTRobotUtil.waitForFocus(gLWindow, nEWTFocusAdapter, aWTFocusAdapter2));
            Assert.assertEquals((Object)true, (Object)nEWTFocusAdapter.focusGained());
            Assert.assertEquals((Object)true, (Object)aWTFocusAdapter2.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            AWTRobotUtil.keyType(0, robot, 8, gLWindow, null);
            Assert.assertTrue((String)"Did not gain focus", (boolean)AWTRobotUtil.waitForFocus(object2, aWTFocusAdapter, nEWTFocusAdapter));
            Assert.assertEquals((Object)true, (Object)aWTFocusAdapter.focusGained());
            Assert.assertEquals((Object)true, (Object)nEWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            System.err.println("Test: Direct NewtCanvasAWT focus");
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        newtCanvasAWT.requestFocus();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Assert.assertTrue((String)"Did not gain focus", (boolean)AWTRobotUtil.waitForFocus(gLWindow, nEWTFocusAdapter, aWTFocusAdapter));
            Assert.assertEquals((Object)true, (Object)nEWTFocusAdapter.focusGained());
            Assert.assertEquals((Object)true, (Object)aWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            System.err.println("Test: Direct AWT Button-West focus");
            try {
                EventQueue.invokeAndWait(new Runnable((Button)object2){
                    final /* synthetic */ Button val$cWest;
                    {
                        this.val$cWest = button;
                    }

                    @Override
                    public void run() {
                        this.val$cWest.requestFocus();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Assert.assertTrue((String)"Did not gain focus", (boolean)AWTRobotUtil.waitForFocus(object2, aWTFocusAdapter, nEWTFocusAdapter));
            Assert.assertEquals((Object)true, (Object)aWTFocusAdapter.focusGained());
            Assert.assertEquals((Object)true, (Object)nEWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
            System.err.println("Test: Direct NEWT-Child request focus");
            gLWindow.requestFocus();
            Assert.assertTrue((String)"Did not gain focus", (boolean)AWTRobotUtil.waitForFocus(gLWindow, nEWTFocusAdapter, aWTFocusAdapter));
            Assert.assertEquals((Object)true, (Object)nEWTFocusAdapter.focusGained());
            Assert.assertEquals((Object)true, (Object)aWTFocusAdapter.focusLost());
            Thread.sleep(durationPerTest / (long)numFocus);
        }
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isPaused());
        Assert.assertEquals(null, (Object)animator.getThread());
        SwingUtilities.invokeAndWait(new Runnable((Frame)object){
            final /* synthetic */ Frame val$frame1;
            {
                this.val$frame1 = frame;
            }

            @Override
            public void run() {
                this.val$frame1.dispose();
            }
        });
        gLWindow.destroy();
    }

    public static void setDemoFields(GLEventListener gLEventListener, GLWindow gLWindow, boolean bl) {
        Assert.assertNotNull((Object)gLEventListener);
        Assert.assertNotNull((Object)gLWindow);
        com.jogamp.newt.Window window = gLWindow.getDelegatedWindow();
        if (bl) {
            MiscUtils.setFieldIfExists(gLEventListener, "glDebug", true);
            MiscUtils.setFieldIfExists(gLEventListener, "glTrace", true);
        }
        if (!MiscUtils.setFieldIfExists(gLEventListener, "window", window)) {
            MiscUtils.setFieldIfExists(gLEventListener, "glWindow", gLWindow);
        }
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = TestParentingFocusTraversal01AWT.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-manual")) {
                manual = true;
                continue;
            }
            if (!stringArray[i].equals("-gl3")) continue;
            forceGL3 = true;
        }
        String string = TestParentingFocusTraversal01AWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        numFocus = 8;
        durationPerTest = numFocus * 200;
        manual = false;
        forceGL3 = false;
    }
}

