/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.List;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.RectangleImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode01bNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static long waitTimeShort;
    static long duration;

    @BeforeClass
    public static void initClass() {
        TestScreenMode01bNEWT.setResetXRandRIfX11AfterClass();
        width = 200;
        height = 200;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) throws InterruptedException {
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(string);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener((GLEventListener)new GearsES2());
        Assert.assertNotNull((Object)gLWindow);
        long l = System.currentTimeMillis();
        gLWindow.setVisible(true);
        System.err.println("Time for visible/pos: " + (System.currentTimeMillis() - l) + " ms");
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenModeChangeSingleQ1() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.addReference();
        try {
            RectangleImmutable rectangleImmutable = ((MonitorDevice)screen.getMonitorDevices().get(0)).getViewport();
            this.testScreenModeChangeImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY());
        }
        finally {
            screen.removeReference();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScreenModeChangeSingleQ2() throws InterruptedException {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.addReference();
        try {
            if (2 > screen.getMonitorDevices().size()) {
                System.err.println("Test Disabled (1): Monitor count < 2: " + screen);
                return;
            }
            RectangleImmutable rectangleImmutable = ((MonitorDevice)screen.getMonitorDevices().get(1)).getViewport();
            this.testScreenModeChangeImpl(screen, rectangleImmutable.getX(), rectangleImmutable.getY());
        }
        finally {
            screen.removeReference();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        }
    }

    void testScreenModeChangeImpl(Screen screen, int n, int n2) throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = screen.getDisplay();
        System.err.println("Test.0: Window screen: " + screen);
        System.err.println("Test.0: Window bounds (pre): " + n + "/" + n2 + " " + width + "x" + height + " within " + screen.getViewport());
        GLWindow gLWindow = TestScreenMode01bNEWT.createWindow(screen, gLCapabilities, "win0", n, n2, width, height);
        Assert.assertNotNull((Object)gLWindow);
        System.err.println("Test.0: Window bounds: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + " within " + screen.getViewport());
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        animator.start();
        List list = screen.getMonitorModes();
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (all), sorry");
            TestScreenMode01bNEWT.destroyWindow((Window)gLWindow);
            return;
        }
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        System.err.println("Test.0: Window monitor: " + monitorDevice);
        List list2 = monitorDevice.getSupportedModes();
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        if (list2.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (monitor), sorry");
            TestScreenMode01bNEWT.destroyWindow((Window)gLWindow);
            return;
        }
        Assert.assertTrue((boolean)list.containsAll(list2));
        MonitorMode monitorMode = monitorDevice.getCurrentMode();
        Assert.assertNotNull((Object)monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull((Object)monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorMode2);
        list2 = MonitorModeUtil.filterByFlags((List)list2, (int)0);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRotation((List)list2, (int)0);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByResolution((List)list2, (DimensionImmutable)new Dimension(801, 601));
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRate((List)list2, (float)monitorMode2.getRefreshRate());
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.getHighestAvailableBpp((List)list2);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        MonitorMode monitorMode3 = (MonitorMode)list2.get(0);
        System.err.println("[0] set current: " + monitorMode3);
        boolean bl = monitorDevice.setCurrentMode(monitorMode3);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[0] has current: " + monitorMode + ", changeOK " + bl);
        Assert.assertTrue((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode3, (Object)monitorMode);
        Assert.assertNotSame((Object)monitorMode2, (Object)monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.queryCurrentMode());
        Assert.assertTrue((boolean)bl);
        System.err.println("Test.1: Window screen: " + screen);
        System.err.println("Test.1: Window bounds: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + " within " + screen.getViewport());
        System.err.println("Test.1: Window monitor: " + gLWindow.getMainMonitor());
        Thread.sleep(duration);
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        System.err.println("[1] set orig: " + monitorMode2);
        boolean bl2 = monitorDevice.setCurrentMode(monitorMode2);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[1] has orig?: " + monitorMode + ", changeOK " + bl2);
        Assert.assertFalse((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode2, (Object)monitorMode);
        Assert.assertTrue((boolean)bl2);
        System.err.println("Test.2: Window screen: " + screen);
        System.err.println("Test.2: Window bounds: " + gLWindow.getX() + "/" + gLWindow.getY() + " " + gLWindow.getWidth() + "x" + gLWindow.getHeight() + " within " + screen.getViewport());
        System.err.println("Test.2: Window monitor: " + gLWindow.getMainMonitor());
        Thread.sleep(duration);
        animator.stop();
        TestScreenMode01bNEWT.destroyWindow((Window)gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        String string = TestScreenMode01bNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        waitTimeShort = 2000L;
        duration = 6000L;
    }
}

