/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.util.List;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.util.Dimension;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode00cNEWT
extends UITestCase {
    static boolean manualTest = false;
    static GLProfile glp;
    static int width;
    static int height;
    static final int waitTimeShort = 2000;
    static long duration;

    @BeforeClass
    public static void initClass() {
        TestScreenMode00cNEWT.setResetXRandRIfX11AfterClass();
        NativeWindowFactory.initSingleton();
        if (!manualTest || NativeWindowFactory.TYPE_X11 != NativeWindowFactory.getNativeWindowType((boolean)true)) {
            TestScreenMode00cNEWT.setTestSupported(false);
            return;
        }
        width = 100;
        height = 100;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(2000L);
    }

    static Window createWindow(Screen screen, GLCapabilities gLCapabilities, String string, int n, int n2, int n3, int n4) {
        Assert.assertNotNull((Object)gLCapabilities);
        GLWindow gLWindow = GLWindow.create((Screen)screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setTitle(string);
        gLWindow.setPosition(n, n2);
        gLWindow.setSize(n3, n4);
        gLWindow.addGLEventListener((GLEventListener)new GearsES2());
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, false));
        }
    }

    @Test
    public void testScreenModeChange01() throws InterruptedException {
        Thread.sleep(2000L);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = TestScreenMode00cNEWT.createWindow(screen, gLCapabilities, "win0", 0, 0, width, height);
        Assert.assertNotNull((Object)window);
        List list = screen.getMonitorModes();
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (all), sorry");
            TestScreenMode00cNEWT.destroyWindow(window);
            return;
        }
        MonitorDevice monitorDevice = (MonitorDevice)screen.getMonitorDevices().get(0);
        List list2 = monitorDevice.getSupportedModes();
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        if (list2.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support (monitor), sorry");
            TestScreenMode00cNEWT.destroyWindow(window);
            return;
        }
        Assert.assertTrue((boolean)list.containsAll(list2));
        MonitorMode monitorMode = monitorDevice.queryCurrentMode();
        Assert.assertNotNull((Object)monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull((Object)monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorMode2);
        list2 = MonitorModeUtil.filterByFlags((List)list2, (int)0);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRotation((List)list2, (int)0);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByResolution((List)list2, (DimensionImmutable)new Dimension(801, 601));
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.filterByRate((List)list2, (float)monitorMode2.getRefreshRate());
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        list2 = MonitorModeUtil.getHighestAvailableBpp((List)list2);
        Assert.assertNotNull((Object)list2);
        Assert.assertTrue((list2.size() > 0 ? 1 : 0) != 0);
        MonitorMode monitorMode3 = (MonitorMode)list2.get(0);
        System.err.println("[0] set current: " + monitorMode3);
        boolean bl = monitorDevice.setCurrentMode(monitorMode3);
        MonitorMode monitorMode4 = monitorDevice.getCurrentMode();
        System.err.println("[0] has current: " + monitorMode4 + ", changeOK " + bl);
        Assert.assertTrue((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode3, (Object)monitorMode4);
        Assert.assertNotSame((Object)monitorMode2, (Object)monitorMode4);
        Assert.assertEquals((Object)monitorMode4, (Object)monitorDevice.queryCurrentMode());
        Assert.assertTrue((boolean)bl);
        Thread.sleep(duration);
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)window.isNativeValid());
        Assert.assertEquals((Object)true, (Object)window.isVisible());
        UITestCase.resetXRandRIfX11();
        System.err.println("XRandR Reset :" + monitorDevice.queryCurrentMode());
        this.validateScreenModeReset0(monitorMode2);
        TestScreenMode00cNEWT.destroyWindow(window);
        Thread.sleep(2000L);
        this.validateScreenModeReset(monitorMode2);
    }

    void validateScreenModeReset0(MonitorMode monitorMode) {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        screen.addReference();
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        MonitorDevice monitorDevice = (MonitorDevice)screen.getMonitorDevices().get(0);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.queryCurrentMode());
        screen.removeReference();
    }

    void validateScreenModeReset(MonitorMode monitorMode) {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        screen.addReference();
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        MonitorDevice monitorDevice = (MonitorDevice)screen.getMonitorDevices().get(0);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.getCurrentMode());
        screen.removeReference();
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        manualTest = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        String string = TestScreenMode00cNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        duration = 2000L;
    }
}

