/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestWindowClosingProtocol03NewtAWT
extends UITestCase {
    @Test
    public void testCloseJFrameNewtCanvasAWT() throws InterruptedException, InvocationTargetException {
        final JFrame jFrame = new JFrame("testCloseJFrameNewtCanvasAWT");
        AWTRobotUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(jFrame);
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        AWTRobotUtil.WindowClosingListener windowClosingListener2 = AWTRobotUtil.addClosingListener(gLWindow);
        gLWindow.addGLEventListener((GLEventListener)new GearsES2());
        final NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT((Window)gLWindow);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.getContentPane().add((Component)newtCanvasAWT);
                jFrame.pack();
                jFrame.setSize(512, 512);
                jFrame.validate();
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertEquals((Object)true, (Object)jFrame.isDisplayable());
        Assert.assertEquals((Object)true, (Object)jFrame.isVisible());
        Assert.assertEquals((Object)true, (Object)newtCanvasAWT.isValid());
        Assert.assertEquals((Object)true, (Object)newtCanvasAWT.isDisplayable());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((long)1L, (long)jFrame.getDefaultCloseOperation());
        WindowClosingProtocol.WindowClosingMode windowClosingMode = newtCanvasAWT.getDefaultCloseOperation();
        Assert.assertEquals((Object)WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE, (Object)windowClosingMode);
        Thread.sleep(300L);
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.closeWindow(jFrame, false, windowClosingListener));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, false));
        Assert.assertEquals((Object)true, (Object)jFrame.isDisplayable());
        Assert.assertEquals((Object)false, (Object)jFrame.isVisible());
        Assert.assertEquals((Object)true, (Object)newtCanvasAWT.isValid());
        Assert.assertEquals((Object)true, (Object)newtCanvasAWT.isDisplayable());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)windowClosingListener.isWindowClosing());
        Assert.assertEquals((Object)false, (Object)windowClosingListener.isWindowClosed());
        Assert.assertEquals((Object)true, (Object)windowClosingListener2.isWindowClosing());
        Assert.assertEquals((Object)false, (Object)windowClosingListener2.isWindowClosed());
        windowClosingListener.reset();
        windowClosingListener2.reset();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertEquals((Object)true, (Object)jFrame.isDisplayable());
        Assert.assertEquals((Object)true, (Object)jFrame.isVisible());
        jFrame.setDefaultCloseOperation(2);
        Assert.assertEquals((long)2L, (long)jFrame.getDefaultCloseOperation());
        windowClosingMode = newtCanvasAWT.getDefaultCloseOperation();
        Assert.assertEquals((Object)WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE, (Object)windowClosingMode);
        Thread.sleep(300L);
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.closeWindow(jFrame, true, windowClosingListener));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, false));
        Assert.assertEquals((Object)false, (Object)jFrame.isDisplayable());
        Assert.assertEquals((Object)false, (Object)jFrame.isVisible());
        Assert.assertEquals((Object)false, (Object)newtCanvasAWT.isValid());
        Assert.assertEquals((Object)false, (Object)newtCanvasAWT.isDisplayable());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)windowClosingListener.isWindowClosing());
        Assert.assertEquals((Object)true, (Object)windowClosingListener.isWindowClosed());
        Assert.assertEquals((Object)true, (Object)windowClosingListener2.isWindowClosing());
        Assert.assertEquals((Object)true, (Object)windowClosingListener2.isWindowClosed());
    }

    public static void main(String[] stringArray) {
        String string = TestWindowClosingProtocol03NewtAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

