/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.TextureSequenceDemo01;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureSequenceCubeES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextureSequence01AWT
extends UITestCase {
    static boolean showFPS = false;
    static int width = 510;
    static int height = 300;
    static boolean useBuildInTexLookup = false;
    static long duration = 500L;
    static GLProfile glp;
    static GLCapabilities caps;

    @BeforeClass
    public static void initClass() {
        glp = GLProfile.getGL2ES2();
        Assert.assertNotNull((Object)glp);
        caps = new GLCapabilities(glp);
        Assert.assertNotNull((Object)caps);
    }

    void testImpl() throws InterruptedException {
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)caps);
        final Frame frame = new Frame("TestTextureSequence01AWT");
        Assert.assertNotNull((Object)frame);
        frame.add((Component)gLCanvas);
        final TextureSequenceDemo01 textureSequenceDemo01 = new TextureSequenceDemo01(useBuildInTexLookup);
        gLCanvas.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
                textureSequenceDemo01.initGLResources(gLAutoDrawable.getGL());
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        gLCanvas.addGLEventListener((GLEventListener)new TextureSequenceCubeES2(textureSequenceDemo01, false, -2.3f, 0.0f, 0.0f));
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)quitAdapter).addTo((Component)gLCanvas);
        new AWTWindowAdapter((WindowListener)quitAdapter).addTo((Component)gLCanvas);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(width, height);
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        Assert.assertFalse((boolean)animator.isAnimating());
        Assert.assertFalse((boolean)animator.isStarted());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.remove((Component)gLCanvas);
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test
    public void test1() throws InterruptedException {
        this.testImpl();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (!stringArray[i].equals("-shaderBuildIn")) continue;
            useBuildInTexLookup = true;
        }
        JUnitCore.main((String[])new String[]{TestTextureSequence01AWT.class.getName()});
    }
}

