/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.TextureDraw01GL2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTexture01AWT
extends UITestCase {
    static long durationPerTest = 500L;
    static GLProfile glp;
    static GLCapabilities caps;
    BufferedImage textureImage;

    @BeforeClass
    public static void initClass() {
        if (!GLProfile.isAvailable((String)"GL2GL3")) {
            UITestCase.setTestSupported(false);
            return;
        }
        glp = GLProfile.getMaxFixedFunc((boolean)true);
        Assert.assertNotNull((Object)glp);
        caps = new GLCapabilities(glp);
        Assert.assertNotNull((Object)caps);
    }

    @Before
    public void initTest() {
        BufferedImage bufferedImage = new BufferedImage(256, 256, 5);
        Assert.assertNotNull((Object)bufferedImage);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Assert.assertNotNull((Object)graphics2D);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.CYAN, bufferedImage.getWidth(), bufferedImage.getHeight(), Color.BLUE));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        int n = 5;
        this.textureImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Assert.assertNotNull((Object)this.textureImage);
        graphics2D = this.textureImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        bufferedImage.flush();
        bufferedImage = null;
    }

    @After
    public void cleanupTest() {
        Assert.assertNotNull((Object)this.textureImage);
        this.textureImage.flush();
        this.textureImage = null;
    }

    @Test
    public void test1() throws InterruptedException {
        final AWTGLReadBufferUtil aWTGLReadBufferUtil = new AWTGLReadBufferUtil(caps.getGLProfile(), false);
        final Frame frame = new Frame("GL -> AWT");
        Canvas canvas = new Canvas();
        frame.add(canvas);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)caps);
        final Frame frame2 = new Frame("AWT -> Texture");
        Assert.assertNotNull((Object)frame2);
        frame2.add((Component)gLCanvas);
        TextureData textureData = AWTTextureIO.newTextureData((GLProfile)caps.getGLProfile(), (BufferedImage)this.textureImage, (boolean)false);
        gLCanvas.addGLEventListener((GLEventListener)new TextureDraw01GL2Listener(textureData));
        gLCanvas.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            public void display(GLAutoDrawable gLAutoDrawable) {
                BufferedImage bufferedImage = aWTGLReadBufferUtil.readPixelsToBufferedImage(gLAutoDrawable.getGL(), true);
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                final JLabel jLabel = new JLabel(imageIcon);
                try {
                    AWTEDTExecutor.singleton.invoke(true, new Runnable(){

                        @Override
                        public void run() {
                            frame.removeAll();
                            frame.add(jLabel);
                            frame.validate();
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
                frame.setSize(frame2.getWidth(), frame2.getHeight());
                frame.setLocation(frame2.getX() + frame2.getWidth() + 32, frame.getY());
                frame.validate();
            }
        });
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame2.setSize(256, 256);
                    frame2.setLocation(0, 0);
                    frame2.setVisible(true);
                    frame.setSize(frame2.getWidth(), frame2.getHeight());
                    frame.setLocation(frame2.getX() + frame2.getWidth() + 32, frame.getY());
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        Thread.sleep(durationPerTest);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(false);
                    frame.dispose();
                    frame2.setVisible(false);
                    frame2.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        String string = TestTexture01AWT.class.getName();
        JUnitTestRunner.main((String[])new String[]{string, "filtertrace=true", "haltOnError=false", "haltOnFailure=false", "showoutput=true", "outputtoformatters=true", "logfailedtests=true", "logtestlistenerevents=true", "formatter=org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter", "formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter,TEST-" + string + ".xml"});
    }
}

