/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.tile;

import com.jogamp.common.os.Platform;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.TraceKeyAdapter;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.es1.RedSquareES1;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.jogl.tile.PrintableBase;
import com.jogamp.opengl.test.junit.jogl.tile.TiledPrintingAWTBase;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTiledPrintingGearsSwingAWT
extends TiledPrintingAWTBase {
    static boolean waitForKey = false;
    static boolean allow600dpi = false;
    static GLProfile glp;
    static int width;
    static int height;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
            width = 640;
            height = 480;
        } else {
            TestTiledPrintingGearsSwingAWT.setTestSupported(false);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl) throws InterruptedException, InvocationTargetException {
        Object object;
        JComponent jComponent;
        Serializable serializable;
        int n = width / 6;
        int n2 = height / 6;
        Dimension dimension = new Dimension(bl ? width - 2 * n : width / 2, bl ? height - 2 * n2 : height);
        GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLJPanel);
        gLJPanel.setMinimumSize(dimension);
        gLJPanel.setPreferredSize(dimension);
        if (bl) {
            gLJPanel.setBounds(n / 2, n2 / 2, dimension.width, dimension.height);
        } else {
            gLJPanel.setBounds(0, 0, dimension.width, dimension.height);
        }
        gLJPanel.addGLEventListener((GLEventListener)new Gears());
        GLJPanel gLJPanel2 = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLJPanel2);
        gLJPanel2.setMinimumSize(dimension);
        gLJPanel2.setPreferredSize(dimension);
        if (bl) {
            gLJPanel2.setBounds(3 * n2, 2 * n2, dimension.width, dimension.height);
        } else {
            gLJPanel2.setBounds(0, 0, dimension.width, dimension.height);
        }
        gLJPanel2.addGLEventListener((GLEventListener)new RedSquareES1());
        if (bl) {
            gLJPanel.setOpaque(true);
            gLJPanel2.setOpaque(false);
            serializable = new Dimension(width, height);
            jComponent = new JLayeredPane();
            jComponent.setMinimumSize((Dimension)serializable);
            jComponent.setPreferredSize((Dimension)serializable);
            jComponent.setBounds(0, 0, ((Dimension)serializable).width, ((Dimension)serializable).height);
            jComponent.setBorder(BorderFactory.createTitledBorder("Layered Pane"));
            jComponent.add((Component)gLJPanel, JLayeredPane.DEFAULT_LAYER);
            jComponent.add((Component)gLJPanel2, (Object)1);
            object = new JButton("On Top");
            ((Component)object).setBounds(4 * n2, 3 * n2, 100, 50);
            jComponent.add((Component)object, (Object)2);
        } else {
            jComponent = new JPanel();
            jComponent.add((Component)gLJPanel);
            jComponent.add((Component)gLJPanel2);
        }
        serializable = new JFrame("Swing Print");
        Assert.assertNotNull((Object)serializable);
        object = new ActionListener((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsSwingAWT.this.doPrintManual(this.val$frame, 72, 0, -1, -1);
            }
        };
        ActionListener actionListener = new ActionListener((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsSwingAWT.this.doPrintManual(this.val$frame, 300, -1, -1, -1);
            }
        };
        ActionListener actionListener2 = new ActionListener((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTiledPrintingGearsSwingAWT.this.doPrintManual(this.val$frame, 600, -1, -1, -1);
            }
        };
        Button button = new Button("72dpi");
        button.addActionListener((ActionListener)object);
        Button button2 = new Button("300dpi");
        button2.addActionListener(actionListener);
        Button button3 = new Button("600dpi");
        button3.addActionListener(actionListener2);
        JPanel jPanel = new JPanel();
        jPanel.add(button);
        jPanel.add(button2);
        jPanel.add(button3);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new Label("South"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new Label("East"));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new Label("West"));
        Animator animator = new Animator();
        animator.add((GLAutoDrawable)gLJPanel);
        animator.add((GLAutoDrawable)gLJPanel2);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter)).addTo((Component)gLJPanel);
        new AWTKeyAdapter((KeyListener)new TraceKeyAdapter((KeyListener)quitAdapter)).addTo((Component)gLJPanel2);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter)).addTo((Component)serializable);
        SwingUtilities.invokeAndWait(new Runnable((JFrame)serializable, jPanel, jComponent, jPanel2, jPanel3, jPanel4){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JPanel val$printPanel;
            final /* synthetic */ JComponent val$demoPanel;
            final /* synthetic */ JPanel val$southPanel;
            final /* synthetic */ JPanel val$eastPanel;
            final /* synthetic */ JPanel val$westPanel;
            {
                this.val$frame = jFrame;
                this.val$printPanel = jPanel;
                this.val$demoPanel = jComponent;
                this.val$southPanel = jPanel2;
                this.val$eastPanel = jPanel3;
                this.val$westPanel = jPanel4;
            }

            @Override
            public void run() {
                Container container = this.val$frame.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)this.val$printPanel, "North");
                container.add((Component)this.val$demoPanel, "Center");
                container.add((Component)this.val$southPanel, "South");
                container.add((Component)this.val$eastPanel, "East");
                container.add((Component)this.val$westPanel, "West");
                container.validate();
                this.val$frame.pack();
                this.val$frame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(serializable, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLJPanel, true));
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLJPanel2, true));
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        boolean bl2 = false;
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && (0L == duration || animator.getTotalFPSDuration() < duration)) {
            Thread.sleep(200L);
            if (bl2) continue;
            bl2 = true;
            PrintableBase printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 72, 0, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 72, 8, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 150, -1, 2048, 2048, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 150, -1, -1, -1, true);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 3, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 2, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 1, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 4, 150, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
            printableBase = this.doPrintAuto((Container)serializable, 0, null, 3, 150, -1, -1, -1, true);
            this.waitUntilPrintJobsIdle(printableBase);
            if (!allow600dpi) continue;
            printableBase = this.doPrintAuto((Container)serializable, 0, null, -1, 600, -1, -1, -1, false);
            this.waitUntilPrintJobsIdle(printableBase);
        }
        Assert.assertNotNull((Object)serializable);
        Assert.assertNotNull((Object)gLJPanel);
        Assert.assertNotNull((Object)gLJPanel2);
        Assert.assertNotNull((Object)animator);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        SwingUtilities.invokeAndWait(new Runnable((JFrame)serializable){
            final /* synthetic */ JFrame val$frame;
            {
                this.val$frame = jFrame;
            }

            @Override
            public void run() {
                this.val$frame.setVisible(false);
            }
        });
        Assert.assertEquals((Object)false, (Object)((Component)serializable).isVisible());
        SwingUtilities.invokeAndWait(new Runnable((JFrame)serializable, jComponent){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JComponent val$demoPanel;
            {
                this.val$frame = jFrame;
                this.val$demoPanel = jComponent;
            }

            @Override
            public void run() {
                JFrame jFrame = this.val$frame;
                ((Container)jFrame).remove(this.val$demoPanel);
                jFrame.dispose();
            }
        });
    }

    @Test
    public void test01_aa0() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        this.runTestGL(gLCapabilities, false);
    }

    @Test
    public void test01_aa0_layered() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setAlphaBits(8);
        this.runTestGL(gLCapabilities, true);
    }

    @Test
    public void test01_aa0_bitmap() throws InterruptedException, InvocationTargetException {
        if (Platform.OSType.WINDOWS == Platform.getOSType()) {
            GLCapabilities gLCapabilities = new GLCapabilities(glp);
            gLCapabilities.setBitmap(true);
            this.runTestGL(gLCapabilities, false);
        }
    }

    @Test
    public void test01_aa0_bitmap_layered() throws InterruptedException, InvocationTargetException {
        if (Platform.OSType.WINDOWS == Platform.getOSType()) {
            GLCapabilities gLCapabilities = new GLCapabilities(glp);
            gLCapabilities.setBitmap(true);
            gLCapabilities.setAlphaBits(8);
            this.runTestGL(gLCapabilities, true);
        }
    }

    @Test
    public void test02_aa8() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(8);
        this.runTestGL(gLCapabilities, false);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = MiscUtils.atol(stringArray[++i], duration);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                width = MiscUtils.atoi(stringArray[++i], width);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                height = MiscUtils.atoi(stringArray[++i], height);
                continue;
            }
            if (stringArray[i].equals("-600dpi")) {
                allow600dpi = true;
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        if (waitForKey) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.err.println("Press enter to continue");
            try {
                System.err.println(bufferedReader.readLine());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JUnitCore.main((String[])new String[]{TestTiledPrintingGearsSwingAWT.class.getName()});
    }

    static {
        duration = 500L;
    }
}

