/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.offscreen;

import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.offscreen.WindowUtilNEWT;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestOffscreen01GLPBufferNEWT
extends UITestCase {
    static GLProfile glpDefault;
    static GLDrawableFactory glDrawableFactory;
    static int width;
    static int height;
    GLCapabilities capsDefault;

    @BeforeClass
    public static void initClass() {
        glpDefault = GLProfile.getDefault();
        Assert.assertNotNull((Object)glpDefault);
        glDrawableFactory = GLDrawableFactory.getFactory((GLProfile)glpDefault);
        System.out.println("INFO: PBuffer supported: " + glDrawableFactory.canCreateGLPbuffer(null, glpDefault));
        width = 640;
        height = 480;
    }

    @AfterClass
    public static void releaseClass() {
    }

    @Before
    public void init() {
        this.capsDefault = new GLCapabilities(glpDefault);
        Assert.assertNotNull((Object)this.capsDefault);
        this.capsDefault.setAlphaBits(1);
    }

    private void do01OffscreenWindowPBuffer(GLCapabilities gLCapabilities) {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)window);
        window.setSize(width, height);
        GLWindow gLWindow = GLWindow.create((Window)window);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        WindowUtilNEWT.setDemoFields(redSquareES2, window, gLWindow, false);
        gLWindow.addGLEventListener((GLEventListener)redSquareES2);
        while (gLWindow.getTotalFPSFrames() < 2) {
            gLWindow.display();
        }
        if (null != gLWindow) {
            gLWindow.destroy();
        }
        if (null != window) {
            window.destroy();
        }
        if (null != screen) {
            screen.destroy();
        }
        if (null != display) {
            display.destroy();
        }
    }

    @Test
    public void test01aOffscreenWindowPBuffer() {
        if (!glDrawableFactory.canCreateGLPbuffer(null, this.capsDefault.getGLProfile())) {
            System.out.println("WARNING: PBuffer not supported on this platform - cannot test");
            return;
        }
        GLCapabilities gLCapabilities = WindowUtilNEWT.fixCaps(this.capsDefault, false, true, false);
        this.do01OffscreenWindowPBuffer(gLCapabilities);
    }

    @Test
    public void test01bOffscreenWindowPBufferStencil() {
        if (!glDrawableFactory.canCreateGLPbuffer(null, this.capsDefault.getGLProfile())) {
            System.out.println("WARNING: PBuffer not supported on this platform - cannot test");
            return;
        }
        GLCapabilities gLCapabilities = WindowUtilNEWT.fixCaps(this.capsDefault, false, true, false);
        gLCapabilities.setStencilBits(8);
        this.do01OffscreenWindowPBuffer(gLCapabilities);
    }

    @Test
    public void test01cOffscreenWindowPBufferStencilAlpha() {
        if (!glDrawableFactory.canCreateGLPbuffer(null, this.capsDefault.getGLProfile())) {
            System.out.println("WARNING: PBuffer not supported on this platform - cannot test");
            return;
        }
        GLCapabilities gLCapabilities = WindowUtilNEWT.fixCaps(this.capsDefault, false, true, false);
        gLCapabilities.setStencilBits(8);
        gLCapabilities.setAlphaBits(8);
        this.do01OffscreenWindowPBuffer(gLCapabilities);
    }

    @Test
    public void test01cOffscreenWindowPBuffer555() {
        if (!glDrawableFactory.canCreateGLPbuffer(null, this.capsDefault.getGLProfile())) {
            System.out.println("WARNING: PBuffer not supported on this platform - cannot test");
            return;
        }
        GLCapabilities gLCapabilities = WindowUtilNEWT.fixCaps(this.capsDefault, false, true, false);
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(5);
        gLCapabilities.setBlueBits(5);
        this.do01OffscreenWindowPBuffer(gLCapabilities);
    }

    @Test
    public void test02Offscreen3Windows1DisplayPBuffer() {
        int n;
        if (!glDrawableFactory.canCreateGLPbuffer(null, this.capsDefault.getGLProfile())) {
            System.out.println("WARNING: PBuffer not supported on this platform - cannot test");
            return;
        }
        GLCapabilities gLCapabilities = WindowUtilNEWT.fixCaps(this.capsDefault, false, true, false);
        int n2 = 3;
        Window[] windowArray = new Window[n2];
        GLWindow[] gLWindowArray = new GLWindow[n2];
        GLEventListener[] gLEventListenerArray = new GLEventListener[n2];
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        for (n = 0; n < n2; ++n) {
            System.out.println("Create Window " + n);
            windowArray[n] = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)windowArray[n]);
            windowArray[n].setSize(width, height);
            gLWindowArray[n] = GLWindow.create((Window)windowArray[n]);
            Assert.assertNotNull((Object)gLWindowArray[n]);
            gLWindowArray[n].setVisible(true);
            gLEventListenerArray[n] = new RedSquareES2();
            WindowUtilNEWT.setDemoFields(gLEventListenerArray[n], windowArray[n], gLWindowArray[n], false);
            gLWindowArray[n].addGLEventListener(gLEventListenerArray[n]);
        }
        while (gLWindowArray[0].getTotalFPSFrames() < 2) {
            for (n = 0; n < n2; ++n) {
                gLWindowArray[n].display();
            }
        }
        for (n = 0; n < n2; ++n) {
            if (null != gLWindowArray[n]) {
                gLWindowArray[n].destroy();
            }
            if (null == windowArray[n]) continue;
            windowArray[n].destroy();
        }
        if (null != screen) {
            screen.destroy();
        }
        if (null != display) {
            display.destroy();
        }
    }

    @Test
    public void test03Offscreen3Windows3DisplaysPBuffer() {
        int n;
        if (!glDrawableFactory.canCreateGLPbuffer(null, this.capsDefault.getGLProfile())) {
            System.out.println("WARNING: PBuffer not supported on this platform - cannot test");
            return;
        }
        GLCapabilities gLCapabilities = WindowUtilNEWT.fixCaps(this.capsDefault, false, true, false);
        int n2 = 3;
        Display[] displayArray = new Display[n2];
        Screen[] screenArray = new Screen[n2];
        Window[] windowArray = new Window[n2];
        GLWindow[] gLWindowArray = new GLWindow[n2];
        GLEventListener[] gLEventListenerArray = new GLEventListener[n2];
        for (n = 0; n < n2; ++n) {
            System.out.println("Create Window " + n);
            displayArray[n] = NewtFactory.createDisplay(null, (boolean)false);
            Assert.assertNotNull((Object)displayArray[n]);
            screenArray[n] = NewtFactory.createScreen((Display)displayArray[n], (int)0);
            Assert.assertNotNull((Object)screenArray[n]);
            windowArray[n] = NewtFactory.createWindow((Screen)screenArray[n], (CapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)windowArray[n]);
            windowArray[n].setSize(width, height);
            gLWindowArray[n] = GLWindow.create((Window)windowArray[n]);
            Assert.assertNotNull((Object)gLWindowArray[n]);
            gLWindowArray[n].setVisible(true);
            gLEventListenerArray[n] = new RedSquareES2();
            WindowUtilNEWT.setDemoFields(gLEventListenerArray[n], windowArray[n], gLWindowArray[n], false);
            gLWindowArray[n].addGLEventListener(gLEventListenerArray[n]);
        }
        while (gLWindowArray[0].getTotalFPSFrames() < 2) {
            for (n = 0; n < n2; ++n) {
                gLWindowArray[n].display();
            }
        }
        for (n = 0; n < n2; ++n) {
            if (null != gLWindowArray[n]) {
                gLWindowArray[n].destroy();
            }
            if (null != windowArray[n]) {
                windowArray[n].destroy();
            }
            if (null != screenArray[n]) {
                screenArray[n].destroy();
            }
            if (null == displayArray[n]) continue;
            displayArray[n].destroy();
        }
    }

    @Test
    public void test04OffscreenSnapshotWithDemoPBuffer() {
        if (!glDrawableFactory.canCreateGLPbuffer(null, this.capsDefault.getGLProfile())) {
            System.out.println("WARNING: PBuffer not supported on this platform - cannot test");
            return;
        }
        GLCapabilities gLCapabilities = WindowUtilNEWT.fixCaps(this.capsDefault, false, true, false);
        System.out.println("Create Window 1");
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Assert.assertNotNull((Object)screen);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)window);
        window.setSize(width, height);
        GLWindow gLWindow = GLWindow.create((Window)window);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        WindowUtilNEWT.run(this.getSimpleTestName("."), gLWindow, new RedSquareES2(), null, null, null, null, 2, true, false);
        if (null != gLWindow) {
            gLWindow.destroy();
        }
        if (null != window) {
            window.destroy();
        }
        if (null != screen) {
            screen.destroy();
        }
        if (null != display) {
            display.destroy();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestOffscreen01GLPBufferNEWT.class.getName();
        JUnitTestRunner.main((String[])new String[]{string, "filtertrace=true", "haltOnError=false", "haltOnFailure=false", "showoutput=true", "outputtoformatters=true", "logfailedtests=true", "logtestlistenerevents=true", "formatter=org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter", "formatter=org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter,TEST-" + string + ".xml"});
    }
}

