/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.math;

import com.jogamp.opengl.math.Binary16;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public final class TestBinary16NOUI
extends UITestCase {
    static int stepping = 1;
    static boolean verbose = false;

    @Test
    public void testExponentIdentity() {
        System.out.println("-- Exponent identities");
        for (int i = -15; i <= 16; ++i) {
            char c = Binary16.packSetExponentUnbiasedUnchecked((int)i);
            int n = Binary16.unpackGetExponentUnbiased((char)c);
            if (verbose) {
                System.out.println("e: " + i + ", p: " + Integer.toHexString(c) + ", u: " + n);
            }
            Assert.assertEquals((long)i, (long)n);
        }
    }

    @Test
    public void testInfinite() {
        Assert.assertTrue((boolean)Binary16.isInfinite((char)Binary16.POSITIVE_INFINITY));
        Assert.assertTrue((boolean)Binary16.isInfinite((char)Binary16.NEGATIVE_INFINITY));
        Assert.assertFalse((boolean)Binary16.isInfinite((char)Binary16.exampleNaN()));
        for (int i = 0; i <= 65535; i += stepping) {
            Assert.assertFalse((boolean)Binary16.isInfinite((char)Binary16.packDouble((double)i)));
        }
    }

    @Test
    public void testInfinityExponent() {
        Assert.assertEquals((long)16L, (long)Binary16.unpackGetExponentUnbiased((char)Binary16.POSITIVE_INFINITY));
    }

    @Test
    public void testInfinityNegativeExponent() {
        Assert.assertEquals((long)16L, (long)Binary16.unpackGetExponentUnbiased((char)Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testInfinityNegativeSign() {
        Assert.assertEquals((long)1L, (long)Binary16.unpackGetSign((char)Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testInfinityNegativeSignificand() {
        Assert.assertEquals((long)0L, (long)Binary16.unpackGetSignificand((char)Binary16.NEGATIVE_INFINITY));
    }

    @Test
    public void testInfinitySign() {
        Assert.assertEquals((long)0L, (long)Binary16.unpackGetSign((char)Binary16.POSITIVE_INFINITY));
    }

    @Test
    public void testInfinitySignificand() {
        Assert.assertEquals((long)0L, (long)Binary16.unpackGetSignificand((char)Binary16.POSITIVE_INFINITY));
    }

    @Test
    public void testNaN() {
        int n = Binary16.packSetExponentUnbiasedUnchecked((int)16) | Binary16.packSetSignificandUnchecked((int)1);
        char c = (char)n;
        Assert.assertEquals((long)16L, (long)Binary16.unpackGetExponentUnbiased((char)c));
        Assert.assertEquals((long)1L, (long)Binary16.unpackGetSignificand((char)c));
        Assert.assertEquals((long)16L, (long)Binary16.unpackGetExponentUnbiased((char)Binary16.exampleNaN()));
        Assert.assertEquals((long)1L, (long)Binary16.unpackGetSignificand((char)Binary16.exampleNaN()));
        Assert.assertTrue((boolean)Binary16.isNaN((char)c));
        Assert.assertTrue((boolean)Binary16.isNaN((char)Binary16.exampleNaN()));
    }

    @Test
    public void testPackDoubleNaN() {
        char c = Binary16.packDouble((double)Double.NaN);
        Assert.assertTrue((boolean)Binary16.isNaN((char)c));
    }

    @Test
    public void testPackDoubleNegativeInfinity() {
        Assert.assertTrue((Binary16.NEGATIVE_INFINITY == Binary16.packDouble((double)Double.NEGATIVE_INFINITY) ? 1 : 0) != 0);
    }

    @Test
    public void testPackDoubleNegativeZero() {
        Assert.assertTrue((Binary16.NEGATIVE_ZERO == Binary16.packDouble((double)-0.0) ? 1 : 0) != 0);
    }

    @Test
    public void testPackDoublePositiveInfinity() {
        Assert.assertTrue((Binary16.POSITIVE_INFINITY == Binary16.packDouble((double)Double.POSITIVE_INFINITY) ? 1 : 0) != 0);
    }

    @Test
    public void testPackDoublePositiveZero() {
        Assert.assertTrue((Binary16.POSITIVE_ZERO == Binary16.packDouble((double)0.0) ? 1 : 0) != 0);
    }

    @Test
    public void testPackDoubleUnpackFloat() {
        for (int i = 0; i <= 65536; i += stepping) {
            double d = i;
            char c = Binary16.packDouble((double)d);
            float f = Binary16.unpackFloat((char)c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString((char)c), d, Float.valueOf(f)));
            }
            if (i <= 2048) {
                Assert.assertEquals((double)d, (double)f, (double)0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue((f % 2.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue((f % 4.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue((f % 8.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue((f % 16.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue((f % 32.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i != 65536) continue;
            Assert.assertTrue((boolean)Double.isInfinite(f));
        }
    }

    @Test
    public void testPackFloatDoubleEquivalent() {
        for (int i = 0; i <= 65536; i += stepping) {
            float f = i;
            double d = i;
            char c = Binary16.packFloat((float)f);
            char c2 = Binary16.packDouble((double)d);
            if (verbose) {
                System.out.println("i: " + i);
                System.out.println(String.format("pack_f: 0x%04x 0b%s", c, Binary16.toRawBinaryString((char)c)));
                System.out.println(String.format("pack_d: 0x%04x 0b%s", c2, Binary16.toRawBinaryString((char)c2)));
            }
            Assert.assertEquals((long)c, (long)c2);
        }
    }

    @Test
    public void testPackFloatNaN() {
        char c = Binary16.packFloat((float)Float.NaN);
        Assert.assertTrue((boolean)Binary16.isNaN((char)c));
    }

    @Test
    public void testPackFloatNegativeInfinity() {
        Assert.assertTrue((Binary16.NEGATIVE_INFINITY == Binary16.packFloat((float)Float.NEGATIVE_INFINITY) ? 1 : 0) != 0);
    }

    @Test
    public void testPackFloatNegativeZero() {
        Assert.assertTrue((Binary16.NEGATIVE_ZERO == Binary16.packFloat((float)-0.0f) ? 1 : 0) != 0);
    }

    @Test
    public void testPackFloatPositiveInfinity() {
        Assert.assertTrue((Binary16.POSITIVE_INFINITY == Binary16.packFloat((float)Float.POSITIVE_INFINITY) ? 1 : 0) != 0);
    }

    @Test
    public void testPackFloatPositiveZero() {
        Assert.assertTrue((Binary16.POSITIVE_ZERO == Binary16.packFloat((float)0.0f) ? 1 : 0) != 0);
    }

    @Test
    public void testPackFloatUnpackDouble() {
        for (int i = 0; i <= 65536; i += stepping) {
            float f = i;
            char c = Binary16.packFloat((float)f);
            double d = Binary16.unpackDouble((char)c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString((char)c), Float.valueOf(f), d));
            }
            if (i <= 2048) {
                Assert.assertEquals((double)f, (double)d, (double)0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue((d % 2.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue((d % 4.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue((d % 8.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue((d % 16.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue((d % 32.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i != 65536) continue;
            Assert.assertTrue((boolean)Double.isInfinite(d));
        }
    }

    @Test
    public void testPackUnpackDouble() {
        for (int i = 0; i <= 65536; i += stepping) {
            double d = i;
            char c = Binary16.packDouble((double)d);
            double d2 = Binary16.unpackDouble((char)c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString((char)c), d, d2));
            }
            if (i <= 2048) {
                Assert.assertEquals((double)d, (double)d2, (double)0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue((d2 % 2.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue((d2 % 4.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue((d2 % 8.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue((d2 % 16.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue((d2 % 32.0 == 0.0 ? 1 : 0) != 0);
            }
            if (i != 65536) continue;
            Assert.assertTrue((boolean)Double.isInfinite(d2));
        }
    }

    @Test
    public void testPackUnpackFloat() {
        for (int i = 0; i <= 65536; i += stepping) {
            float f = i;
            char c = Binary16.packFloat((float)f);
            float f2 = Binary16.unpackFloat((char)c);
            if (verbose) {
                System.out.println(String.format("packed: 0x%04x 0b%s in: %f unpacked: %f", c, Binary16.toRawBinaryString((char)c), Float.valueOf(f), Float.valueOf(f2)));
            }
            if (i <= 2048) {
                Assert.assertEquals((double)f, (double)f2, (double)0.0);
            }
            if (i > 2048 && i <= 4096) {
                Assert.assertTrue((f2 % 2.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 4096 && i <= 8192) {
                Assert.assertTrue((f2 % 4.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 8192 && i <= 16384) {
                Assert.assertTrue((f2 % 8.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 16384 && i <= 32768) {
                Assert.assertTrue((f2 % 16.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i > 32768 && i < 65536) {
                Assert.assertTrue((f2 % 32.0f == 0.0f ? 1 : 0) != 0);
            }
            if (i != 65536) continue;
            Assert.assertTrue((boolean)Float.isInfinite(f2));
        }
    }

    @Test
    public void testSignIdentity() {
        System.out.println("-- Sign identities");
        for (int i = 0; i <= 1; ++i) {
            char c = Binary16.packSetSignUnchecked((int)i);
            int n = Binary16.unpackGetSign((char)c);
            if (verbose) {
                System.out.println("e: " + i + ", p: " + Integer.toHexString(c) + ", u: " + n);
            }
            Assert.assertEquals((long)i, (long)n);
        }
    }

    @Test
    public void testSignificandIdentity() {
        System.out.println("-- Significand identities");
        for (int i = 0; i <= 1023; ++i) {
            char c = Binary16.packSetSignificandUnchecked((int)i);
            int n = Binary16.unpackGetSignificand((char)c);
            if (verbose) {
                System.out.println("e: " + i + ", p: " + Integer.toHexString(c) + ", u: " + n);
            }
            Assert.assertEquals((long)i, (long)n);
        }
    }

    @Test
    public void testUnpackDoubleNaN() {
        double d = Binary16.unpackDouble((char)Binary16.exampleNaN());
        Assert.assertTrue((boolean)Double.isNaN(d));
    }

    @Test
    public void testUnpackDoubleNegativeInfinity() {
        Assert.assertTrue((Double.NEGATIVE_INFINITY == Binary16.unpackDouble((char)Binary16.NEGATIVE_INFINITY) ? 1 : 0) != 0);
    }

    @Test
    public void testUnpackDoubleNegativeZero() {
        Assert.assertTrue((-0.0 == Binary16.unpackDouble((char)Binary16.NEGATIVE_ZERO) ? 1 : 0) != 0);
    }

    @Test
    public void testUnpackDoubleOne() {
        double d = Binary16.unpackDouble((char)'\u3c00');
        System.out.println(String.format("0x%04x -> %f", 15360, d));
        Assert.assertEquals((double)d, (double)1.0, (double)0.0);
    }

    @Test
    public void testUnpackDoubleOneNegative() {
        double d = Binary16.unpackDouble((char)'\ubc00');
        System.out.println(String.format("0x%04x -> %f", 48128, d));
        Assert.assertEquals((double)d, (double)-1.0, (double)0.0);
    }

    @Test
    public void testUnpackDoublePositiveInfinity() {
        Assert.assertTrue((Double.POSITIVE_INFINITY == Binary16.unpackDouble((char)Binary16.POSITIVE_INFINITY) ? 1 : 0) != 0);
    }

    @Test
    public void testUnpackDoublePositiveZero() {
        Assert.assertTrue((0.0 == Binary16.unpackDouble((char)Binary16.POSITIVE_ZERO) ? 1 : 0) != 0);
    }

    @Test
    public void testUnpackDoubleTwo() {
        double d = Binary16.unpackDouble((char)'\u4000');
        System.out.println(String.format("%04x -> %f", 16384, d));
        Assert.assertEquals((double)d, (double)2.0, (double)0.0);
    }

    @Test
    public void testUnpackDoubleTwoNegative() {
        double d = Binary16.unpackDouble((char)'\uc000');
        System.out.println(String.format("%04x -> %f", 49152, d));
        Assert.assertEquals((double)d, (double)-2.0, (double)0.0);
    }

    @Test
    public void testUnpackFloatNaN() {
        float f = Binary16.unpackFloat((char)Binary16.exampleNaN());
        Assert.assertTrue((boolean)Float.isNaN(f));
    }

    @Test
    public void testUnpackFloatNegativeInfinity() {
        Assert.assertTrue((Float.NEGATIVE_INFINITY == Binary16.unpackFloat((char)Binary16.NEGATIVE_INFINITY) ? 1 : 0) != 0);
    }

    @Test
    public void testUnpackFloatNegativeZero() {
        Assert.assertTrue((-0.0 == (double)Binary16.unpackFloat((char)Binary16.NEGATIVE_ZERO) ? 1 : 0) != 0);
    }

    @Test
    public void testUnpackFloatOne() {
        float f = Binary16.unpackFloat((char)'\u3c00');
        System.out.println(String.format("0x%04x -> %f", 15360, Float.valueOf(f)));
        Assert.assertEquals((double)f, (double)1.0, (double)0.0);
    }

    @Test
    public void testUnpackFloatOneNegative() {
        float f = Binary16.unpackFloat((char)'\ubc00');
        System.out.println(String.format("0x%04x -> %f", 48128, Float.valueOf(f)));
        Assert.assertEquals((double)f, (double)-1.0, (double)0.0);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-stepping")) {
                stepping = MiscUtils.atoi(stringArray[++i], stepping);
                continue;
            }
            if (!stringArray[i].equals("-verbose")) continue;
            verbose = true;
        }
        JUnitCore.main((String[])new String[]{TestBinary16NOUI.class.getName()});
    }
}

