/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.gl2;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.util.TileRendererBase;
import java.awt.Component;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;

public class Gears
implements GLEventListener,
TileRendererBase.TileRendererListener {
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private float view_rotz = 0.0f;
    private int gear1 = 0;
    private int gear2 = 0;
    private int gear3 = 0;
    private float angle = 0.0f;
    private boolean doRotate = true;
    private int swapInterval;
    private MouseListener gearsMouse = new GearsMouseAdapter();
    private KeyListener gearsKeys = new GearsKeyAdapter();
    private TileRendererBase tileRendererInUse = null;
    private boolean doRotateBeforePrinting;
    private boolean verbose = true;
    private int prevMouseX;
    private int prevMouseY;

    public Gears(int n) {
        this.swapInterval = n;
    }

    public Gears() {
        this.swapInterval = 1;
    }

    public void addTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = tileRendererBase;
        this.doRotateBeforePrinting = this.doRotate;
        this.setDoRotation(false);
    }

    public void removeTileRendererNotify(TileRendererBase tileRendererBase) {
        this.tileRendererInUse = null;
        this.setDoRotation(this.doRotateBeforePrinting);
    }

    public void startTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("Gears.startTileRendering: " + tileRendererBase);
    }

    public void endTileRendering(TileRendererBase tileRendererBase) {
        System.err.println("Gears.endTileRendering: " + tileRendererBase);
    }

    public void setDoRotation(boolean bl) {
        this.doRotate = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setGears(int n, int n2, int n3) {
        this.gear1 = n;
        this.gear2 = n2;
        this.gear3 = n3;
    }

    public int getGear1() {
        return this.gear1;
    }

    public int getGear2() {
        return this.gear2;
    }

    public int getGear3() {
        return this.gear3;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.init(gL2);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.gearsMouse);
            window.addKeyListener(this.gearsKeys);
        } else if (GLProfile.isAWTAvailable() && object instanceof Component) {
            Component component = (Component)object;
            new AWTMouseAdapter(this.gearsMouse).addTo(component);
            new AWTKeyAdapter(this.gearsKeys).addTo(component);
        }
    }

    public void init(GL2 gL2) {
        float[] fArray = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
        float[] fArray2 = new float[]{0.8f, 0.1f, 0.0f, 0.7f};
        float[] fArray3 = new float[]{0.0f, 0.8f, 0.2f, 0.7f};
        float[] fArray4 = new float[]{0.2f, 0.2f, 1.0f, 0.7f};
        System.err.println(Thread.currentThread() + " Gears.init: tileRendererInUse " + this.tileRendererInUse);
        if (this.verbose) {
            System.err.println("GearsES2 init on " + Thread.currentThread());
            System.err.println("Chosen GLCapabilities: " + gL2.getContext().getGLDrawable().getChosenGLCapabilities());
            System.err.println("INIT GL IS: " + gL2.getClass().getName());
            System.err.println(JoglVersion.getGLStrings((GL)gL2, null, (boolean)false).toString());
        }
        gL2.glLightfv(16384, 4611, fArray, 0);
        gL2.glEnable(2884);
        gL2.glEnable(2896);
        gL2.glEnable(16384);
        gL2.glEnable(2929);
        if (0 >= this.gear1) {
            this.gear1 = gL2.glGenLists(1);
            gL2.glNewList(this.gear1, 4864);
            gL2.glMaterialfv(1028, 5634, fArray2, 0);
            Gears.gear(gL2, 1.0f, 4.0f, 1.0f, 20, 0.7f);
            gL2.glEndList();
            System.err.println("gear1 list created: " + this.gear1);
        } else {
            System.err.println("gear1 list reused: " + this.gear1);
        }
        if (0 >= this.gear2) {
            this.gear2 = gL2.glGenLists(1);
            gL2.glNewList(this.gear2, 4864);
            gL2.glMaterialfv(1028, 5634, fArray3, 0);
            Gears.gear(gL2, 0.5f, 2.0f, 2.0f, 10, 0.7f);
            gL2.glEndList();
            System.err.println("gear2 list created: " + this.gear2);
        } else {
            System.err.println("gear2 list reused: " + this.gear2);
        }
        if (0 >= this.gear3) {
            this.gear3 = gL2.glGenLists(1);
            gL2.glNewList(this.gear3, 4864);
            gL2.glMaterialfv(1028, 5634, fArray4, 0);
            Gears.gear(gL2, 1.3f, 2.0f, 0.5f, 10, 0.7f);
            gL2.glEndList();
            System.err.println("gear3 list created: " + this.gear3);
        } else {
            System.err.println("gear3 list reused: " + this.gear3);
        }
        gL2.glEnable(2977);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (-1 != this.swapInterval) {
            gL2.setSwapInterval(this.swapInterval);
        }
        this.reshape(gL2, n, n2, n3, n4, n3, n4);
    }

    public void reshapeTile(TileRendererBase tileRendererBase, int n, int n2, int n3, int n4, int n5, int n6) {
        GL2 gL2 = tileRendererBase.getAttachedDrawable().getGL().getGL2();
        gL2.setSwapInterval(0);
        this.reshape(gL2, n, n2, n3, n4, n5, n6);
    }

    public void reshape(GL2 gL2, int n, int n2, int n3, int n4, int n5, int n6) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl = gL2.getContext().getGLDrawable().getChosenGLCapabilities().getSampleBuffers();
        System.err.println(Thread.currentThread() + " Gears.reshape " + n + "/" + n2 + " " + n3 + "x" + n4 + " of " + n5 + "x" + n6 + ", swapInterval " + this.swapInterval + ", drawable 0x" + Long.toHexString(gL2.getContext().getGLDrawable().getHandle()) + ", msaa " + bl + ", tileRendererInUse " + this.tileRendererInUse);
        if (bl) {
            gL2.glEnable(32925);
        }
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        if (n6 > n5) {
            f5 = (float)n6 / (float)n5;
            f4 = -1.0f;
            f3 = 1.0f;
            f2 = -f5;
            f = f5;
        } else {
            f5 = (float)n5 / (float)n6;
            f4 = -f5;
            f3 = f5;
            f2 = -1.0f;
            f = 1.0f;
        }
        f5 = f3 - f4;
        float f6 = f - f2;
        float f7 = f4 + (float)n * f5 / (float)n5;
        float f8 = f7 + (float)n3 * f5 / (float)n5;
        float f9 = f2 + (float)n2 * f6 / (float)n6;
        float f10 = f9 + (float)n4 * f6 / (float)n6;
        float f11 = f8 - f7;
        float f12 = f10 - f9;
        if (this.verbose) {
            System.err.println(">> angle " + this.angle + ", [l " + f4 + ", r " + f3 + ", b " + f2 + ", t " + f + "] " + f5 + "x" + f6 + " -> [l " + f7 + ", r " + f8 + ", b " + f9 + ", t " + f10 + "] " + f11 + "x" + f12);
        }
        gL2.glFrustum((double)f7, (double)f8, (double)f9, (double)f10, 5.0, 60.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glTranslatef(0.0f, 0.0f, -40.0f);
        if (bl) {
            gL2.glDisable(32925);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println(Thread.currentThread() + " Gears.dispose: tileRendererInUse " + this.tileRendererInUse);
        try {
            Object object = gLAutoDrawable.getUpstreamWidget();
            if (object instanceof Window) {
                Window window = (Window)object;
                window.removeMouseListener(this.gearsMouse);
                window.removeKeyListener(this.gearsKeys);
            }
        }
        catch (Exception exception) {
            System.err.println("Catched: ");
            exception.printStackTrace();
        }
        this.setGears(0, 0, 0);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        boolean bl = gL2.getContext().getGLDrawable().getChosenGLCapabilities().getSampleBuffers();
        if (bl) {
            gL2.glEnable(32925);
        }
        if (null == this.tileRendererInUse) {
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            gL2.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        }
        if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof GLJPanel && !((GLJPanel)gLAutoDrawable).isOpaque() && ((GLJPanel)gLAutoDrawable).shouldPreserveColorBufferIfTranslucent()) {
            gL2.glClear(256);
        } else {
            gL2.glClear(16640);
        }
        this.displayImpl(gL2);
        if (bl) {
            gL2.glDisable(32925);
        }
    }

    public void display(GL2 gL2) {
        boolean bl = gL2.getContext().getGLDrawable().getChosenGLCapabilities().getSampleBuffers();
        if (bl) {
            gL2.glEnable(32925);
        }
        if (null == this.tileRendererInUse) {
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            gL2.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        }
        gL2.glClear(16640);
        this.displayImpl(gL2);
        if (bl) {
            gL2.glDisable(32925);
        }
    }

    private void displayImpl(GL2 gL2) {
        if (this.doRotate) {
            this.angle += 2.0f;
        }
        gL2.glPushMatrix();
        gL2.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef(this.view_rotz, 0.0f, 0.0f, 1.0f);
        gL2.glPushMatrix();
        gL2.glTranslatef(-3.0f, -2.0f, 0.0f);
        gL2.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.gear1);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glTranslatef(3.1f, -2.0f, 0.0f);
        gL2.glRotatef(-2.0f * this.angle - 9.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.gear2);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glTranslatef(-3.1f, 4.2f, 0.0f);
        gL2.glRotatef(-2.0f * this.angle - 25.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.gear3);
        gL2.glPopMatrix();
        gL2.glPopMatrix();
    }

    public static void gear(GL2 gL2, float f, float f2, float f3, int n, float f4) {
        float f5;
        int n2;
        float f6 = f;
        float f7 = f2 - f4 / 2.0f;
        float f8 = f2 + f4 / 2.0f;
        float f9 = (float)Math.PI * 2 / (float)n / 4.0f;
        gL2.glShadeModel(7424);
        gL2.glNormal3f(0.0f, 0.0f, 1.0f);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            if (n2 >= n) continue;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            float f10 = f8 * (float)Math.cos(f5 + f9) - f7 * (float)Math.cos(f5);
            float f11 = f8 * (float)Math.sin(f5 + f9) - f7 * (float)Math.sin(f5);
            float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
            gL2.glNormal3f(f11 /= f12, -(f10 /= f12), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            f10 = f7 * (float)Math.cos(f5 + 3.0f * f9) - f8 * (float)Math.cos(f5 + 2.0f * f9);
            f11 = f7 * (float)Math.sin(f5 + 3.0f * f9) - f8 * (float)Math.sin(f5 + 2.0f * f9);
            gL2.glNormal3f(f11, -f10, 0.0f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
        }
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), f3 * 0.5f);
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), -f3 * 0.5f);
        gL2.glEnd();
        gL2.glShadeModel(7425);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glNormal3f(-((float)Math.cos(f5)), -((float)Math.sin(f5)), 0.0f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
        }
        gL2.glEnd();
    }

    class GearsMouseAdapter
    extends MouseAdapter {
        GearsMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Gears.this.prevMouseX = mouseEvent.getX();
            Gears.this.prevMouseY = mouseEvent.getY();
            if ((mouseEvent.getModifiers() & 0x80) != 0) {
                // empty if block
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x80) != 0) {
                // empty if block
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            Object object2 = mouseEvent.getSource();
            if (object2 instanceof Window) {
                object = (Window)object2;
                n3 = object.getWidth();
                n4 = object.getHeight();
            } else if (GLProfile.isAWTAvailable() && object2 instanceof Component) {
                object = (Component)object2;
                n3 = ((Component)object).getWidth();
                n4 = ((Component)object).getHeight();
            } else {
                throw new RuntimeException("Event source neither Window nor Component: " + object2);
            }
            float f = 360.0f * ((float)(n - Gears.this.prevMouseX) / (float)n3);
            float f2 = 360.0f * ((float)(Gears.this.prevMouseY - n2) / (float)n4);
            Gears.this.prevMouseX = n;
            Gears.this.prevMouseY = n2;
            Gears.this.view_rotx += f2;
            Gears.this.view_roty += f;
        }
    }

    class GearsKeyAdapter
    extends KeyAdapter {
        GearsKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (149 == s) {
                Gears.this.view_roty -= 1.0f;
            } else if (151 == s) {
                Gears.this.view_roty += 1.0f;
            } else if (150 == s) {
                Gears.this.view_rotx -= 1.0f;
            } else if (152 == s) {
                Gears.this.view_rotx += 1.0f;
            }
        }
    }
}

