/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2.av;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLUniformData;

public class MovieSimple
implements GLEventListener {
    public static final int EFFECT_NORMAL = 0;
    public static final int EFFECT_GRADIENT_BOTTOM2TOP = 2;
    public static final int EFFECT_TRANSPARENT = 8;
    private static boolean waitForKey = false;
    private int winWidth;
    private int winHeight;
    private int prevMouseX;
    private int rotate = 0;
    private boolean orthoProjection = true;
    private float nearPlaneNormalized;
    private float zoom0;
    private float zoom1;
    private float zoom;
    private long startTime;
    private int effects = 0;
    private float alpha = 1.0f;
    private int swapInterval = 1;
    private GLMediaPlayer mPlayer;
    private boolean mPlayerShared;
    private boolean mPlayerScaleOrig;
    private float[] verts = null;
    private GLArrayDataServer interleavedVBO;
    private volatile boolean resetGLState = false;
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private static final String shaderBasename = "texsequence_xxx";
    private static final String myTextureLookupName = "myTexture2D";
    public static final URI defURI;
    private final MouseListener mouseAction = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSimple.this.winHeight / 2 && null != MovieSimple.this.mPlayer && 1 == mouseEvent.getClickCount()) {
                if (GLMediaPlayer.State.Playing == MovieSimple.this.mPlayer.getState()) {
                    MovieSimple.this.mPlayer.pause(false);
                } else {
                    MovieSimple.this.mPlayer.play();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getY() <= MovieSimple.this.winHeight / 2) {
                MovieSimple.this.rotate = -1;
                MovieSimple.this.zoom = MovieSimple.this.zoom0;
                System.err.println("zoom: " + MovieSimple.this.zoom);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            MovieSimple.this.prevMouseX = mouseEvent.getX();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n2 > MovieSimple.this.winHeight / 2) {
                float f = (float)(n - MovieSimple.this.prevMouseX) / (float)MovieSimple.this.winWidth;
                MovieSimple.this.mPlayer.seek(MovieSimple.this.mPlayer.getVideoPTS() + (int)((float)MovieSimple.this.mPlayer.getDuration() * f));
            } else {
                MovieSimple.this.mPlayer.play();
                MovieSimple.this.rotate = 1;
                MovieSimple.this.zoom = MovieSimple.this.zoom1;
            }
            MovieSimple.this.prevMouseX = n;
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                MovieSimple.this.zoom += mouseEvent.getRotation()[1] / 10.0f;
                System.err.println("zoom: " + MovieSimple.this.zoom);
            }
        }
    };
    private final KeyListener keyAction = new KeyAdapter(){

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.isAutoRepeat()) {
                return;
            }
            System.err.println("MC " + keyEvent);
            int n = MovieSimple.this.mPlayer.getVideoPTS();
            int n2 = 0;
            switch (keyEvent.getKeyCode()) {
                case 151: {
                    n2 = n + 1000;
                    break;
                }
                case 150: {
                    n2 = n + 10000;
                    break;
                }
                case 16: {
                    n2 = n + 30000;
                    break;
                }
                case 149: {
                    n2 = n - 1000;
                    break;
                }
                case 152: {
                    n2 = n - 10000;
                    break;
                }
                case 11: {
                    n2 = n - 30000;
                    break;
                }
                case 2: 
                case 8: 
                case 27: {
                    MovieSimple.this.mPlayer.seek(0);
                    break;
                }
                case 32: {
                    if (GLMediaPlayer.State.Paused == MovieSimple.this.mPlayer.getState()) {
                        MovieSimple.this.mPlayer.play();
                        break;
                    }
                    MovieSimple.this.mPlayer.pause(false);
                    break;
                }
                case 141: {
                    MovieSimple.this.mPlayer.setPlaySpeed(1.0f);
                    break;
                }
                case 140: {
                    float f = MovieSimple.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f /= 2.0f) : (f -= 0.1f);
                    MovieSimple.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 139: {
                    float f = MovieSimple.this.mPlayer.getPlaySpeed();
                    f = keyEvent.isShiftDown() ? (f *= 2.0f) : (f += 0.1f);
                    MovieSimple.this.mPlayer.setPlaySpeed(f);
                    break;
                }
                case 77: {
                    float f = MovieSimple.this.mPlayer.getAudioVolume();
                    f = f > 0.5f ? 0.0f : 1.0f;
                    MovieSimple.this.mPlayer.setAudioVolume(f);
                }
            }
            if (0 != n2) {
                MovieSimple.this.mPlayer.seek(n2);
            }
        }
    };
    long lastPerfPos = 0L;

    public MovieSimple() {
        this(null);
        this.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

            public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
            }

            public void attributesChanged(GLMediaPlayer gLMediaPlayer, int n, long l) {
                System.err.println("MovieCube AttributesChanges: events_mask 0x" + Integer.toHexString(n) + ", when " + l);
                System.err.println("MovieCube State: " + gLMediaPlayer);
                if (0 != (0x40000 & n)) {
                    MovieSimple.this.resetGLState();
                }
                if (0 != (0x10 & n)) {
                    MovieSimple.this.mPlayer.seek(0);
                    MovieSimple.this.mPlayer.play();
                }
            }
        });
        this.initStream(defURI, -1, -1, 3);
        GLMediaPlayer.StreamException streamException = null;
        while (null == streamException && GLMediaPlayer.State.Initialized != this.mPlayer.getState()) {
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            streamException = this.mPlayer.getStreamException();
        }
        if (null != streamException) {
            streamException.printStackTrace();
            throw new RuntimeException((Throwable)streamException);
        }
    }

    public MovieSimple(GLMediaPlayer gLMediaPlayer) throws IllegalStateException {
        this.mPlayer = gLMediaPlayer;
        this.mPlayerScaleOrig = false;
        boolean bl = this.mPlayerShared = null != this.mPlayer;
        if (!this.mPlayerShared) {
            this.mPlayer = GLMediaPlayerFactory.createDefault();
        }
        System.out.println("pC.1a shared " + this.mPlayerShared + ", " + this.mPlayer);
    }

    public void initStream(URI uRI, int n, int n2, int n3) {
        this.mPlayer.initStream(uRI, n, n2, n3);
        System.out.println("pC.1b " + this.mPlayer);
    }

    public void setSwapInterval(int n) {
        this.swapInterval = n;
    }

    public GLMediaPlayer getGLMediaPlayer() {
        return this.mPlayer;
    }

    public void setScaleOrig(boolean bl) {
        this.mPlayerScaleOrig = bl;
    }

    public void setOrthoProjection(boolean bl) {
        this.orthoProjection = bl;
    }

    public boolean getOrthoProjection() {
        return this.orthoProjection;
    }

    public boolean hasEffect(int n) {
        return 0 != (this.effects & n);
    }

    public void setEffects(int n) {
        this.effects = n;
    }

    public void setTransparency(float f) {
        this.effects |= 8;
        this.alpha = f;
    }

    public void resetGLState() {
        this.resetGLState = true;
    }

    private void initShader(GL2ES2 gL2ES2) {
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, MovieSimple.class, (String)"../shader", (String)"../shader/bin", (String)shaderBasename, (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, MovieSimple.class, (String)"../shader", (String)"../shader/bin", (String)shaderBasename, (boolean)true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        int n = shaderCode2.addGLSLVersion(gL2ES2);
        n = shaderCode2.insertShaderSource(0, n, (CharSequence)this.mPlayer.getRequiredExtensionsShaderStub());
        n = shaderCode2.addDefaultShaderPrecision(gL2ES2, n);
        String string = this.mPlayer.getTextureLookupFunctionName(myTextureLookupName);
        shaderCode2.replaceInShaderSource(myTextureLookupName, string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("uniform ").append(this.mPlayer.getTextureSampler2DType()).append(" mgl_ActiveTexture;\n");
        stringBuilder.append(this.mPlayer.getTextureLookupFragmentShaderImpl());
        shaderCode2.insertShaderSource(0, "TEXTURE-SEQUENCE-CODE-BEGIN", 0, (CharSequence)stringBuilder);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        if (!shaderProgram.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + shaderProgram);
        }
        this.st = new ShaderState();
        this.st.attachShaderProgram(gL2ES2, shaderProgram, false);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        float f;
        float f2;
        Texture texture;
        Object object;
        if (null == this.mPlayer) {
            throw new InternalError("mPlayer null");
        }
        if (GLMediaPlayer.State.Uninitialized == this.mPlayer.getState()) {
            throw new IllegalStateException("mPlayer in uninitialized state: " + this.mPlayer);
        }
        if (-2 == this.mPlayer.getVID()) {
            throw new IllegalStateException("mPlayer has no VID/stream selected: " + this.mPlayer);
        }
        this.resetGLState = false;
        this.zoom0 = this.orthoProjection ? 0.0f : -2.5f;
        this.zoom1 = this.orthoProjection ? 0.0f : -5.0f;
        this.zoom = this.zoom0;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println(JoglVersion.getGLInfo((GL)gL2ES2, null));
        System.err.println("Alpha: " + this.alpha + ", opaque " + gLAutoDrawable.getChosenGLCapabilities().isBackgroundOpaque() + ", " + gLAutoDrawable.getClass().getName() + ", " + gLAutoDrawable);
        if (waitForKey) {
            UITestCase.waitForKey("Init>");
        }
        boolean bl = false;
        try {
            System.out.println("p0 " + this.mPlayer + ", shared " + this.mPlayerShared);
            if (!this.mPlayerShared && GLMediaPlayer.State.Initialized == this.mPlayer.getState()) {
                this.mPlayer.initGL((GL)gL2ES2);
            }
            System.out.println("p1 " + this.mPlayer + ", shared " + this.mPlayerShared);
            object = this.mPlayer.getLastTexture();
            if (null == object) {
                throw new InternalError("XXX: " + this.mPlayer);
            }
            texture = this.mPlayer.getLastTexture().getTexture();
            boolean bl2 = bl = 36197 == texture.getTarget();
            if (bl && !gL2ES2.isExtensionAvailable("GL_OES_EGL_image_external")) {
                throw new GLException("GL_OES_EGL_image_external requested but not available");
            }
            if (!this.mPlayerShared) {
                this.mPlayer.setTextureMinMagFilter(new int[]{9728, 9729});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (!this.mPlayerShared && null != this.mPlayer) {
                this.mPlayer.destroy((GL)gL2ES2);
                this.mPlayer = null;
            }
            throw new GLException((Throwable)exception);
        }
        this.initShader(gL2ES2);
        this.st.useProgram(gL2ES2, true);
        object = new int[]{0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight()};
        this.pmvMatrix = new PMVMatrix();
        this.reshapePMV((int)object[2], (int)object[3]);
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, this.pmvMatrix.glGetPMvMatrixf());
        if (!this.st.uniform(gL2ES2, this.pmvMatrixUniform)) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.st);
        }
        if (!this.st.uniform(gL2ES2, new GLUniformData("mgl_ActiveTexture", this.mPlayer.getTextureUnit()))) {
            throw new GLException("Error setting mgl_ActiveTexture in shader: " + this.st);
        }
        float f3 = gLAutoDrawable.getWidth();
        float f4 = gLAutoDrawable.getHeight();
        float f5 = this.mPlayer.getWidth();
        float f6 = this.mPlayer.getHeight();
        float f7 = f5 / f6;
        System.err.println("XXX0: mov aspect: " + f7);
        if (this.orthoProjection) {
            if (this.mPlayerScaleOrig && f5 < f3 && f6 < f4) {
                f2 = f5 / 2.0f;
                f = f2 / f7;
            } else {
                f2 = f3 / 2.0f;
                f = f2 / f7;
            }
        } else if (this.mPlayerScaleOrig && f5 < f3 && f6 < f4) {
            f2 = f7 * (f5 / f3);
            f = f2 / f7;
        } else {
            f2 = f7;
            f = 1.0f;
        }
        this.verts = new float[]{-1.0f * f2, -1.0f * f, 0.0f, 1.0f * f2, 1.0f * f, 0.0f};
        System.err.println("XXX0: pixel  LB: " + this.verts[0] + ", " + this.verts[1] + ", " + this.verts[2]);
        System.err.println("XXX0: pixel  RT: " + this.verts[3] + ", " + this.verts[4] + ", " + this.verts[5]);
        Object object2 = new float[3];
        Object object3 = new float[3];
        this.pmvMatrix.gluProject(this.verts[0], this.verts[1], this.verts[2], (int[])object, 0, object2, 0);
        this.pmvMatrix.gluProject(this.verts[3], this.verts[4], this.verts[5], (int[])object, 0, object3, 0);
        System.err.println("XXX0: win   LB: " + object2[0] + ", " + object2[1] + ", " + object2[2]);
        System.err.println("XXX0: win   RT: " + object3[0] + ", " + object3[1] + ", " + object3[2]);
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)9, (int)5126, (boolean)false, (int)12, (int)35044);
        this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_Color", 4, 34962);
        this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        this.updateInterleavedVBO((GL)gL2ES2, texture);
        this.st.ownAttribute((GLArrayData)this.interleavedVBO, true);
        gL2ES2.glClearColor(0.3f, 0.3f, 0.3f, 0.3f);
        gL2ES2.glEnable(2929);
        this.st.useProgram(gL2ES2, false);
        System.out.println("iVBO: " + this.interleavedVBO);
        System.out.println(this.st);
        if (!this.mPlayerShared) {
            this.mPlayer.play();
            System.out.println("play.0 " + this.mPlayer);
        }
        this.startTime = System.currentTimeMillis();
        object2 = gLAutoDrawable.getUpstreamWidget();
        if (object2 instanceof Window) {
            object3 = (Window)object2;
            object3.addMouseListener(this.mouseAction);
            object3.addKeyListener(this.keyAction);
            this.winWidth = object3.getWidth();
            this.winHeight = object3.getHeight();
        }
    }

    protected void updateInterleavedVBO(GL gL, Texture texture) {
        boolean bl = this.interleavedVBO.enabled();
        this.interleavedVBO.seal(gL, false);
        this.interleavedVBO.rewind();
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        TextureCoords textureCoords = texture.getImageTexCoords();
        System.err.println("XXX0: " + textureCoords);
        System.err.println("XXX0: tex aspect: " + texture.getAspectRatio());
        System.err.println("XXX0: tex y-flip: " + texture.getMustFlipVertically());
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.left() * 1.0f);
        floatBuffer.put(textureCoords.bottom() * 1.0f);
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[1]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(0.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.right() * 1.0f);
        floatBuffer.put(textureCoords.bottom() * 1.0f);
        floatBuffer.put(this.verts[0]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.left() * 1.0f);
        floatBuffer.put(textureCoords.top() * 1.0f);
        floatBuffer.put(this.verts[3]);
        floatBuffer.put(this.verts[4]);
        floatBuffer.put(this.verts[2]);
        if (this.hasEffect(2)) {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        } else {
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(this.alpha);
        }
        floatBuffer.put(textureCoords.right() * 1.0f);
        floatBuffer.put(textureCoords.top() * 1.0f);
        this.interleavedVBO.seal(gL, true);
        if (!bl) {
            this.interleavedVBO.enableBuffer(gL, false);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (-1 != this.swapInterval) {
            gL2ES2.setSwapInterval(this.swapInterval);
        }
        if (null == this.mPlayer) {
            return;
        }
        this.winWidth = n3;
        this.winHeight = n4;
        if (null != this.st) {
            this.reshapePMV(n3, n4);
            this.st.useProgram(gL2ES2, true);
            this.st.uniform(gL2ES2, this.pmvMatrixUniform);
            this.st.useProgram(gL2ES2, false);
        }
        System.out.println("pR " + this.mPlayer);
    }

    private void reshapePMV(int n, int n2) {
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        if (this.orthoProjection) {
            float f = (float)n / 2.0f;
            float f2 = (float)n2 / 2.0f;
            this.pmvMatrix.glOrthof(-f, f, -f2, f2, -1.0f, 1.0f);
            this.nearPlaneNormalized = 0.0f;
        } else {
            this.pmvMatrix.gluPerspective(45.0f, (float)n / (float)n2, 1.0f, 10.0f);
            this.nearPlaneNormalized = 0.11111111f;
        }
        System.err.println("XXX0: Perspective nearPlaneNormalized: " + this.nearPlaneNormalized);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom0);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.disposeImpl(gLAutoDrawable, true);
    }

    private void disposeImpl(GLAutoDrawable gLAutoDrawable, boolean bl) {
        Window window;
        if (null == this.mPlayer) {
            return;
        }
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            window = (Window)object;
            window.removeMouseListener(this.mouseAction);
            window.removeKeyListener(this.keyAction);
        }
        System.out.println("pD.1 " + this.mPlayer + ", disposePlayer " + bl);
        window = gLAutoDrawable.getGL().getGL2ES2();
        if (bl) {
            if (!this.mPlayerShared) {
                this.mPlayer.destroy((GL)window);
            }
            System.out.println("pD.X " + this.mPlayer);
            this.mPlayer = null;
        }
        this.pmvMatrixUniform = null;
        if (null != this.pmvMatrix) {
            this.pmvMatrix.destroy();
            this.pmvMatrix = null;
        }
        if (null != this.st) {
            this.st.destroy((GL2ES2)window);
            this.st = null;
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        TextureSequence.TextureFrame textureFrame;
        long l;
        if (null == this.mPlayer) {
            return;
        }
        if (this.resetGLState) {
            this.resetGLState = false;
            System.err.println("XXX resetGLState");
            this.disposeImpl(gLAutoDrawable, false);
            this.init(gLAutoDrawable);
            this.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
        }
        if ((l = System.currentTimeMillis()) - this.lastPerfPos > 2000L) {
            System.err.println(this.mPlayer.getPerfString());
            this.lastPerfPos = l;
        }
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClear(16640);
        if (null == this.st) {
            return;
        }
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, this.zoom);
        if (this.rotate > 0) {
            float f = (float)(System.currentTimeMillis() - this.startTime) * 360.0f / 8000.0f;
            this.pmvMatrix.glRotatef(f, 0.0f, 0.0f, 1.0f);
        } else {
            this.rotate = 0;
        }
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
        Texture texture = null;
        if (null != this.mPlayer && null != (textureFrame = this.mPlayerShared ? this.mPlayer.getLastTexture() : this.mPlayer.getNextTexture((GL)gL2ES2))) {
            texture = textureFrame.getTexture();
            gL2ES2.glActiveTexture(33984 + this.mPlayer.getTextureUnit());
            texture.enable((GL)gL2ES2);
            texture.bind((GL)gL2ES2);
        }
        gL2ES2.glDrawArrays(5, 0, 4);
        if (null != texture) {
            texture.disable((GL)gL2ES2);
        }
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        this.st.useProgram(gL2ES2, false);
    }

    public static void main(String[] stringArray) throws IOException, URISyntaxException {
        int n = 1;
        int n2 = 640;
        int n3 = 600;
        int n4 = 3;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n5 = -1;
        int n6 = -1;
        String string = null;
        boolean bl7 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-vid")) {
                n5 = MiscUtils.atoi(stringArray[++i], n5);
                continue;
            }
            if (stringArray[i].equals("-aid")) {
                n6 = MiscUtils.atoi(stringArray[++i], n6);
                continue;
            }
            if (stringArray[i].equals("-width")) {
                n2 = MiscUtils.atoi(stringArray[++i], n2);
                continue;
            }
            if (stringArray[i].equals("-height")) {
                n3 = MiscUtils.atoi(stringArray[++i], n3);
                continue;
            }
            if (stringArray[i].equals("-osize")) {
                bl7 = true;
                continue;
            }
            if (stringArray[i].equals("-textureCount")) {
                n4 = MiscUtils.atoi(stringArray[++i], n4);
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i].equals("-es3")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                bl5 = true;
                continue;
            }
            if (stringArray[i].equals("-gldef")) {
                bl6 = true;
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                n = MiscUtils.atoi(stringArray[++i], n);
                continue;
            }
            if (stringArray[i].equals("-projection")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-zoom")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-wait")) continue;
            waitForKey = true;
        }
        final boolean bl8 = bl7;
        URI uRI = null == string ? defURI : new URI(string);
        System.err.println("stream " + uRI);
        System.err.println("vid " + n5 + ", aid " + n6);
        System.err.println("textureCount " + n4);
        System.err.println("forceES2   " + bl3);
        System.err.println("forceES3   " + bl4);
        System.err.println("forceGL3   " + bl5);
        System.err.println("forceGLDef " + bl6);
        System.err.println("swapInterval " + n);
        final MovieSimple movieSimple = new MovieSimple(null);
        movieSimple.setSwapInterval(n);
        movieSimple.setScaleOrig(!bl2);
        movieSimple.setOrthoProjection(bl);
        try {
            GLProfile gLProfile = bl6 ? GLProfile.getDefault() : (bl5 ? GLProfile.get((String)"GL3") : (bl4 ? GLProfile.get((String)"GLES3") : (bl3 ? GLProfile.get((String)"GLES2") : GLProfile.getGL2ES2())));
            System.err.println("GLProfile: " + gLProfile);
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            final GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            final Animator animator = new Animator((GLAutoDrawable)gLWindow);
            gLWindow.addWindowListener((WindowListener)new WindowAdapter(){

                public void windowDestroyed(WindowEvent windowEvent) {
                    animator.stop();
                }
            });
            gLWindow.setSize(n2, n3);
            gLWindow.setVisible(true);
            animator.start();
            movieSimple.mPlayer.addEventListener(new GLMediaPlayer.GLMediaEventListener(){

                void destroyWindow() {
                    new Thread(){

                        @Override
                        public void run() {
                            gLWindow.destroy();
                        }
                    }.start();
                }

                public void newFrameAvailable(GLMediaPlayer gLMediaPlayer, TextureSequence.TextureFrame textureFrame, long l) {
                }

                public void attributesChanged(GLMediaPlayer gLMediaPlayer, int n, long l) {
                    System.err.println("MovieSimple AttributesChanges: events_mask 0x" + Integer.toHexString(n) + ", when " + l);
                    System.err.println("MovieSimple State: " + gLMediaPlayer);
                    if (0 != (0x40000 & n)) {
                        if (bl8) {
                            gLWindow.setSize(gLMediaPlayer.getWidth(), gLMediaPlayer.getHeight());
                        }
                        movieSimple.resetGLState();
                    }
                    if (0 != (1 & n)) {
                        if (-2 != movieSimple.mPlayer.getVID()) {
                            gLWindow.addGLEventListener((GLEventListener)movieSimple);
                            animator.setUpdateFPSFrames(60, System.err);
                            animator.resetFPSCounter();
                        } else {
                            try {
                                movieSimple.mPlayer.initGL(null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                this.destroyWindow();
                                return;
                            }
                            movieSimple.mPlayer.play();
                            System.out.println("play.1 " + movieSimple.mPlayer);
                        }
                    }
                    if (0 != (0x30 & n)) {
                        GLMediaPlayer.StreamException streamException = movieSimple.mPlayer.getStreamException();
                        if (null != streamException) {
                            streamException.printStackTrace();
                        }
                        this.destroyWindow();
                    }
                }
            });
            movieSimple.initStream(uRI, n5, n6, n4);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        URI uRI = null;
        try {
            uRI = new URI("http://video.webmfiles.org/big-buck-bunny_trailer.webm");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        defURI = uRI;
    }
}

