/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Shape;
import java.io.IOException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestJScrollPaneMixHwLw01AWT
extends UITestCase {
    static long durationPerTest = 500L;

    protected void runTestGL(GLCapabilities gLCapabilities, boolean bl) throws InterruptedException {
        Container container;
        String string = bl ? "LW" : "HW";
        final JFrame jFrame = new JFrame("Mix Hw/Lw Swing - ScrollPane " + string);
        Assert.assertNotNull((Object)jFrame);
        final Dimension dimension = new Dimension(600, 400);
        Dimension dimension2 = new Dimension(500, 600);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)new GearsES2());
        gLCanvas.setPreferredSize(dimension2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        if (bl) {
            container = new TransparentJScrollPane((Component)gLCanvas);
            jPanel.add((Component)container, "Center");
        } else {
            container = new ScrollPane();
            container.add((Component)gLCanvas);
            jPanel.add((Component)container, "Center");
        }
        container = new JTextArea();
        ((JTextComponent)container).setText("Test\nTest\nTest\nTest\n");
        jPanel.add((Component)container, "North");
        jFrame.add(jPanel);
        jFrame.setDefaultCloseOperation(3);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setLocationRelativeTo(null);
                    jFrame.setTitle("GLCanvas in JScrollPane example");
                    jFrame.setSize(dimension);
                    jFrame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.start();
        Thread.sleep(durationPerTest);
        animator.stop();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    public void test01JScrollPane() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, true);
    }

    @Test
    public void test01ScrollPane() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, false);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atol(stringArray[++i], durationPerTest);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestJScrollPaneMixHwLw01AWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    public static class TransparentJScrollPane
    extends JScrollPane {
        public TransparentJScrollPane(Component component) {
            super(component);
            this.setOpaque(false);
            try {
                ReflectionUtil.callStaticMethod((String)"com.sun.awt.AWTUtilities", (String)"setComponentMixingCutoutShape", (Class[])new Class[]{Component.class, Shape.class}, (Object[])new Object[]{this, new Rectangle()}, (ClassLoader)GraphicsConfiguration.class.getClassLoader());
                System.err.println("com.sun.awt.AWTUtilities.setComponentMixingCutoutShape(..) passed");
            }
            catch (RuntimeException runtimeException) {
                System.err.println("com.sun.awt.AWTUtilities.setComponentMixingCutoutShape(..) failed: " + runtimeException.getMessage());
            }
        }

        @Override
        public void setOpaque(boolean bl) {
        }
    }
}

