/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.awt.Screenshot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug461PBufferSupersamplingSwingAWT
extends UITestCase
implements GLEventListener {
    JFrame jframe;
    GLPbuffer offScreenBuffer;

    private void render(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        Assert.assertNotNull((Object)gL2);
        gL2.glClear(16384);
        gL2.glBegin(4);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        gL2.glVertex2d(-1.0, -1.0);
        gL2.glColor3f(0.0f, 1.0f, 0.0f);
        gL2.glVertex2d(0.0, 1.0);
        gL2.glColor3f(0.0f, 0.0f, 1.0f);
        gL2.glVertex2d(1.0, -1.0);
        gL2.glEnd();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render((GLAutoDrawable)this.offScreenBuffer);
        BufferedImage bufferedImage = Screenshot.readToBufferedImage((int)200, (int)200, (boolean)false);
        Assert.assertNotNull((Object)bufferedImage);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        JLabel jLabel = new JLabel(imageIcon);
        this.jframe.getContentPane().add(jLabel);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TestBug461PBufferSupersamplingSwingAWT.this.jframe.setVisible(false);
                    TestBug461PBufferSupersamplingSwingAWT.this.jframe.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Test
    public void testOffscreenSupersampling() throws InterruptedException, InvocationTargetException {
        this.jframe = new JFrame("Offscreen Supersampling");
        Assert.assertNotNull((Object)this.jframe);
        this.jframe.setSize(300, 300);
        this.jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        GLProfile gLProfile = GLProfile.get((String)"GL2");
        Assert.assertNotNull((Object)gLProfile);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        Assert.assertNotNull((Object)gLDrawableFactory);
        Assert.assertTrue((boolean)gLDrawableFactory.canCreateGLPbuffer(GLProfile.getDefaultDevice(), gLProfile));
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Assert.assertNotNull((Object)gLCapabilities);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setDoubleBuffered(false);
        gLCapabilities.setStencilBits(1);
        this.offScreenBuffer = gLDrawableFactory.createGLPbuffer(GLProfile.getDefaultDevice(), (GLCapabilitiesImmutable)gLCapabilities, null, 200, 200, null);
        Assert.assertNotNull((Object)this.offScreenBuffer);
        this.offScreenBuffer.addGLEventListener((GLEventListener)this);
        this.offScreenBuffer.display();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TestBug461PBufferSupersamplingSwingAWT.this.jframe.setVisible(true);
            }
        });
        this.offScreenBuffer.destroy();
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug461PBufferSupersamplingSwingAWT.class.getName()});
    }
}

