/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAWT03GLCanvasRecreate01
extends UITestCase {
    static long durationPerTest = 1000L;
    Frame frame1 = null;
    Frame frame2 = null;
    GLCanvas glCanvas = null;
    Label label = null;
    Animator animator = null;

    @BeforeClass
    public static void startup() {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
    }

    @Before
    public void init() {
        this.glCanvas = new GLCanvas();
        Assert.assertNotNull((Object)this.glCanvas);
        this.glCanvas.addGLEventListener((GLEventListener)new GearsES2());
        this.animator = new Animator((GLAutoDrawable)this.glCanvas);
        this.animator.start();
        this.label = new Label("No GLCanvas");
        this.frame1 = new Frame("Frame 1");
        Assert.assertNotNull((Object)this.frame1);
        this.frame1.add(this.label);
        this.frame1.setSize(512, 512);
        this.frame1.setLocation(0, 0);
        this.frame2 = new Frame("Frame 2");
        Assert.assertNotNull((Object)this.frame2);
        this.frame2.add(this.label);
        this.frame2.setSize(512, 512);
        this.frame2.setLocation(512, 0);
    }

    @After
    public void release() {
        Assert.assertNotNull((Object)this.frame1);
        Assert.assertNotNull((Object)this.frame2);
        Assert.assertNotNull((Object)this.glCanvas);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TestAWT03GLCanvasRecreate01.this.glCanvas.destroy();
                    TestAWT03GLCanvasRecreate01.this.frame1.dispose();
                    TestAWT03GLCanvasRecreate01.this.frame2.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        this.frame1 = null;
        this.frame2 = null;
        this.glCanvas = null;
        this.animator.stop();
        this.animator = null;
    }

    private void addCanvas(final Frame frame) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.remove(TestAWT03GLCanvasRecreate01.this.label);
                    frame.add((Component)TestAWT03GLCanvasRecreate01.this.glCanvas);
                    frame.validate();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    private void removeCanvas(final Frame frame) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.remove((Component)TestAWT03GLCanvasRecreate01.this.glCanvas);
                    frame.add(TestAWT03GLCanvasRecreate01.this.label);
                    frame.validate();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    private void setVisible(final Frame frame, final boolean bl) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setVisible(bl);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
    }

    @Test
    public void testAddRemove3Times() throws InterruptedException {
        this.setVisible(this.frame1, true);
        this.setVisible(this.frame2, true);
        this.addCanvas(this.frame1);
        Thread.sleep(durationPerTest / 4L);
        this.removeCanvas(this.frame1);
        this.addCanvas(this.frame2);
        Thread.sleep(durationPerTest / 4L);
        this.removeCanvas(this.frame2);
        this.addCanvas(this.frame1);
        Thread.sleep(durationPerTest / 4L);
        this.removeCanvas(this.frame1);
        this.addCanvas(this.frame2);
        Thread.sleep(durationPerTest / 4L);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
        }
        JUnitCore.main((String[])new String[]{TestAWT03GLCanvasRecreate01.class.getName()});
    }
}

