/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.glels;

import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLDrawableUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLContextDrawableSwitch02AWT
extends UITestCase {
    static int width;
    static int height;
    static long duration;
    static long period;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable((String)string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get((String)string));
    }

    @BeforeClass
    public static void initClass() {
        width = 256;
        height = 256;
    }

    private GLAutoDrawable createGLAutoDrawable(final Frame frame, GLCapabilities gLCapabilities, int n, int n2) throws InterruptedException, InvocationTargetException {
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable;
        if (gLCapabilities.isOnscreen()) {
            GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)gLCanvas);
            Dimension dimension = new Dimension(n, n2);
            gLCanvas.setMinimumSize(dimension);
            gLCanvas.setPreferredSize(dimension);
            gLCanvas.setSize(dimension);
            gLOffscreenAutoDrawable = gLCanvas;
            frame.setLayout(new BorderLayout());
            frame.add((Component)gLCanvas, "Center");
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        } else {
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
            gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, n, n2);
            Assert.assertNotNull((Object)gLOffscreenAutoDrawable);
        }
        return gLOffscreenAutoDrawable;
    }

    @Test(timeout=30000L)
    public void testSwitch2AWTGLCanvas2OffscreenGL2ES2() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch02AWT.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testSwitch2AWTGLCanvas2OffscreenImpl(gLCapabilities);
    }

    private void testSwitch2AWTGLCanvas2OffscreenImpl(GLCapabilities gLCapabilities) throws InterruptedException, InvocationTargetException {
        long l;
        GLCapabilities gLCapabilities2 = (GLCapabilities)gLCapabilities.clone();
        gLCapabilities2.setOnscreen(false);
        QuitAdapter quitAdapter = new QuitAdapter();
        final Frame frame = new Frame("Gears AWT Test");
        Assert.assertNotNull((Object)frame);
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter((WindowListener)quitAdapter)).addTo((Component)frame);
        GLAutoDrawable gLAutoDrawable = this.createGLAutoDrawable(frame, gLCapabilities, width, height);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        GearsES2 gearsES2 = new GearsES2(1);
        gLAutoDrawable.addGLEventListener((GLEventListener)gearsES2);
        gLAutoDrawable.addGLEventListener((GLEventListener)snapshotGLEventListener);
        snapshotGLEventListener.setMakeSnapshot();
        Animator animator = new Animator();
        animator.add(gLAutoDrawable);
        animator.start();
        int n = 0;
        long l2 = l = System.currentTimeMillis();
        GLAutoDrawable gLAutoDrawable2 = this.createGLAutoDrawable(null, gLCapabilities2, width, height);
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            if ((l2 - l) / period > (long)n) {
                System.err.println(++n + " - switch - START " + (l2 - l));
                GLDrawableUtil.swapGLContextAndAllGLEventListener((GLAutoDrawable)gLAutoDrawable, (GLAutoDrawable)gLAutoDrawable2);
                snapshotGLEventListener.setMakeSnapshot();
                System.err.println(n + " - switch - END " + (l2 - l));
            }
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        animator.stop();
        gLAutoDrawable2.destroy();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Frame frame2 = frame;
                frame2.dispose();
            }
        });
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (!stringArray[i].equals("-period")) continue;
            ++i;
            try {
                period = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestGLContextDrawableSwitch02AWT.class.getName()});
    }

    static {
        duration = 2900L;
        period = 1000L;
    }
}

