/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestShutdownCompleteNEWT
extends UITestCase {
    static long duration = 300L;
    static boolean initOnly = false;
    static boolean waitForEach = false;

    protected void runTestGL(boolean bl) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
        gLCapabilities.setOnscreen(bl);
        gLCapabilities.setPBuffer(!bl);
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Gears NEWT Test");
        gLWindow.addGLEventListener((GLEventListener)new GearsES2());
        Animator animator = new Animator((GLAutoDrawable)gLWindow);
        gLWindow.setSize(256, 256);
        gLWindow.setVisible(true);
        animator.setUpdateFPSFrames(60, System.err);
        animator.start();
        Assert.assertEquals((Object)true, (Object)animator.isAnimating());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isRealized());
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    protected void oneLife(boolean bl) throws InterruptedException {
        if (waitForEach) {
            TestShutdownCompleteNEWT.waitForEnter();
        }
        long l = System.nanoTime();
        GLProfile.initSingleton();
        long l2 = System.nanoTime();
        if (!initOnly) {
            this.runTestGL(true);
        }
        long l3 = System.nanoTime();
        if (bl) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(null, null, (boolean)false).toString());
        }
        long l4 = System.nanoTime();
        GLProfile.shutdown();
        long l5 = System.nanoTime();
        System.err.println("Total:                          " + (double)(l4 - l) / 1000000.0 + "ms");
        System.err.println("  GLProfile.initSingleton():    " + (double)(l2 - l) / 1000000.0 + "ms");
        System.err.println("  Demo Code:                    " + (double)(l3 - l2) / 1000000.0 + "ms");
        System.err.println("  GLProfile.shutdown():         " + (double)(l5 - l4) / 1000000.0 + "ms");
    }

    @Test
    public void test01OneLife() throws InterruptedException {
        this.oneLife(true);
    }

    @Test
    public void test01AnotherLife() throws InterruptedException {
        this.oneLife(false);
    }

    @Test
    public void test01TwoLifes() throws InterruptedException {
        this.oneLife(false);
        this.oneLife(false);
    }

    static void waitForEnter() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.err.println("Press enter to continue");
        try {
            System.err.println(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-waitForEach")) {
                waitForEach = true;
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-initOnly")) continue;
            initOnly = true;
        }
        if (bl) {
            TestShutdownCompleteNEWT.waitForEnter();
        }
        String string = TestShutdownCompleteNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

