/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextListNEWT2
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLWindow sharedDrawable;
    Gears sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable((String)"GL2")) {
            glp = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull((Object)caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextListNEWT2.setTestSupported(false);
        }
    }

    private void initShared() {
        this.sharedDrawable = GLWindow.create((GLCapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)this.sharedDrawable);
        this.sharedGears = new Gears(0);
        Assert.assertNotNull((Object)this.sharedGears);
        this.sharedDrawable.addGLEventListener((GLEventListener)this.sharedGears);
        this.sharedDrawable.setSize(width, height);
        this.sharedDrawable.setVisible(true);
        this.sharedDrawable.display();
    }

    private void releaseShared() {
        Assert.assertNotNull((Object)this.sharedDrawable);
        this.sharedDrawable.destroy();
        this.sharedDrawable = null;
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)caps);
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedContext(this.sharedDrawable.getContext());
        }
        gLWindow.setSize(width, height);
        Gears gears = new Gears(bl2 ? 1 : 0);
        if (bl) {
            gears.setGears(this.sharedGears.getGear1(), this.sharedGears.getGear2(), this.sharedGears.getGear3());
        }
        gLWindow.addGLEventListener((GLEventListener)gears);
        animator.add((GLAutoDrawable)gLWindow);
        animator.start();
        gLWindow.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(gLWindow, true));
        gLWindow.setPosition(n, n2);
        return gLWindow;
    }

    @Test(timeout=10000L)
    public void test01() throws InterruptedException {
        this.initShared();
        GLWindow gLWindow = this.runTestGL(new Animator(), 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(new Animator(), gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(new Animator(), gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), true, false);
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        this.releaseShared();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestSharedContextListNEWT2.class.getName()});
    }

    static {
        duration = 2000L;
    }
}

