/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.newt.opengl.GLWindow;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Util;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNEWTCloseX11DisplayBug565 {
    @Test
    public void testX11WindowMemoryLeak() throws Exception {
        GLProfile.initSingleton();
        try {
            for (int i = 0; i < 10; ++i) {
                int n;
                int n2 = NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType((boolean)false) ? X11Util.getOpenDisplayConnectionNumber() : 0;
                GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
                GLWindow gLWindow = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
                gLWindow.setTitle("NEWT Resource X11 Leak - #" + i);
                gLWindow.setSize(128, 128);
                gLWindow.setVisible(true);
                gLWindow.display();
                gLWindow.setVisible(false);
                gLWindow.destroy();
                if (NativeWindowFactory.TYPE_X11 != NativeWindowFactory.getNativeWindowType((boolean)false) || (n = X11Util.getOpenDisplayConnectionNumber() - n2) <= 0) continue;
                X11Util.dumpOpenDisplayConnections();
                X11Util.dumpPendingDisplayConnections();
                Assert.assertEquals((String)"New display connection didn't close", (long)0L, (long)n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testX11WindowMemoryLeakGLPbuffer() throws Exception {
        GLProfile.initSingleton();
        try {
            for (int i = 0; i < 10; ++i) {
                int n;
                int n2 = NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType((boolean)false) ? X11Util.getOpenDisplayConnectionNumber() : 0;
                GLProfile gLProfile = GLProfile.getDefault();
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                GLPbuffer gLPbuffer = GLDrawableFactory.getFactory((GLProfile)gLProfile).createGLPbuffer(null, (GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)new DefaultGLCapabilitiesChooser(), 256, 256, null);
                gLPbuffer.display();
                gLPbuffer.destroy();
                if (NativeWindowFactory.TYPE_X11 != NativeWindowFactory.getNativeWindowType((boolean)false) || (n = X11Util.getOpenDisplayConnectionNumber() - n2) <= 0) continue;
                X11Util.dumpOpenDisplayConnections();
                X11Util.dumpPendingDisplayConnections();
                Assert.assertEquals((String)"New display connection didn't close", (long)0L, (long)n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testX11WindowMemoryLeakFBOAutoDrawable() throws Exception {
        GLProfile.initSingleton();
        try {
            for (int i = 0; i < 10; ++i) {
                int n;
                int n2 = NativeWindowFactory.TYPE_X11 == NativeWindowFactory.getNativeWindowType((boolean)false) ? X11Util.getOpenDisplayConnectionNumber() : 0;
                GLProfile gLProfile = GLProfile.getDefault();
                GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
                GLOffscreenAutoDrawable gLOffscreenAutoDrawable = GLDrawableFactory.getFactory((GLProfile)gLProfile).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)new DefaultGLCapabilitiesChooser(), 256, 256);
                gLOffscreenAutoDrawable.display();
                gLOffscreenAutoDrawable.destroy();
                if (NativeWindowFactory.TYPE_X11 != NativeWindowFactory.getNativeWindowType((boolean)false) || (n = X11Util.getOpenDisplayConnectionNumber() - n2) <= 0) continue;
                X11Util.dumpOpenDisplayConnections();
                X11Util.dumpPendingDisplayConnections();
                Assert.assertEquals((String)"New display connection didn't close", (long)0L, (long)n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestNEWTCloseX11DisplayBug565.class.getName()});
    }
}

