/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMapBufferRead01NEWT
extends UITestCase {
    static final boolean DEBUG = false;

    @Test
    public void testWriteRead01a() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2GL3")) {
            System.err.println("Test requires GL2/GL3 profile.");
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(36);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.testWriteRead01(byteBuffer);
    }

    @Test
    public void testWriteRead01b() throws InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2GL3")) {
            System.err.println("Test requires GL2/GL3 profile.");
            return;
        }
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)36);
        this.testWriteRead01(byteBuffer);
    }

    private void testWriteRead01(ByteBuffer byteBuffer) throws InterruptedException {
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createOffscreenWindow(new GLCapabilities(GLProfile.getGL2GL3()), 800, 600, true);
        GL gL = windowContext.context.getGL();
        int[] nArray = new int[1];
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(0.5f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(0.5f);
        byteBuffer.putFloat(-0.5f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(-0.5f);
        byteBuffer.putFloat(-0.5f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.rewind();
        gL.glGenBuffers(1, nArray, 0);
        gL.glBindBuffer(34962, nArray[0]);
        gL.glBufferData(34962, (long)byteBuffer.capacity(), (Buffer)byteBuffer, 35044);
        ByteBuffer byteBuffer2 = gL.glMapBuffer(34962, 35000);
        Assert.assertNotNull((Object)byteBuffer2);
        for (int i = 0; i < byteBuffer2.capacity(); i += 4) {
            Assert.assertEquals((double)byteBuffer.getFloat(i), (double)byteBuffer2.getFloat(i), (double)0.0);
        }
        gL.glUnmapBuffer(34962);
        NEWTGLContext.destroyWindow(windowContext);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestMapBufferRead01NEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

