/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.test.junit.jogl.demos.es2.FBOMix2DemosES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.MultisampleDemoES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFBOAutoDrawableFactoryNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    @Test
    public void testGL2ES2_Demo1_SingleBuffer_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        this.testGLFBODrawableImpl(gLCapabilities, new GearsES2(0));
    }

    @Test
    public void testGL2ES2_Demo1_DoubleBuffer_Normal() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(true);
        this.testGLFBODrawableImpl(gLCapabilities, new GearsES2(0));
    }

    @Test
    public void testGL2ES2_Demo2MSAA4() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, new MultisampleDemoES2(true));
    }

    @Test
    public void testGL2ES2_FBODemoMSAA4() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        FBOMix2DemosES2 fBOMix2DemosES2 = new FBOMix2DemosES2(0);
        fBOMix2DemosES2.setDoRotation(false);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.testGLFBODrawableImpl(gLCapabilities, fBOMix2DemosES2);
    }

    @Test
    public void testEGLES2_Demo0Normal() throws InterruptedException {
        if (GLProfile.isAvailable((String)"GLES2")) {
            GLProfile gLProfile = GLProfile.get((String)"GLES2");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.testGLFBODrawableImpl(gLCapabilities, new GearsES2(0));
        } else {
            System.err.println("EGL ES2 n/a");
        }
    }

    @Test
    public void testEGLES2_Demo0MSAA4() throws InterruptedException {
        if (GLProfile.isAvailable((String)"GLES2")) {
            GLProfile gLProfile = GLProfile.get((String)"GLES2");
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(4);
            this.testGLFBODrawableImpl(gLCapabilities, new GearsES2(0));
        } else {
            System.err.println("EGL ES2 n/a");
        }
    }

    void testGLFBODrawableImpl(GLCapabilities gLCapabilities, GLEventListener gLEventListener) throws InterruptedException {
        FBObject fBObject;
        Object object;
        gLCapabilities.setFBO(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLCapabilities.getGLProfile());
        GLOffscreenAutoDrawable.FBO fBO = (GLOffscreenAutoDrawable.FBO)gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull((Object)fBO);
        System.out.println("Realized GLAD: " + fBO);
        System.out.println("Realized GLAD: " + fBO.getChosenGLCapabilities());
        Assert.assertTrue((String)"FBO drawable is initialized before ctx creation", (!fBO.isInitialized() ? 1 : 0) != 0);
        fBO.display();
        GLContext gLContext = fBO.getContext();
        Assert.assertNotNull((Object)gLContext);
        Assert.assertTrue((boolean)gLContext.isCreated());
        Assert.assertTrue((String)"FBO drawable is not initialized after ctx creation", (boolean)fBO.isInitialized());
        gLContext = fBO.getChosenGLCapabilities();
        System.out.println("Init GLAD: " + fBO);
        System.out.println("Init GLAD: " + gLContext);
        FBObject fBObject2 = fBO.getFBObject(1028);
        FBObject fBObject3 = fBO.getFBObject(1029);
        System.out.println("Init front FBO: " + fBObject2);
        System.out.println("Init back  FBO: " + fBObject3);
        Assert.assertTrue((String)"FBO drawable is not initialized before ctx creation", (boolean)fBO.isInitialized());
        Assert.assertTrue((String)"FBO Front is not initialized before ctx creation", (boolean)fBObject2.isInitialized());
        Assert.assertTrue((String)"FBO Back  is not initialized before ctx creation", (boolean)fBObject3.isInitialized());
        if (gLContext.getDoubleBuffered()) {
            Assert.assertTrue((String)("FBO are equal: " + fBObject2 + " == " + fBObject3), (!fBObject2.equals(fBObject3) ? 1 : 0) != 0);
            Assert.assertNotSame((Object)fBObject2, (Object)fBObject3);
        } else {
            Assert.assertTrue((String)("FBO are not equal: " + fBObject2 + " != " + fBObject3), (boolean)fBObject2.equals(fBObject3));
            Assert.assertSame((Object)fBObject2, (Object)fBObject3);
        }
        FBObject.TextureAttachment textureAttachment = fBO.getTextureBuffer(1028);
        FBObject.TextureAttachment textureAttachment2 = 0 == fBO.getNumSamples() ? fBO.getTextureBuffer(1029) : null;
        FBObject.Colorbuffer colorbuffer = fBObject2.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer);
        FBObject.Colorbuffer colorbuffer2 = fBObject3.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer2);
        FBObject.RenderAttachment renderAttachment = fBObject2.getDepthAttachment();
        Assert.assertNotNull((Object)renderAttachment);
        FBObject.RenderAttachment renderAttachment2 = fBObject3.getDepthAttachment();
        Assert.assertNotNull((Object)renderAttachment2);
        fBO.display();
        if (gLContext.getDoubleBuffered()) {
            Assert.assertTrue((String)("Color attachments are equal: " + colorbuffer2 + " == " + colorbuffer), (!colorbuffer2.equals(colorbuffer) ? 1 : 0) != 0);
            Assert.assertNotSame((Object)colorbuffer2, (Object)colorbuffer);
            Assert.assertTrue((String)("Depth attachments are equal: " + renderAttachment2 + " == " + renderAttachment), (!renderAttachment2.equals((Object)renderAttachment) ? 1 : 0) != 0);
            Assert.assertNotSame((Object)renderAttachment2, (Object)renderAttachment);
        } else {
            Assert.assertEquals((Object)colorbuffer, (Object)colorbuffer2);
            Assert.assertSame((Object)colorbuffer, (Object)colorbuffer2);
            Assert.assertEquals((Object)renderAttachment, (Object)renderAttachment2);
            Assert.assertSame((Object)renderAttachment, (Object)renderAttachment2);
        }
        Assert.assertEquals((Object)textureAttachment, (Object)colorbuffer);
        Assert.assertSame((Object)textureAttachment, (Object)colorbuffer);
        if (0 == fBO.getNumSamples()) {
            Assert.assertEquals((Object)textureAttachment2, (Object)colorbuffer2);
            Assert.assertSame((Object)textureAttachment2, (Object)colorbuffer2);
        }
        if (gLContext.getNumSamples() > 0) {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject2 + " != " + object), (boolean)fBObject2.equals(object));
            Assert.assertSame((Object)fBObject2, (Object)object);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject3 + " != " + fBObject), (boolean)fBObject3.equals(fBObject));
            Assert.assertSame((Object)fBObject3, (Object)fBObject);
        } else if (gLContext.getDoubleBuffered()) {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject3 + " != " + object), (boolean)fBObject3.equals(object));
            Assert.assertSame((Object)fBObject3, (Object)object);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject2 + " != " + fBObject), (boolean)fBObject2.equals(fBObject));
            Assert.assertSame((Object)fBObject2, (Object)fBObject);
        } else {
            object = fBO.getFBObject(1028);
            fBObject = fBO.getFBObject(1029);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject2 + " != " + object), (boolean)fBObject2.equals(object));
            Assert.assertSame((Object)fBObject2, (Object)object);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject3 + " != " + object), (boolean)fBObject3.equals(object));
            Assert.assertSame((Object)fBObject3, (Object)object);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject3 + " != " + fBObject), (boolean)fBObject3.equals(fBObject));
            Assert.assertSame((Object)fBObject3, (Object)fBObject);
            Assert.assertTrue((String)("FBO are not equal: " + fBObject2 + " != " + fBObject), (boolean)fBObject2.equals(fBObject));
            Assert.assertSame((Object)fBObject2, (Object)fBObject);
        }
        fBO.addGLEventListener(gLEventListener);
        object = new UITestCase.SnapshotGLEventListener(this);
        fBO.addGLEventListener((GLEventListener)object);
        fBO.display();
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        this.szStep = 1;
        fBO.setSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getWidth() + "x" + fBO.getHeight()), (boolean)AWTRobotUtil.waitForSize((GLDrawable)fBO, 200 * this.szStep, 150 * this.szStep));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.display();
        fBObject = fBO.getFBObject(1028);
        FBObject fBObject4 = fBO.getFBObject(1029);
        System.out.println("Resize1.oldFront: " + fBObject2);
        System.out.println("Resize1.nowFront: " + fBObject);
        System.out.println("Resize1.oldBack : " + fBObject3);
        System.out.println("Resize1.nowBack : " + fBObject4);
        Assert.assertEquals((Object)fBObject2, (Object)fBObject);
        Assert.assertSame((Object)fBObject2, (Object)fBObject);
        Assert.assertEquals((Object)fBObject3, (Object)fBObject4);
        Assert.assertSame((Object)fBObject3, (Object)fBObject4);
        FBObject.Colorbuffer colorbuffer3 = fBObject.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer3);
        Assert.assertEquals((Object)colorbuffer, (Object)colorbuffer3);
        Assert.assertSame((Object)colorbuffer, (Object)colorbuffer3);
        FBObject.RenderAttachment renderAttachment3 = fBObject.getDepthAttachment();
        System.err.println("Resize1.oldDepth " + renderAttachment);
        System.err.println("Resize1.newDepth " + renderAttachment3);
        Assert.assertNotNull((Object)renderAttachment3);
        Assert.assertEquals((Object)renderAttachment, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment, (Object)renderAttachment3);
        renderAttachment3 = fBObject4.getDepthAttachment();
        Assert.assertNotNull((Object)renderAttachment3);
        Assert.assertEquals((Object)renderAttachment2, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment2, (Object)renderAttachment3);
        colorbuffer3 = fBObject.getColorbuffer(colorbuffer);
        Assert.assertNotNull((Object)colorbuffer3);
        Assert.assertEquals((Object)colorbuffer, (Object)colorbuffer3);
        Assert.assertSame((Object)colorbuffer, (Object)colorbuffer3);
        this.szStep = 4;
        fBO.setSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getWidth() + "x" + fBO.getHeight()), (boolean)AWTRobotUtil.waitForSize((GLDrawable)fBO, 200 * this.szStep, 150 * this.szStep));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.display();
        fBObject = fBO.getFBObject(1028);
        fBObject4 = fBO.getFBObject(1029);
        System.out.println("Resize2.oldFront: " + fBObject2);
        System.out.println("Resize2.nowFront: " + fBObject);
        System.out.println("Resize2.oldBack : " + fBObject3);
        System.out.println("Resize2.nowBack : " + fBObject4);
        if (gLContext.getDoubleBuffered() && 0 == gLContext.getNumSamples()) {
            Assert.assertEquals((Object)fBObject3, (Object)fBObject);
            Assert.assertEquals((Object)fBObject2, (Object)fBObject4);
        } else {
            Assert.assertEquals((Object)fBObject2, (Object)fBObject);
            Assert.assertEquals((Object)fBObject3, (Object)fBObject4);
        }
        colorbuffer3 = fBObject3.getColorbuffer(0);
        Assert.assertNotNull((Object)colorbuffer3);
        Assert.assertEquals((Object)colorbuffer2, (Object)colorbuffer3);
        Assert.assertSame((Object)colorbuffer2, (Object)colorbuffer3);
        renderAttachment3 = fBObject3.getDepthAttachment();
        Assert.assertNotNull((Object)renderAttachment3);
        Assert.assertEquals((Object)renderAttachment2, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment2, (Object)renderAttachment3);
        renderAttachment3 = fBObject2.getDepthAttachment();
        Assert.assertNotNull((Object)renderAttachment3);
        Assert.assertEquals((Object)renderAttachment, (Object)renderAttachment3);
        Assert.assertSame((Object)renderAttachment, (Object)renderAttachment3);
        colorbuffer3 = fBObject3.getColorbuffer(colorbuffer2);
        Assert.assertNotNull((Object)colorbuffer3);
        Assert.assertEquals((Object)colorbuffer2, (Object)colorbuffer3);
        Assert.assertSame((Object)colorbuffer2, (Object)colorbuffer3);
        fBO.setNumSamples(fBO.getGL(), gLContext.getNumSamples() > 0 ? 0 : 4);
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        this.szStep = 3;
        fBO.setSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue((String)("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + fBO.getWidth() + "x" + fBO.getHeight()), (boolean)AWTRobotUtil.waitForSize((GLDrawable)fBO, 200 * this.szStep, 150 * this.szStep));
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        fBO.display();
        fBO.destroy();
        System.out.println("Fin: " + fBO);
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main((String[])new String[]{TestFBOAutoDrawableFactoryNEWT.class.getName()});
    }

    static interface MyGLEventListener
    extends GLEventListener {
        public void setMakeSnapshot();
    }
}

