/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLProfile;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestCPUSourcingAPINEWT
extends UITestCase {
    static long duration = 500L;

    private void testImpl(GLProfile gLProfile) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory((GLProfile)gLProfile);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 512, 512);
        Demo demo = new Demo();
        gLOffscreenAutoDrawable.addGLEventListener((GLEventListener)demo);
        gLOffscreenAutoDrawable.display();
        gLOffscreenAutoDrawable.destroy();
    }

    @Test
    public void test01GL2CPUSource() throws GLException, InterruptedException {
        if (!GLProfile.isAvailable((String)"GL2")) {
            System.err.println("GL2 n/a");
            return;
        }
        this.testImpl(GLProfile.get((String)"GL2"));
    }

    @Test
    public void test02GL3CPUSource() throws GLException, InterruptedException {
        GLProfile gLProfile = GLProfile.getMaxProgrammableCore((boolean)true);
        if (!gLProfile.isGL3ES3() && !gLProfile.isGL2ES2()) {
            System.err.println("No GL core profile available, got " + gLProfile);
            return;
        }
        GLException gLException = null;
        try {
            this.testImpl(gLProfile);
        }
        catch (GLException gLException2) {
            gLException = gLException2;
            System.err.println("Expected Exception: " + gLException.getMessage());
        }
        Assert.assertNotNull((String)"Excpected GLException missing due to CPU Sourcing w/ GL3 core context", (Object)((Object)gLException));
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestCPUSourcingAPINEWT.class.getName()});
    }

    static class Demo
    implements GLEventListener {
        private static final float[] vertexColorData = new float[]{0.0f, 0.75f, 0.0f, 1.0f, 0.0f, 0.0f, -0.5f, -0.75f, 0.0f, 0.0f, 1.0f, 0.0f, 0.9f, -0.75f, 0.0f, 0.0f, 0.0f, 1.0f};
        private final FloatBuffer vertexColorDataBuffer = GLBuffers.newDirectFloatBuffer((float[])vertexColorData);
        private final short[] indices = new short[]{0, 1, 2};
        private final ShortBuffer indicesBuffer = GLBuffers.newDirectShortBuffer((short[])this.indices);
        private int vertID = -1;
        private int fragID = -1;
        private int progID = -1;

        Demo() {
        }

        private static int createShader(GL2ES2 gL2ES2, int n, String[] stringArray) {
            int n2 = gL2ES2.glCreateShader(n);
            assert (n2 > 0);
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = stringArray[i].length();
            }
            gL2ES2.glShaderSource(n2, stringArray.length, stringArray, nArray, 0);
            gL2ES2.glCompileShader(n2);
            return n2;
        }

        private void initShaders(GL2ES2 gL2ES2) {
            String[] stringArray = new String[]{"#version 150\n", "in vec4 vPosition;\n", "in vec4 vColor;\n", "out vec4 pColor;\n", "void main() {\n", "    pColor       = vColor;\n", "    gl_Position = vPosition;\n", "}\n"};
            this.vertID = Demo.createShader(gL2ES2, 35633, stringArray);
            String[] stringArray2 = new String[]{"#version 150\n", "in vec4 pColor;\n", "void main() {\n", "    gl_FragColor = pColor;\n", "}\n"};
            this.fragID = Demo.createShader(gL2ES2, 35632, stringArray2);
            gL2ES2.glReleaseShaderCompiler();
            this.progID = gL2ES2.glCreateProgram();
            assert (this.progID > 0);
            gL2ES2.glAttachShader(this.progID, this.vertID);
            gL2ES2.glAttachShader(this.progID, this.fragID);
            gL2ES2.glLinkProgram(this.progID);
            gL2ES2.glValidateProgram(this.progID);
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glEnable(2929);
            gL2ES2.glDisable(2884);
            this.initShaders(gL2ES2);
            gL2ES2.setSwapInterval(1);
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glDetachShader(this.progID, this.fragID);
            gL2ES2.glDetachShader(this.progID, this.vertID);
            gL2ES2.glDeleteProgram(this.progID);
            gL2ES2.glDeleteShader(this.fragID);
            gL2ES2.glDeleteShader(this.vertID);
        }

        private void displayCPUSourcing(GL2 gL2) {
            int n = gL2.glGetAttribLocation(this.progID, "vPosition");
            int n2 = gL2.glGetAttribLocation(this.progID, "vColor");
            gL2.glEnableVertexAttribArray(n);
            gL2.glEnableVertexAttribArray(n2);
            gL2.glVertexAttribPointer(n, 3, 5126, false, 24, (Buffer)this.vertexColorDataBuffer);
            this.vertexColorDataBuffer.position(3);
            gL2.glVertexAttribPointer(n2, 3, 5126, false, 24, (Buffer)this.vertexColorDataBuffer);
            this.vertexColorDataBuffer.position(0);
            gL2.glDrawElements(4, 3, 5123, (Buffer)this.indicesBuffer);
            gL2.glDisableVertexAttribArray(n);
            gL2.glDisableVertexAttribArray(n2);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            gL2ES2.glClearColor(68.0f, 68.0f, 68.0f, 0.0f);
            gL2ES2.glClear(16640);
            gL2ES2.glUseProgram(this.progID);
            this.displayCPUSourcing((GL2)gL2ES2);
            gL2ES2.glUseProgram(0);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }
    }
}

