/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAddRemove01GLCanvasSwingAWT
extends UITestCase {
    static long durationPerTest = 100L;
    static int addRemoveCount = 15;
    static int pauseEach = 0;
    static int pauseDuration = 500;
    static boolean noOnscreenTest = false;
    static boolean noOffscreenTest = false;
    static boolean offscreenPBufferOnly = false;
    static boolean offscreenFBOOnly = false;
    static GLProfile glpGL2;
    static GLProfile glpGL2ES2;
    static int width;
    static int height;
    static boolean waitForKey;
    static boolean waitForKeyPost;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        if (GLProfile.isAvailable((String)"GL2ES2")) {
            glpGL2ES2 = GLProfile.get((String)"GL2ES2");
            Assert.assertNotNull((Object)glpGL2ES2);
        }
        if (GLProfile.isAvailable((String)"GL2")) {
            glpGL2 = GLProfile.get((String)"GL2");
            Assert.assertNotNull((Object)glpGL2);
        }
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected JPanel create(final JFrame[] jFrameArray, final int n, final int n2, final int n3) throws InterruptedException, InvocationTargetException {
        final JPanel[] jPanelArray = new JPanel[]{null};
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jPanelArray[0] = new JPanel();
                jPanelArray[0].setLayout(new BorderLayout());
                JFrame jFrame = new JFrame("JFrame #" + n3);
                jFrame.setDefaultCloseOperation(0);
                jFrame.getContentPane().add(jPanelArray[0]);
                jFrame.setSize(n, n2);
                jFrameArray[0] = jFrame;
            }
        });
        return jPanelArray[0];
    }

    protected void add(final Container container, final Component component) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                container.add(component, "Center");
            }
        });
    }

    protected void dispose(final GLCanvas gLCanvas) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                gLCanvas.destroy();
            }
        });
    }

    protected void setVisible(final JFrame jFrame, final boolean bl) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    jFrame.pack();
                    jFrame.validate();
                }
                jFrame.setVisible(bl);
            }
        });
    }

    protected void dispose(final JFrame jFrame) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.dispose();
            }
        });
    }

    protected void runTestGL(boolean bl, GLCapabilities gLCapabilities, int n) throws AWTException, InterruptedException, InvocationTargetException {
        if (waitForKey) {
            UITestCase.waitForKey("Start");
        }
        for (int i = 0; i < n; ++i) {
            System.err.println("Loop # " + i + " / " + addRemoveCount);
            GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            Assert.assertNotNull((Object)gLCanvas);
            if (!bl) {
                gLCanvas.setShallUseOffscreenLayer(true);
            }
            Dimension dimension = new Dimension(width, height);
            gLCanvas.setMinimumSize(dimension);
            gLCanvas.setPreferredSize(dimension);
            gLCanvas.setSize(dimension);
            GearsES2 gearsES2 = new GearsES2(1);
            gearsES2.setVerbose(false);
            gLCanvas.addGLEventListener((GLEventListener)gearsES2);
            JFrame[] jFrameArray = new JFrame[]{null};
            JPanel jPanel = this.create(jFrameArray, width, height, i);
            this.add(jPanel, (Component)gLCanvas);
            this.setVisible(jFrameArray[0], true);
            long l = System.currentTimeMillis();
            do {
                gLCanvas.display();
                Thread.sleep(10L);
            } while (System.currentTimeMillis() - l < durationPerTest);
            System.err.println("GLCanvas isOffscreenLayerSurfaceEnabled: " + gLCanvas.isOffscreenLayerSurfaceEnabled() + ": " + gLCanvas.getChosenGLCapabilities());
            this.dispose(jFrameArray[0]);
            if (0 >= pauseEach || 0 != i % pauseEach) continue;
            System.err.println("******* P A U S E - Start ********");
            Thread.sleep(pauseDuration);
            System.err.println("******* P A U S E - End ********");
        }
        if (waitForKeyPost) {
            UITestCase.waitForKey("End");
        }
    }

    @Test
    public void test01Onscreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (noOnscreenTest || JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("No onscreen test requested or platform doesn't support onscreen rendering.");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(glpGL2ES2);
        this.runTestGL(true, gLCapabilities, addRemoveCount);
    }

    @Test
    public void test02OffscreenFBO() throws AWTException, InterruptedException, InvocationTargetException {
        if (noOffscreenTest || !JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("No offscreen test requested or platform doesn't support offscreen rendering.");
            return;
        }
        if (offscreenPBufferOnly) {
            System.err.println("Only PBuffer test is requested.");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(glpGL2ES2);
        if (offscreenPBufferOnly) {
            gLCapabilities.setPBuffer(true);
            gLCapabilities.setOnscreen(true);
        }
        this.runTestGL(false, gLCapabilities, addRemoveCount);
    }

    @Test
    public void test03OffscreenPBuffer() throws AWTException, InterruptedException, InvocationTargetException {
        if (noOffscreenTest || !JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("No offscreen test requested or platform doesn't support offscreen rendering.");
            return;
        }
        if (offscreenFBOOnly) {
            System.err.println("Only FBO test is requested.");
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(glpGL2);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setOnscreen(true);
        this.runTestGL(false, gLCapabilities, addRemoveCount);
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    durationPerTest = Long.parseLong(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-loops")) {
                addRemoveCount = MiscUtils.atoi(stringArray[++i], addRemoveCount);
                continue;
            }
            if (stringArray[i].equals("-pauseEach")) {
                pauseEach = MiscUtils.atoi(stringArray[++i], pauseEach);
                continue;
            }
            if (stringArray[i].equals("-pauseDuration")) {
                pauseDuration = MiscUtils.atoi(stringArray[++i], pauseDuration);
                continue;
            }
            if (stringArray[i].equals("-noOnscreen")) {
                noOnscreenTest = true;
                continue;
            }
            if (stringArray[i].equals("-noOffscreen")) {
                noOffscreenTest = true;
                continue;
            }
            if (stringArray[i].equals("-layeredFBO")) {
                offscreenFBOOnly = true;
                continue;
            }
            if (stringArray[i].equals("-layeredPBuffer")) {
                offscreenPBufferOnly = true;
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                waitForKey = true;
                continue;
            }
            if (!stringArray[i].equals("-waitPost")) continue;
            waitForKeyPost = true;
        }
        System.err.println("waitForKey                    " + waitForKey);
        System.err.println("waitForKeyPost                " + waitForKeyPost);
        System.err.println("addRemoveCount                " + addRemoveCount);
        System.err.println("pauseEach                     " + pauseEach);
        System.err.println("pauseDuration                 " + pauseDuration);
        System.err.println("noOnscreenTest                " + noOnscreenTest);
        System.err.println("noOffscreenTest               " + noOffscreenTest);
        System.err.println("offscreenPBufferOnly          " + offscreenPBufferOnly);
        System.err.println("offscreenFBOOnly              " + offscreenFBOOnly);
        JUnitCore.main((String[])new String[]{TestAddRemove01GLCanvasSwingAWT.class.getName()});
    }

    static {
        waitForKey = false;
        waitForKeyPost = false;
    }
}

