/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos;

import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.graph.geom.opengl.SVertex;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.test.junit.graph.demos.ui.Label;
import com.jogamp.opengl.test.junit.graph.demos.ui.RIButton;
import com.jogamp.opengl.test.junit.graph.demos.ui.SceneUIController;
import com.jogamp.opengl.test.junit.graph.demos.ui.opengl.UIRegion;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.IOException;
import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLRunnable;

public class GPUUISceneGLListener0A
implements GLEventListener {
    private boolean debug = false;
    private boolean trace = false;
    private final int renderModes;
    private final int[] texSize = new int[1];
    private final int renderModes2;
    private final int[] texSize2 = new int[1];
    private RegionRenderer regionRenderer;
    private RenderState rs;
    int fontSet = 0;
    Font font;
    final int fontSizeFixed = 6;
    private float xTran = 0.0f;
    private float yTran = 0.0f;
    private float ang = 0.0f;
    private float zoom = -200.0f;
    private float zoomText = 1.0f;
    private int currentText = 0;
    private Label[] labels = null;
    private String[] strings = null;
    private UIRegion[] labelRegions;
    private UIRegion fpsRegion = null;
    private UIRegion jogampRegion = null;
    private RIButton[] buttons = null;
    private int numSelectable = 6;
    private SceneUIController sceneUIController = null;
    private MultiTouchListener multiTouchListener = null;
    private boolean showFPS = false;
    private GLAutoDrawable cDrawable;
    private float fps = 0.0f;
    private String jogamp = "JogAmp - Jogl Graph Module Demo";
    private float angText = 0.0f;

    public GPUUISceneGLListener0A() {
        this(0);
    }

    public GPUUISceneGLListener0A(int n) {
        this(RenderState.createRenderState((ShaderState)new ShaderState(), (Vertex.Factory)SVertex.factory()), n, false, false);
    }

    public GPUUISceneGLListener0A(RenderState renderState, int n, boolean bl, boolean bl2) {
        this.rs = renderState;
        this.renderModes = n;
        this.texSize[0] = Region.isVBAA((int)n) ? 400 : 0;
        this.renderModes2 = 0;
        this.texSize2[0] = 0;
        this.debug = bl;
        this.trace = bl2;
        try {
            this.font = FontFactory.get((int)0).getDefault();
        }
        catch (IOException iOException) {
            System.err.println("Catched: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        this.labelRegions = new UIRegion[3];
        this.sceneUIController = new SceneUIController();
    }

    private void initButtons(int n, int n2) {
        this.buttons = new RIButton[this.numSelectable];
        int n3 = -110;
        float f = 40.0f;
        float f2 = 16.0f;
        int n4 = 50;
        int n5 = (int)f2 + 5;
        this.buttons[0] = new RIButton((Vertex.Factory)SVertex.factory(), this.font, "Next Text", f, f2){

            @Override
            public void onClick() {
                GPUUISceneGLListener0A.this.currentText = (GPUUISceneGLListener0A.this.currentText + 1) % 3;
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.buttons[0].setPosition(n3, n4, 0.0f);
        this.buttons[1] = new RIButton((Vertex.Factory)SVertex.factory(), this.font, "Show FPS", f, f2){

            @Override
            public void onClick() {
                GLAnimatorControl gLAnimatorControl = GPUUISceneGLListener0A.this.cDrawable.getAnimator();
                if (null != gLAnimatorControl) {
                    gLAnimatorControl.resetFPSCounter();
                }
                GPUUISceneGLListener0A.this.showFPS = !GPUUISceneGLListener0A.this.showFPS;
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.buttons[1].setPosition(n3, n4 - n5, 0.0f);
        this.buttons[1].setToggleable(true);
        this.buttons[2] = new RIButton((Vertex.Factory)SVertex.factory(), this.font, "v-sync", f, f2){

            @Override
            public void onClick() {
                GPUUISceneGLListener0A.this.cDrawable.invoke(false, new GLRunnable(){

                    public boolean run(GLAutoDrawable gLAutoDrawable) {
                        GL gL;
                        gL.setSwapInterval((gL = gLAutoDrawable.getGL()).getSwapInterval() <= 0 ? 1 : 0);
                        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                        if (null != gLAnimatorControl) {
                            gLAnimatorControl.resetFPSCounter();
                        }
                        return true;
                    }
                });
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.buttons[2].setPosition(n3, n4 - n5 * 2, 0.0f);
        this.buttons[2].setToggleable(true);
        this.buttons[3] = new RIButton((Vertex.Factory)SVertex.factory(), this.font, "Tilt  +Y", f, f2){

            @Override
            public void onClick() {
                GPUUISceneGLListener0A.this.ang += 10.0f;
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.buttons[3].setPosition(n3, n4 - n5 * 3, 0.0f);
        this.buttons[4] = new RIButton((Vertex.Factory)SVertex.factory(), this.font, "Tilt  -Y", f, f2){

            @Override
            public void onClick() {
                GPUUISceneGLListener0A.this.ang -= 10.0f;
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.buttons[4].setPosition(n3, n4 - n5 * 4, 0.0f);
        this.buttons[5] = new RIButton((Vertex.Factory)SVertex.factory(), this.font, "Quit", f, f2){

            @Override
            public void onClick() {
                GPUUISceneGLListener0A.this.cDrawable.destroy();
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.buttons[5].setPosition(n3, n4 - n5 * 5, 0.0f);
        this.buttons[5].setButtonColor(0.8f, 0.0f, 0.0f);
        this.buttons[5].setLabelColor(1.0f, 1.0f, 1.0f);
        this.buttons[5].setButtonSelectedColor(0.8f, 0.8f, 0.8f);
        this.buttons[5].setLabelSelectedColor(0.8f, 0.0f, 0.0f);
    }

    private void initTexts() {
        this.strings = new String[3];
        this.strings[0] = "abcdefghijklmn\nopqrstuvwxyz\nABCDEFGHIJKL\nMNOPQRSTUVWXYZ\n0123456789.:,;(*!?/\\\")$%^&-+@~#<>{}[]";
        this.strings[1] = "The quick brown fox\njumps over the lazy\ndog";
        this.strings[2] = "Lorem ipsum dolor sit amet, consectetur\nUt purus odio, rhoncus sit amet com\nquam iaculis urna cursus ornare. Nullam\nIn hac habitasse platea dictumst. Vivam\nMorbi quis bibendum nibh. Donec lectus\nDonec ut dolor et nulla tristique variu\nin lorem. Maecenas in ipsum ac justo sc\n";
        this.labels = new Label[3];
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("GPUUISceneGLListener0A: init (1)");
            GLWindow gLWindow = (GLWindow)gLAutoDrawable;
            this.attachInputListenerTo(gLWindow);
        } else {
            System.err.println("GPUUISceneGLListener0A: init (0)");
        }
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        this.cDrawable = gLAutoDrawable;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Debug", null, (GL)gL2ES2, null)).getGL2ES2();
        }
        if (this.trace) {
            gL2ES2 = gL2ES2.getContext().setGL(GLPipelineFactory.create((String)"javax.media.opengl.Trace", null, (GL)gL2ES2, (Object[])new Object[]{System.err})).getGL2ES2();
        }
        try {
            this.font = FontFactory.get((int)this.fontSet).getDefault();
        }
        catch (IOException iOException) {
            System.err.println("Catched: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        this.regionRenderer = RegionRenderer.create((RenderState)this.rs, (int)this.renderModes);
        gL2ES2.glEnable(2929);
        gL2ES2.glEnable(3042);
        this.regionRenderer.init(gL2ES2);
        this.regionRenderer.setAlpha(gL2ES2, 1.0f);
        this.regionRenderer.setColorStatic(gL2ES2, 0.0f, 0.0f, 0.0f);
        this.initTexts();
        this.initButtons(n, n2);
        this.sceneUIController.setRenderer(this.regionRenderer, this.rs, this.renderModes, this.texSize);
        this.sceneUIController.addShape(this.buttons[0]);
        this.sceneUIController.addShape(this.buttons[1]);
        this.sceneUIController.addShape(this.buttons[2]);
        this.sceneUIController.addShape(this.buttons[3]);
        this.sceneUIController.addShape(this.buttons[4]);
        this.sceneUIController.addShape(this.buttons[5]);
        gLAutoDrawable.addGLEventListener((GLEventListener)this.sceneUIController);
        Label label = new Label((Vertex.Factory)SVertex.factory(), this.font, 6, this.jogamp){

            @Override
            public void onClick() {
            }

            @Override
            public void onPressed() {
            }

            @Override
            public void onRelease() {
            }
        };
        this.jogampRegion = new UIRegion(label);
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        if (null != gLAnimatorControl) {
            gLAnimatorControl.resetFPSCounter();
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GLWindow gLWindow;
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("GPUUISceneGLListener0A: dispose (1)");
            gLWindow = (GLWindow)gLAutoDrawable;
            this.detachInputListenerFrom(gLWindow);
        } else {
            System.err.println("GPUUISceneGLListener0A: dispose (0)");
        }
        gLWindow = gLAutoDrawable.getGL().getGL2ES2();
        this.regionRenderer.destroy((GL2ES2)gLWindow);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        int n = gLAutoDrawable.getWidth();
        int n2 = gLAutoDrawable.getHeight();
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        gL2ES2.glClear(16640);
        this.regionRenderer.reshapePerspective(null, 45.0f, n, n2, 0.1f, 7000.0f);
        this.sceneUIController.setTranslate(this.xTran, this.yTran, this.zoom);
        this.sceneUIController.setRotation(0.0f, this.ang, 0.0f);
        this.renderScene(gLAutoDrawable);
    }

    private void renderScene(GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.regionRenderer.resetModelview(null);
        this.regionRenderer.translate(null, this.xTran - 50.0f, this.yTran + 43.0f, this.zoom);
        this.regionRenderer.translate(gL2ES2, 0.0f, 30.0f, 0.0f);
        this.regionRenderer.scale(null, this.zoomText, this.zoomText, 1.0f);
        this.regionRenderer.scale(gL2ES2, 1.5f, 1.5f, 1.0f);
        this.regionRenderer.rotate(gL2ES2, this.angText, 0.0f, 1.0f, 0.0f);
        this.regionRenderer.setColorStatic(gL2ES2, 0.0f, 1.0f, 0.0f);
        this.regionRenderer.draw(gL2ES2, (Region)this.jogampRegion.getRegion(gL2ES2, this.rs, 0), new float[]{0.0f, 0.0f, 0.0f}, null);
        if (null == this.labelRegions[this.currentText]) {
            if (null == this.labels[this.currentText]) {
                this.labels[this.currentText] = new Label((Vertex.Factory)SVertex.factory(), this.font, 6, this.strings[this.currentText]){

                    @Override
                    public void onClick() {
                    }

                    @Override
                    public void onPressed() {
                    }

                    @Override
                    public void onRelease() {
                    }
                };
            }
            this.labelRegions[this.currentText] = new UIRegion(this.labels[this.currentText]);
        }
        this.regionRenderer.resetModelview(null);
        this.regionRenderer.translate(null, this.xTran - 50.0f, this.yTran, this.zoom);
        this.regionRenderer.translate(gL2ES2, 0.0f, 30.0f, 0.0f);
        this.regionRenderer.scale(null, this.zoomText, this.zoomText, 1.0f);
        this.regionRenderer.scale(gL2ES2, 1.5f, 1.5f, 1.0f);
        this.regionRenderer.rotate(gL2ES2, this.zoomText, 0.0f, 1.0f, 0.0f);
        this.regionRenderer.setColorStatic(gL2ES2, 0.0f, 0.0f, 0.0f);
        this.regionRenderer.draw(gL2ES2, (Region)this.labelRegions[this.currentText].getRegion(gL2ES2, this.rs, this.renderModes2), new float[]{0.0f, 0.0f, 0.0f}, this.texSize2);
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        boolean bl2 = bl = this.showFPS && null != gLAnimatorControl;
        if (bl && this.fps != gLAnimatorControl.getTotalFPS()) {
            if (null != this.fpsRegion) {
                this.fpsRegion.destroy(gL2ES2, this.rs);
            }
            this.fps = gLAnimatorControl.getTotalFPS();
            String string = String.valueOf(this.fps);
            int n = string.indexOf(46);
            Label label = new Label((Vertex.Factory)SVertex.factory(), this.font, 6, string.substring(0, n + 2) + " fps"){

                @Override
                public void onClick() {
                }

                @Override
                public void onPressed() {
                }

                @Override
                public void onRelease() {
                }
            };
            this.fpsRegion = new UIRegion(label);
        }
        if (this.showFPS && null != this.fpsRegion) {
            this.regionRenderer.translate(gL2ES2, 0.0f, -60.0f, 0.0f);
            this.regionRenderer.scale(null, this.zoomText, this.zoomText, 1.0f);
            this.regionRenderer.draw(gL2ES2, (Region)this.fpsRegion.getRegion(gL2ES2, this.rs, 0), new float[]{0.0f, 0.0f, 0.0f}, null);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.err.println("GPUUISceneGLListener0A: reshape");
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        gL2ES2.glViewport(n, n2, n3, n4);
        this.regionRenderer.reshapePerspective(gL2ES2, 45.0f, n3, n4, 5.0f, 70.0f);
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (null == this.multiTouchListener) {
            this.multiTouchListener = new MultiTouchListener();
            gLWindow.addMouseListener((MouseListener)this.multiTouchListener);
            this.sceneUIController.attachInputListenerTo(gLWindow);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (null != this.multiTouchListener) {
            gLWindow.removeMouseListener((MouseListener)this.multiTouchListener);
            this.sceneUIController.detachInputListenerFrom(gLWindow);
        }
    }

    private class MultiTouchListener
    extends MouseAdapter {
        int lx = 0;
        int ly = 0;
        boolean first = false;

        private MultiTouchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.first = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.first = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            System.err.println("demo:mousedragged " + mouseEvent);
            if (mouseEvent.getPointerCount() == 2) {
                if (this.first) {
                    this.lx = Math.abs(mouseEvent.getY(0) - mouseEvent.getY(1));
                    this.first = false;
                    return;
                }
                int n = Math.abs(mouseEvent.getY(0) - mouseEvent.getY(1));
                int n2 = n - this.lx;
                GPUUISceneGLListener0A.this.zoom += 2.0f * Math.signum(n2);
                this.lx = n;
            } else {
                if (this.first) {
                    this.lx = mouseEvent.getX();
                    this.ly = mouseEvent.getY();
                    this.first = false;
                    return;
                }
                int n = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                int n4 = n - this.lx;
                int n5 = n3 - this.ly;
                if (Math.abs(n4) > Math.abs(n5)) {
                    GPUUISceneGLListener0A.this.xTran += Math.signum(n4);
                } else {
                    GPUUISceneGLListener0A.this.yTran -= Math.signum(n5);
                }
                this.lx = n;
                this.ly = n3;
            }
        }

        public void mouseWheelMoved(MouseEvent mouseEvent) {
            if (!mouseEvent.isShiftDown()) {
                GPUUISceneGLListener0A.this.zoom += 2.0f * mouseEvent.getRotation()[1];
            }
        }
    }
}

