uniform float pulse;
uniform float size;

uniform mat4 iMVMatrix;

varying vec3 v_wPosition;
varying vec3 v_Position;
varying vec3 v_normal;
varying vec4 v_color;

uniform vec3 lightPosition = vec3(5.,5.,5.);
uniform vec4 lightAmbiant = vec4(0.1,0.1,0.1,1.0);
vec4 lightDiffuse = vec4(0.1,0.1,0.1,1.0);

void main (void)
{
    vec3 ray = normalize(lightPosition - v_wPosition.xyz);
    vec3 eye = normalize((vec4(-v_Position,1)).xyz);
    float angle = dot(v_normal,ray);

    vec3 specularColour = vec3(0.f,0.f,0.f);
    if ( angle > 0 )
    {
        vec3 raySpec = normalize(reflect(-ray,v_normal));
        specularColour = pow(max(0.f,dot(raySpec,eye)),128.0f) * vec3(1.0f,1.0f,1.0f);
        gl_FragColor = v_color + angle * lightDiffuse + lightAmbiant + vec4(specularColour,1.0f);
    }
    else
    {
        gl_FragColor = lightAmbiant + v_color;
    }

    // gl_FragColor = vec4(v_normal.x,0.0,size,1.0);
    // gl_FragColor = vec4(v_normal,1.0);
}
