(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 8;
	scene.scene = new THREE.Scene();
	
	var camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 1000),
		geometry = new THREE.CubeGeometry(100, 100, 100),
		material = new THREE.MeshPhongMaterial({
			color: 0xffffff,
			wireframe: false,
			opacity: .7,
			wireframeLinewidth: 2
		}),
		light = new THREE.PointLight(0xffffff, 1, 2000),
		light2 = new THREE.AmbientLight(0x8844ff),
		meshArray = [];
	
	// Create instances
	for(var z = -5; z < 5; z++){
		for(var y = -5; y < 5; y++){
			for(var x = -5; x < 5; x++){
				var instance = new THREE.Mesh(geometry, material);
				instance.position.x = x * 240;
				instance.position.y = y * 240;
				instance.position.z = z * 240;
				
				instance.rotation.x = x;
				instance.rotation.y = y;
				instance.rotation.z = z;
				
				/*
				instance.castShadow = true;
				instance.receiveShadow = true;
				*/
				
				meshArray.push(instance);
				scene.scene.add(instance);
			}
		}
	}
	
	
	camera.position.z = 230;
	scene.camera = camera;
	
	/*
	light.castShadow = true;
	
	light.shadowCameraNear = 300;
	light.shadowCameraFar = camera.far;
	light.shadowCameraFov = 50;
	
	light.shadowBias = -0.00022;
	light.shadowDarkness = 0.9;
	
	light.shadowMapWidth = 1024;
	light.shadowMapHeight = 1024;
	*/
	
	scene.scene.add(camera);
	scene.scene.add(light);
	scene.scene.add(light2);
	
	scene.update = function(){
		var sceneTime = (this.demo.timing.elapsed - this.startTime);
		
		light.position.x = Math.sin(sceneTime / 1400) * 400;
		light.position.y = Math.sin(sceneTime / 2400) * 400;
		light.position.z = Math.sin(sceneTime / 800) * 200;
		
		/*
		camera.position.z = Math.cos(sceneTime / 1200) * 800 * Math.sin(sceneTime / 2800);
		camera.position.x = Math.sin(sceneTime / 800) * 800 * Math.sin(sceneTime / 3800);
		*/
		
		camera.position.x = light.position.x;
		camera.position.z = light.position.z;
		
		camera.position.y = 300;
		
		camera.rotation.x = -20 + Math.sin(sceneTime / 1800) * 0.82;
		camera.rotation.z = Math.sin(sceneTime / 800) * 0.42;
		
		for(var i = meshArray.length; i--;){
			meshArray[i].scale.y = 1 + Math.sin((sceneTime + i * 40) / 460) * 0.4;
		}
	};
	
	demo.pushScene(scene);
})(demo);