(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 16;
	scene.scene = new THREE.Scene();
	
	var camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 1000),
		geometry = new THREE.CylinderGeometry(25, 75, 100, 10, 1),
		material = demo.cache.get('material', 'phong_white'),
		mesh = new THREE.Mesh(geometry, material),
		light = new THREE.PointLight(0xffffff, 1, 1000),
		light2 = new THREE.AmbientLight(0x110022),
		meshArray = [];
	
	
	demo.cache.set('geometry', 'cylinder100', geometry);
	demo.cache.set('mesh', 'cylinder100_phong_white', mesh);
	
	for(var z = -10; z < 10; z++){
		for(var x = -10; x < 10; x++){
			var instance = new THREE.Mesh(geometry, material);
			instance.position.x = x * 75;
			instance.position.z = z * 75;
			
			meshArray.push(instance);
			scene.scene.add(instance);
		}
	}
	
	
	camera.position.z = 230;
	camera.position.y = 400;
	camera.rotation.x = -90;
	scene.camera = camera;
	
	light.position.set(0, -50, 250);
	
	
	scene.scene.add(camera);
	scene.scene.add(light);
	scene.scene.add(light2);
	
	scene.update = function(){
		var sceneTime = (this.demo.timing.elapsed - this.startTime);
		
		if(sceneTime < this.demo.timing.barDuration * 8){
			camera.rotation.z = Math.sin(sceneTime / 800) * 0.42;
			
			for(var i = meshArray.length; i--;){
				meshArray[i].scale.y = 2 + Math.sin((sceneTime + i * 40) / 460) * 1.8;
			}
		}
		else{
			camera.rotation.z = 3.1 + Math.sin(sceneTime / 400) * Math.cos(sceneTime / 600) * 1.82;
			
			for(var i = meshArray.length; i--;){
				meshArray[i].scale.y = 3 + Math.sin((sceneTime + i * 40) / 200) * 2.8;
			}
		}
	};
	
	demo.pushScene(scene);
})(demo);