(function(demo){
	var scene = new DemoScene(demo);
	
	scene.duration = 8;
	scene.scene = new THREE.Scene();
	
	var camera = new THREE.PerspectiveCamera(85, demo.settings.viewport.aspect, 1, 1000),
		geometry = new THREE.CubeGeometry(200, 200, 200),
		material = new THREE.MeshPhongMaterial(
			{
				color: 0xffffff,
				wireframe: false
			}),
		mesh = new THREE.Mesh(geometry, material),
		light = new THREE.PointLight(0xffffff, 1, 1000),
		light2 = new THREE.AmbientLight(0x110022);
	
	
	demo.cache.set('geometry', 'cube200', geometry);
	demo.cache.set('material', 'phong_white', material);
	demo.cache.set('mesh', 'cube200_phong_white', mesh);
	
	
	camera.position.z = 230;
	scene.camera = camera;
	
	light.position.set(0, -50, 250);
	
	
	scene.scene.add(camera);
	scene.scene.add(mesh);
	scene.scene.add(light);
	scene.scene.add(light2);
	
	scene.update = function(){
		mesh.rotation.x = demo.timing.elapsed / 20 * 0.01;
		mesh.rotation.y = demo.timing.elapsed / 120 * 0.02;
	};
	
	demo.pushScene(scene);
})(demo);