; A demo for Vammala Party 2012
; - Marq

	cpu 6800
	* = $1000

BIGLEN	equ	68*8
MAXX	equ	4

; *** Setup ***

; Kill key beep just in case

	clra		; System variable
	stab	$0

	sei

	ldaa	#$01
	eora	$C803
	staa	$C803
	oraa	#$03
	anda	#$3F
	staa    $C803

	cli

; Clear to black
	clra
	ldab	#0
	ldx	#$c500
klr	staa	,x
	inx
	staa	,x
	inx
	staa	,x
	inx
	decb
	bne	klr

; Two rows of red fg attribute we must catch
	ldaa	#2
	ldab	#64
	ldx	#$c500+32*21

reddi	staa	,x
	inx
	decb
	bne	reddi

; Set fast timer interrupt for searching the red rows
	ldab	#0
	stab	$c817
	ldab	#8
	stab	$c818

	ldx	#search
	sei
	stx	$104
	cli

; Wait until vbi found
goon	ldaa	found
	beq	goon

; BG colors
	ldaa	#2*8+0
	clrb
	ldx	#$c500
restore	staa	,x
	inx
	staa	,x
	inx
	staa	,x
	inx
	decb
	bne	restore

; Nuke bg bitmap
	ldx	#$d000+96*8
	ldaa	#255
	ldab	#32
nukeb	staa	,x
	inx
	decb
	bne	nukeb

; Set up bg pattern nametable, 4 chars starting from 96

	ldx	#$c100
	bsr	nameset
	bsr	nameset
	bsr	nameset
	bsr	nameset

	bsr	nameset
	bsr	nameset
	bsr	nameset
	bsr	nameset

	bsr	nameset
	bsr	nameset
	bsr	nameset
	bsr	nameset

	jmp	sitte

nameset	ldab	#16
namese1	ldaa	#96
	staa	,x
	inx
	ldaa	#98
	staa	,x
	inx
	decb
	bne	namese1

	ldab	#16
namese2	ldaa	#97
	staa	,x
	inx
	ldaa	#99
	staa	,x
	inx
	decb
	bne	namese2

	rts

; Set up small scrollers

sitte	clra
	ldx	#$c100+32*2
	bsr	oner
	bsr	oner
	bsr	oner
	ldaa	#32
	bsr	oner
	clra
	bsr	oner

	clra
	ldx	#$c100+32*18
	bsr	oner
	bsr	oner
	bsr	oner
	ldaa	#32
	bsr	oner
	clra
	bsr	oner

	bra	dones

oner	ldab	#32
rowwi	staa	,x
	inx
	inca
	decb
	bne	rowwi
	rts

; Clear the bitmap

dones	clrb
	ldx	#$d000
	clra

killbit	staa	,x
	inx
	staa	,x
	inx
	staa	,x
	inx
	decb
	bne	killbit

; Small scroll colors
	ldaa	#2
	ldx	#$c500+32*2
	bsr	onec
	ldaa	#6
	bsr	onec
	ldaa	#7
	bsr	onec
	ldaa	#6
	bsr	onec
	ldaa	#2
	bsr	onec

	ldaa	#2
	ldx	#$c500+32*18
	bsr	onec
	ldaa	#6
	bsr	onec
	ldaa	#7
	bsr	onec
	ldaa	#6
	bsr	onec
	ldaa	#2
	bsr	onec

	bra	main

onec	ldab	#32
rowwi2	staa	,x
	inx
	decb
	bne	rowwi2
	rts

; Main loop
main	nop
	clra
	staa	$ca00

	ldaa	vbicnt ; Wait for the next VBI
waitvbi	cmpa	vbicnt
	beq	waitvbi

	ldx	bgstrt
	beq	bakkis
	dex
	stx	bgstrt

	jmp	sml1

; BG pattern
bakkis	ldx	patti
	ldx	,x
	bne	nopatti

	ldx	#patit
	stx	patti
	ldx	,x

nopatti	sei
	sts	tmps
	stx	sorsa
	lds	sorsa
	des
	ldx	#$d000+96*8

	ldab	#8
pattcp	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx

	decb
	bne	pattcp

	lds	tmps
	cli

	ldx	patti
	inx
	inx
	stx	patti

; Advance small scroller 1
sml1	ldx	krol1
	ldx	,x
	bne	noad1

	ldx	#phaset
	stx	krol1
	ldx	krol1+2
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	stx	krol1+2
	ldx	krol1
	ldx	,x

	inc	krol1+4
	ldaa	krol1+4
	cmpa	#42
	bne	noad1

	clr	krol1+4
	ldx	#0
	stx	krol1+2
	ldx	krol1
	ldx	,x

noad1	stx	sorsa
	ldaa	krol1+2
	ldab	krol1+3
	addb	sorsa+1
	adca	sorsa
	staa	sorsa
	stab	sorsa+1

	ldx	krol1
	inx
	inx
	stx	krol1
	ldx	#$d000
	jsr	cpy256

;	ldaa	#2
;	staa	$ca00

; Advance small scroller 2
	ldx	krol2
	ldx	,x
	bne	noad2

	ldx	#phaset
	stx	krol2
	ldx	krol2+2
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	stx	krol2+2
	ldx	krol2
	ldx	,x

	inc	krol2+4
	ldaa	krol2+4
	cmpa	#42
	bne	noad2

	clr	krol2+4
	ldx	#0
	stx	krol2+2
	ldx	krol2
	ldx	,x

noad2	stx	sorsa
	ldaa	krol2+2
	ldab	krol2+3
	addb	sorsa+1
	adca	sorsa
	staa	sorsa
	stab	sorsa+1

	ldx	krol2
	inx
	inx
	inx
	inx
	stx	krol2
	ldx	#$d000+32*8
	jsr	cpy256

;	ldaa	#3
;	staa	$ca00

; Next up the BIG scroller

	ldx	bigstrt
	beq	bigok
	dex
	stx	bigstrt

	ldab	#160 ; For the timing :(
wenaa	nop
	nop
	nop
	nop
	nop
	nop
	decb
	bne	wenaa

	jmp	bigdone

bigok	ldx	bigit+0
	stx	sorsa
	inx
	stx	bigit+0
	ldx	#$c500+32*9
	jsr	bigc

	ldx	bigit+2
	stx	sorsa
	inx
	stx	bigit+2
	ldx	#$c500+32*10
	jsr	bigc

	ldx	bigit+4
	stx	sorsa
	inx
	stx	bigit+4
	ldx	#$c500+32*11
	jsr	bigc

	ldx	bigit+6
	stx	sorsa
	inx
	stx	bigit+6
	ldx	#$c500+32*12
	jsr	bigc

	ldx	bigit+8
	stx	sorsa
	inx
	stx	bigit+8
	ldx	#$c500+32*13
	bsr	bigc

	ldx	bigit+10
	stx	sorsa
	inx
	stx	bigit+10
	ldx	#$c500+32*14
	bsr	bigc

	ldx	bigit+12
	stx	sorsa
	inx
	stx	bigit+12
	ldx	#$c500+32*15
	bsr	bigc

	ldx	bigcnt
	dex
	stx	bigcnt
	bne	bigdone

	ldx	#BIGLEN
	stx	bigcnt
	ldx	#big0
	stx	bigit+0
	ldx	#big1
	stx	bigit+2
	ldx	#big2
	stx	bigit+4
	ldx	#big3
	stx	bigit+6
	ldx	#big4
	stx	bigit+8
	ldx	#big5
	stx	bigit+10
	ldx	#big6
	stx	bigit+12

	bra	bigdone

bigc	sei
	sts	tmps
	lds	sorsa
	des

	ldab	#8
bigk	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	decb
	bne	bigk

	lds	tmps
	cli
	rts

bigdone	nop
;	ldaa	#5
;	staa	$ca00

; Advance small scroller 3
	ldx	krol3
	ldx	,x
	bne	noad3

	ldx	#phaset
	stx	krol3
	ldx	krol3+2
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	stx	krol3+2
	ldx	krol3
	ldx	,x

	inc	krol3+4
	ldaa	krol3+4
	cmpa	#42
	bne	noad3

	clr	krol3+4
	ldx	#0
	stx	krol3+2
	ldx	krol3
	ldx	,x

noad3	stx	sorsa
	ldaa	krol3+2
	ldab	krol3+3
	addb	sorsa+1
	adca	sorsa
	staa	sorsa
	stab	sorsa+1

	ldx	krol3
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	stx	krol3
	ldx	#$d000+64*8
	jsr	cpy256

;	ldaa	#1
;	staa	$ca00
	jsr	playa

	jmp	main

; Copy block function. b x 7 bytes from sorsa to x, skip every 8th byte
cpy256	ldab	#32
cpyblk	sei
	sts	tmps
	lds	sorsa
	des

cpylp	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	pula
	staa	,x
	inx
	inx
	decb
	bne	cpylp

	lds	tmps
	cli
	rts

; Search interrupt hook
search	ldaa	$ca00 ; First wait for two red attributes
	nop
	cmpa	#2
	bne	skippa

	ldaa	$ca00
	nop
	cmpa	#2
	bne	skippa

	ldaa	$ca00 ; Finally one black attribute
	bne	skippa

	ldab	#0 ; Next interrupt a bit further
	stab	$c817
	ldab	#190
	stab	$c818

	ldx	#handu
	sei
	stx	$10c
	ldx	#0
	stx	$104
	cli
	ldaa	#1
	staa	found

skippa	staa	$ca00
	jmp	$e7e7 ; Jump to system IRQ handler

; The actual VBI handler (user timer hook)
handu	ldaa	adjust
	deca
	beq	yesadj

	ldab	#13	; Slower timer for three frames
	stab	$c817
	ldab	#86
	stab	$c818
	bra	done

yesadj	ldab	#13	; Faster for one frame to keep the sync
	stab	$c817
	ldab	#85
	stab	$c818
	ldaa	#MAXX

done	staa	adjust

	inc	vbicnt

;	clra
;	staa	$ca00

	rts

; Player code
; *** The music player starts here ***
playa	dec	count
	beq	newrow
	jmp	norow

; A new row! Need to do several things
newrow	inc	row
	ldaa	row
	cmpa	#64
	bne	nopatt

; A new pattern! Gosh!
	clra
	staa	row
	ldx	pos
	inx
	inx
	stx	pos
	ldx	,x
	bne	loadptr

; Need to jump to the repeat point
	ldx	repeat
	stx	pos
	ldx	,x

loadptr	stx	rowptr
	bra	notes

nopatt	ldx	rowptr ; Next row
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	inx
	stx	rowptr

; Handle new notes and once-per-row commands
; 1st channel
notes	ldx	rowptr
	ldaa	,x
	beq	nonote1
	staa	note1
	staa	base1

nonote1	ldaa	1,x
	beq	arp1
	cmpa	#$c
	beq	vol1
	cmpa	#$f
	beq	spd1
	cmpa	#$1d
	beq	trm1
	bra	chn2

trm1	ldaa	base1
	staa	note1
	bra	chn2

vol1	clra
	staa	note1
	bra	chn2

spd1	ldab	2,x
	stab	speed
	bra	chn2

arp1	ldab	2,x
	beq	chn2
	ldaa	base1
	staa	note1

; 2nd channel
chn2	ldaa	3,x
	beq	nonote2
	staa	note2
	staa	base2

nonote2	ldaa	4,x
	beq	arp2
	cmpa	#$c
	beq	vol2
	cmpa	#$f
	beq	spd2
	cmpa	#$1d
	beq	trm2
	bra	chn3

trm2	ldaa	base2
	staa	note2
	bra	chn3

vol2	clra
	staa	note2
	ldaa	#255
	staa	prev2
	bra	chn3

spd2	ldab	5,x
	stab	speed
	bra	chn3

arp2	ldab	5,x
	beq	chn3
	ldaa	base2
	staa	note2

; 3rd channel
chn3	ldaa	6,x
	beq	nonote3
	staa	note3
	staa	base3

nonote3	ldaa	7,x
	beq	arp3
	cmpa	#$c
	beq	vol3
	cmpa	#$f
	beq	spd3
	cmpa	#$1d
	beq	trm3
	bra	rowdone

trm3	ldaa	base3
	staa	note3
	bra	rowdone

vol3	clra
	staa	note3
	ldaa	#255
	staa	prev3
	bra	rowdone

spd3	ldab	8,x
	stab	speed
	bra	rowdone

arp3	ldab	8,x
	beq	rowdone
	ldaa	base3
	staa	note3

rowdone	ldaa	speed	; Reset tick counter
	staa	count

	clra		; Clear arpeggio and termor pos
	staa	arpc1
	staa	arpc2
	staa	arpc3

	staa	trmc1
	staa	trmc2
	staa	trmc3

	bra	getout

; No new row this time, just check the necessary commands
norow	ldx	rowptr

; 1st channel fx (just arpeggio and tremor for now)
fx1	ldaa	1,x
	cmpa	#$1d
	beq	trem1
	cmpa	#0
	bne	fx2
	ldaa	2,x
	beq	fx2
	ldx	#arpc1
	bsr	arppi
	bra	fx2

trem1	ldaa	2,x
	ldx	#trmc1
	bsr	tremmi

fx2	ldaa	4,x
	cmpa	#$1d
	beq	trem2
	cmpa	#0
	bne	fx3
	ldaa	5,x
	beq	fx3
	ldx	#arpc2
	bsr	arppi
	bra	fx3

trem2	ldaa	5,x
	ldx	#trmc2
	bsr	tremmi

fx3	ldaa	7,x
	cmpa	#$1d
	beq	trem3
	cmpa	#0
	bne	getout
	ldaa	8,x
	beq	getout
	ldx	#arpc3
	bsr	arppi
	bra	getout

trem3	ldaa	8,x
	ldx	#trmc3
	bsr	tremmi

getout	bsr	setfreq
	rts

; Take care of the arpeggio notes (X=counter address, A=param)
arppi	rts
	inc	,x
	ldab	,x
	cmpb	#1
	beq	param1
	cmpb	#2
	beq	param2

	clrb ; Bare note, copy base to current
	stab	,x
	ldaa	3,x
	staa	6,x
	rts

param1	lsra ; High 4 bits = plus to base
	lsra
	lsra
	lsra
	adda	3,x
	staa	6,x
	rts

param2	anda	#15 ; Low bits = plus to base
	adda	3,x
	staa	6,x
	rts

; Take care of the tremor buzz (X=counter address, A=param)
tremmi	inc	,x
	tab
	lsrb
	lsrb
	lsrb
	lsrb
	cmpb	,x	; Note still on
	bpl	trdone

	anda	#15
	aba
	clrb		; Silence
	stab	9,x

	cmpa	,x	; Wrap the counter
	bpl	trout

	ldaa	#-1
	staa	,x
	rts

trdone	ldaa	6,x
	staa	9,x
trout	rts

; Routine to set the freqs of all channels
setfreq	ldaa	note1 ; Channel 1
	beq	silent1

	cmpa	prev1 ; Don't retrig
	beq	freq2
	staa	prev1

	asla
	staa	tmp+1
	ldx	tmp
	ldaa	,x
	staa	$c81a
	ldaa	1,x
	staa	$c81b
	ldaa	#$e
	staa	$c819
	bra	freq2

silent1	clra
	staa	$c819
	staa	prev1

freq2	ldaa	note2 ; Don't retrig, channel 2
	cmpa	prev2
	beq	freq3
	staa	prev2

	asla
	staa	tmp2+1
	ldx	tmp2
	ldaa	,x
	staa	$c813
	ldaa	1,x
	staa	$c812

freq3	ldaa	note3 ; Don't retrig, channel 3
	cmpa	prev3
	beq	frdone
	staa	prev3

	asla
	staa	tmp2+1
	ldx	tmp2
	ldaa	,x
	staa	$c815
	ldaa	1,x
	staa	$c814

frdone	rts

vbicnt	db	0
adjust	db	MAXX
found	db	0
tmps	dw	0
sorsa	dw	0

krol1	dw	phaset
	dw	0
	db	0
krol2	dw	phaset
	dw	0
	db	0
krol3	dw	phaset
	dw	0
	db	0

phaset	dw	phase0,phase1,phase2,phase3, phase4,phase5,phase6,phase7,0

patti	dw	patit

bigit	dw	big0,big1,big2,big3,big4,big5,big6
bigcnt	dw	BIGLEN

bigstrt	dw	64*10+4*64*5	; Delay fx this much before starting
bgstrt	dw	64*10

; Player variables
row	db	63
rowptr	dw	0
count	db	1
speed	db	6
pos	dw	order-2

tmp	dw	frequs ; For indexing the 256-aligned arrays
tmp2	dw	frequs2

trmc1	db	0 ; Tremor counters
trmc2	db	0
trmc3	db	0

arpc1	db	0 ; Arpeggio counters
arpc2	db	0
arpc3	db	0

base1	db	0 ; Base note for arpeggios
base2	db	0
base3	db	0

note1	db	0 ; Current note
note2	db	0
note3	db	0

prev1	db	0 ; Previous played note so that we don't retrig all the time
prev2	db	0
prev3	db	0

include	skrolli.inc
include	ipanomaa.inc
include frequs.inc

endi	db	0 ; End marker
