alias demo_12 {
    ;; starfield
    var %cnt 1
    var %t $hget(demo, part_12_starfade)
    while (%cnt <= %t) {
        var %r $rand(50,255)
        drawdot -nr @demo.5 $rgb(%r,%r,%r) $rand(1, 2) $rand(320, 340) $rand(0, 180)
        inc %cnt
    }
    if (512 // %c) {
        if (%t < 4) {
            hinc demo part_12_starfade
        }
    }
    drawcopy -n @demo.5 20 0 320 180 @demo 0 0 320 180
    drawscroll -n @demo.5 -5 0 20 0 320 180
    drawrect -nrf @demo.5 0 0 320 0 20 180
    ;; dycp
    var %text Welcome to another Digital Sounds System production, presented to you at tUM'12... This one is called "Monochrome"... .. . What you are seeing here is a small effort of a few days... .. . Code by Knoeki and music by Xiny6581... .. . Not much else to say right now, so let's fire off some greetings... ..
    var %tot $len(%text)
    var %xmain $hget(demo, part_12_txt_x)
    var %cnt $hget(demo, part_12_txt_offset)
    var %ktab $hget(demo, part_12_ctab)
    var %kc $hget(demo, part_12_ctab_c)
    var %k $gettok(%ktab, %kc, 32)
    while (%cnt <= %tot) {
        var %x $calc(%xmain + (%cnt * 22))
        if (%x < 320) {
            if (%x > -15) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawtext -nr @demo %k fixedsys 24 %x $calc(($cos($calc($calc(%c * 4) + (%cnt * 16))).deg * 32) + ($cos(%c).deg * 10) + 78) %chr
                }
            }
            else {
                hinc demo part_12_txt_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    if (2 // %c) {
        if (%kc >= 28) {
            hadd demo part_12_ctab_c 0
        }
    }
    hinc demo part_12_ctab_c
    hdec demo part_12_txt_x 2
    ;; rasterbars
    var %cnt 1
    var %ctab 4934475 9868950 14803425 9868950 4934475
    var %fade $hget(demo, part_12_barfade)
    while (%cnt <= 5) {
        drawline -nr @demo $gettok(%ctab, %cnt, 32) 1 0 $calc(($cos(%c).deg * 16) + (30 + %cnt)) $calc(0 + %fade) $calc(($sin(%c).deg * 16) + (30 + %cnt))
        drawline -nr @demo $gettok(%ctab, %cnt, 32) 1 $calc(320 - %fade) $calc(($cos(%c).deg * 16) + (150 + %cnt)) 320 $calc(($sin(%c).deg * 16) + (150 + %cnt))
        inc %cnt
    }
    if (%fade < 320) {
        hinc demo part_12_barfade 4
    }
    if ($insong(%dm.music).pos < 56899) {
        noop $dmDrawFrame(demo_12)
    }
    else {
        demo_13
        return
    }
}

alias demo_13 {
    drawrect -nrfi @demo 13158600 0 0 0 320 180
    ;; dycp
    var %text : :: ::: Rift : Trilobit : TRSi : 3LN : Plush : K2 : Farbrausch : Guideline : Mercury : Dekadence : RNO : Brainstorm : Razor 1911 : Approximate : Panda Design : SCS*TRC : Focus : Benediction : Offence : Attentionwhore : Kewlers : Darklite : PWP : TEK : Bauknecht : Resource : JAC! : HOOY-PROGRAM ::: :: :
    var %tot $len(%text)
    var %xmain $hget(demo, part_13_txt_x)
    var %cnt $hget(demo, part_13_txt_offset)
    var %y $calc(($cos($calc(%c * 4)).deg * 32) + ($cos(%c).deg * 32) + 78)
    while (%cnt <= %tot) {
        var %x $calc(%xmain + (%cnt * 22))
        if (%x < 320) {
            if (%x > -15) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawtext -nr @demo 13158600 fixedsys 24 %x %y %chr
                }
            }
            else {
                hinc demo part_13_txt_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    hdec demo part_13_txt_x 4
    ;; chessboard
    var %sc $hget(demo, part_13_scroll_c)
    var %y 0
    var %x 0
    var %xs 0
    while (%y < 200) {
        var %x %xs
        while (%x <= 340) {
            drawrect -nrfi @demo 3289650 0 $calc(%x - %sc) $calc(%y - %sc) 48 48
            inc %x 96
        }
        inc %y 48
        var %xs $iif(%xs == 0, 48, 0)
    }
    if (%sc == 48) {
        hadd demo part_13_scroll_c -1
    }
    hinc demo part_13_scroll_c 1
    if ($insong(%dm.music).pos > 83377) {
        hinc demo part_13_fade 1.5
        drawrect -nrf @demo 0 0 0 0 320 $hget(demo, part_13_fade)
    }
    if ($insong(%dm.music).pos < 85342) {
        noop $dmDrawFrame(demo_13)
    }
    else {
        demo_14
        return
    }
}

alias demo_14 {
    ;; bobs
    var %c2 $calc(%c * 2)
    var %cnt 1
    var %t $hget(demo, part_14_bob_c)
    while (%cnt <= %t) {
        var %x $calc(($cos($calc(%c2 + (%cnt * (360 / (%t + 32))))).deg * ($sin(%c).deg * 128)) + 160)
        var %y $calc(($sin($calc(%c2 + (%cnt * (360 / (%t + 32))))).deg * ($cos(%c).deg * 88)) + 90)
        drawdot -nri @demo 0 $calc(($cos($calc(%c2 + (%cnt * 4))).deg * 2) + 6) %x %y
        inc %cnt
    }
    if (%t < 32) {
        hinc demo part_14_bob_c .05
    }
    drawrect -nrif @demo 0 0 $calc(($cos(%c).deg * 96) + 160) 0 320 180
    if ($insong(%dm.music).pos < 99601) {
        noop $dmDrawFrame(demo_14)
    }
    else {
        demo_15
        return
    }
}


alias demo_15 {
    ;; starfield
    var %cnt 1
    var %t $hget(demo, part_15_starfade)
    while (%cnt <= %t) {
        var %r $rand(50,255)
        drawdot -nr @demo.5 $rgb(%r,%r,%r) $rand(1, 2) $rand(320, 340) $rand(0, 180)
        inc %cnt
    }
    if (512 // %c) {
        if (%t < 4) {
            hinc demo part_15_starfade
        }
    }
    drawcopy -n @demo.5 20 0 320 180 @demo 0 0 320 180
    drawscroll -n @demo.5 -5 0 20 0 320 180
    drawrect -nrf @demo.5 0 0 320 0 20 180
    ;; dycp
    var %text Don't worry... We've got something much better in the works for mIRC for next year's Revision... .. . these are just some throwaway routines... .. . Speaking of which... can you guess what's coming next???
    var %tot $len(%text)
    var %xmain $hget(demo, part_15_txt_x)
    var %cnt $hget(demo, part_15_txt_offset)
    var %ktab $hget(demo, part_15_ctab)
    var %kc $hget(demo, part_15_ctab_c)
    var %k $gettok(%ktab, %kc, 32)
    while (%cnt <= %tot) {
        var %x $calc(%xmain + (%cnt * 22))
        if (%x < 320) {
            if (%x > -15) {
                var %chr $right($left(%text, %cnt), 1)
                if (%chr != $chr(32)) {
                    drawtext -nr @demo %k fixedsys 24 %x $calc(($cos($calc($calc(%c * 4) + (%cnt * 16))).deg * 32) + ($cos(%c).deg * 10) + 78) %chr
                }
            }
            else {
                hinc demo part_15_txt_offset
            }
        }
        else {
            break
        }
        inc %cnt
    }
    if (2 // %c) {
        if (%kc >= 28) {
            hadd demo part_15_ctab_c 0
        }
    }
    hinc demo part_15_ctab_c
    hdec demo part_15_txt_x 2
    ;; rasterbars
    var %cnt 1
    var %ctab 4934475 9868950 14803425 9868950 4934475
    var %fade $hget(demo, part_15_barfade)
    while (%cnt <= 5) {
        drawline -nr @demo $gettok(%ctab, %cnt, 32) 1 0 $calc(($cos(%c).deg * 16) + (30 + %cnt)) $calc(0 + %fade) $calc(($sin(%c).deg * 16) + (30 + %cnt))
        drawline -nr @demo $gettok(%ctab, %cnt, 32) 1 $calc(320 - %fade) $calc(($cos(%c).deg * 16) + (150 + %cnt)) 320 $calc(($sin(%c).deg * 16) + (150 + %cnt))
        inc %cnt
    }
    if (%fade < 320) {
        hinc demo part_15_barfade 4
    }
    if ($insong(%dm.music).pos < 142281) {
        noop $dmDrawFrame(demo_15)
    }
    else {
        demo_16
        return
    }
}

alias demo_16 {
    var %cnt 1
    var %c2 = %c * 2
    var %c3 = %c * 1.5
    var %x1 $calc(($cos(%c2).deg * (($sin(%c3).deg * 64) + 32)) + 160)
    var %y1 $calc(($sin($calc(%c2 + 180)).deg * (($sin(%c3).deg * 64) + 32)) + 90)
    var %x2 $calc(($cos($calc(%c2 + 180)).deg * (($cos(%c3).deg * 64) + 32)) + 160)
    var %y2 $calc(($sin(%c2).deg * (($cos(%c3).deg * 64) + 32)) + 90)
    while (%cnt <= 32) {
        drawdot -nri @demo 3289650 $calc(%cnt * 8) %x1 %y1
        drawdot -nri @demo 4934475 $calc(%cnt * 8) %x2 %y2
        inc %cnt
    }
    if ($insong(%dm.music).pos > 156521) {
        var %sin $calc(($sin(%c).deg * 64) + 69)
        var %cos $calc(($cos(%c).deg * 32) + 90)
        drawtext -nro @demo 0 "Lucida Console" 20 64 $calc(%cos + 2) LDA / STA / THC
        drawtext -nro @demo 16777215 "Lucida Console" 20 62 %cos LDA / STA / THC
        drawtext -nro @demo 0 "Lucida Console" 20 25 $calc(%sin + 2) Digital Sounds System
        drawtext -nro @demo 16777215 "Lucida Console" 20 23 %sin Digital Sounds System
    }
    noop $dmDrawFrame(demo_16)
}

alias dmDrawFrame {
    ;drawtext -nrb @demo 16777215 0 console 8 0 0 fps: %#
    inc %c
    if ((%% == %$) || ($ticks >= %!)) {
        set %! $calc($ticks + 1000)
        set %# %%
        set %% 0
    }
    drawdot @demo
    if (%dm.fullscreen == 1) {
        drawcopy @demo 0 0 320 180 @demo2 0 0 %dm.fs.w %dm.fs.h
    }
    drawrect -nrf @demo 0 0 0 0 320 180
    inc %%
    .timerdmDrawFrame -mh 1 $calc(%$ - ($ticks - %+)) noop $!dmStartDraw( $1 )
}

alias dmStartDraw {
    set %+ %- | $1
}

alias dmInit {
    var %win $1
    var %params $2-
    window -dak0pfBbo +d $1 $2-
    if (%dm.fullscreen == 1) {
        if ($window(@demo2) == $null) {
            set %dm.fs.w $window(-1).w
            set %dm.fs.h $window(-1).h
            window -dak0pfBbo +d @demo2 -1 -1 %dm.fs.w %dm.fs.h
        }
    }
    set %dm.cs_w $gettok($2, 3, 32)
    set %dm.cs_h $gettok($2, 4, 32)
    set %dm.center_x $calc(%dm.cs_w / 2)
    set %dm.center_y $calc(%dm.cs_h / 2)
    set %- 0
    ;; Configure demo system below. If you don't know what's what, don't touch it.
    ;; dm.ticks
    set %!       %-
    ;; dm.fps
    set %#         0
    ;; dm.fps_target
    set %$  50
    ;; dm.fps_count
    set %%   %$
    ;; dm.frt_count
    set %&   1000
    ;; dm.frt_target
    set %'  $calc(1000 / %$)
    ;; dm.frt_start
    set %+   %-
    ;; dm.c
    set %c           1
    ;; end of configuration
}

alias monochrome {
    unset %dm.fullscreen
    if ($1 == fs) {
        set %dm.fullscreen 1
    }
    noop $dmInit(@demo, 0 0 320 180)
    if ($hget(demo) != $null) {
        hfree demo
    }
    hmake demo 20
    ;;-- init
    if ($window(@precalc) != $null) {
        window -c @precalc
    }
    ;; This is a quick and dirty hack to make sure the background
    ;; of some animations are the proper colour, by forcing mIRC's
    ;; window background colour to be black. A proper solution will
    ;; probably be implemented at some point when I can be arsed.
    color background 1
    window -lh @precalc
    filter -fw $qt($scriptdirprecalc.dss) @precalc
    hadd demo preclc_cnt 1
    hadd demo preclc_tot $line(@precalc, 0)
    hadd demo preclc_ctab 1118481 2236962 3355443 4473924 5592405 6710886 7829367 $&
    8947848 10066329 11184810 12303291 13421772 14540253 15658734 16777215 15658734 $&
    14540253 13421772 12303291 11184810 10066329 8947848 7829367 6710886 5592405 $&
    4473924 3355443 2236962
    hadd demo preclc_cfc 1
    hadd demo preclc_part $iif($1, $1, 001)
    hadd demo preclc_fc 1
    init_new
    ;$+(demo_part_,$1,_init) | $+(demo_part_,$1)
}

alias init_new {
    drawrect -nrf @demo 0 0 1 0 0 %dm.cs_w %dm.cs_h
    var %read $($line(@precalc, $hget(demo, preclc_cnt)), 2)
    %read
    :error
    hinc demo preclc_cnt
    var %pct $calc(($hget(demo, preclc_cnt) / $hget(demo, preclc_tot)) * 100)
    var %w $calc($+(0.,$iif(%pct < 10, $+(0,%pct), %pct)) * 320)
    drawpic -nsc @demo 0 0 %w 180 0 0 %w 180 $qt($scriptdirimg\progbar.gif)
    drawreplace -nr @demo 16777215 $gettok($hget(demo, preclc_ctab), $hget(demo, preclc_cfc), 32)
    if ($hget(demo, preclc_cfc) < $numtok($hget(demo, preclc_ctab), 32)) {
        hinc demo preclc_cfc 0.5
    }
    else {
        hadd demo preclc_cfc 1
    }
    var %frame $hget(demo, preclc_fc)
    drawpic -ncsm @demo 0 100 96 96 $qt($+($scriptdirimg\pinkie1\,%frame,.png))
    if (%frame == 12) {
        hadd demo preclc_fc 1
    }
    if (6 // $hget(demo, preclc_cnt)) {
        hinc demo preclc_fc
    }
    ;;
    drawdot @demo
    if (%dm.fullscreen == 1) {
        drawcopy @demo 0 0 %dm.cs_w %dm.cs_h @demo2 0 0 %dm.fs.w %dm.fs.h
    }
    if ($hget(demo, preclc_cnt) > $hget(demo, preclc_tot)) {
        drawpic -c
        set %dm.music $scriptdirExtremly_Cheese.mp3
        splay -w $qt(%dm.music)
        demo_12
        return
    }
    else {
        .timer -mh 1 0 init_new
    }
}


on *:KEYDOWN:@demo:32: {
    echo -a $insong(%dm.music).pos
}

on *:CLOSE:@demo,@demo2: {
    splay stop
}