/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.textfield;

import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;

public class TextFieldInputMapping
implements NiftyInputMapping {
    public NiftyInputEvent convert(KeyboardInputEvent inputEvent) {
        if (inputEvent.isKeyDown()) {
            return this.handleKeyDownEvent(inputEvent);
        }
        return this.handleKeyUpEvent(inputEvent);
    }

    private NiftyInputEvent handleKeyDownEvent(KeyboardInputEvent inputEvent) {
        if (inputEvent.getKey() == 200) {
            return NiftyInputEvent.MoveCursorUp;
        }
        if (inputEvent.getKey() == 208) {
            return NiftyInputEvent.MoveCursorDown;
        }
        if (inputEvent.getKey() == 203) {
            return NiftyInputEvent.MoveCursorLeft;
        }
        if (inputEvent.getKey() == 59) {
            return NiftyInputEvent.ConsoleToggle;
        }
        if (inputEvent.getKey() == 205) {
            return NiftyInputEvent.MoveCursorRight;
        }
        if (inputEvent.getKey() == 28) {
            return NiftyInputEvent.SubmitText;
        }
        if (inputEvent.getKey() == 211) {
            return NiftyInputEvent.Delete;
        }
        if (inputEvent.getKey() == 14) {
            return NiftyInputEvent.Backspace;
        }
        if (inputEvent.getKey() == 207) {
            return NiftyInputEvent.MoveCursorToLastPosition;
        }
        if (inputEvent.getKey() == 199) {
            return NiftyInputEvent.MoveCursorToFirstPosition;
        }
        if (inputEvent.getKey() == 42 || inputEvent.getKey() == 54) {
            return NiftyInputEvent.SelectionStart;
        }
        if (inputEvent.getKey() == 15) {
            if (inputEvent.isShiftDown()) {
                return NiftyInputEvent.PrevInputElement;
            }
            return NiftyInputEvent.NextInputElement;
        }
        if (!Character.isISOControl(inputEvent.getCharacter())) {
            NiftyInputEvent character = NiftyInputEvent.Character;
            character.setCharacter(inputEvent.getCharacter());
            return character;
        }
        if (inputEvent.isControlDown()) {
            if (inputEvent.getKey() == 45) {
                return NiftyInputEvent.Cut;
            }
            if (inputEvent.getKey() == 46) {
                return NiftyInputEvent.Copy;
            }
            if (inputEvent.getKey() == 47) {
                return NiftyInputEvent.Paste;
            }
            if (inputEvent.getKey() == 30) {
                return NiftyInputEvent.SelectAll;
            }
        }
        return null;
    }

    private NiftyInputEvent handleKeyUpEvent(KeyboardInputEvent inputEvent) {
        if (inputEvent.getKey() == 42 || inputEvent.getKey() == 54) {
            return NiftyInputEvent.SelectionEnd;
        }
        if (inputEvent.getKey() == 1) {
            return NiftyInputEvent.Escape;
        }
        return null;
    }
}

