/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.listbox.ListBoxImpl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class ListBoxPanel<T>
extends AbstractController {
    private Screen screen;
    private Element element;
    private FocusHandler focusHandler;
    private ListBoxImpl<T> listBox;
    private boolean hasFocus = false;

    public void bind(Nifty niftyParam, Screen screenParam, Element elementParam, Properties parameter, Attributes controlDefinitionAttributes) {
        this.screen = screenParam;
        this.element = elementParam;
        this.focusHandler = this.screen.getFocusHandler();
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        int focusItemIndex;
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            if (this.focusHandler != null) {
                Element nextElement = this.focusHandler.getNext(this.element);
                nextElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.PrevInputElement) {
            if (this.focusHandler != null) {
                Element prevElement = this.focusHandler.getPrev(this.element);
                prevElement.setFocus();
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorDown) {
            int focusItemIndex2;
            if (this.hasElements() && (focusItemIndex2 = this.listBox.getFocusItemIndex()) < this.listBox.itemCount() - 1) {
                this.listBox.setFocusItemByIndex(focusItemIndex2 + 1);
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.MoveCursorUp) {
            int focusItemIndex3;
            if (this.hasElements() && (focusItemIndex3 = this.listBox.getFocusItemIndex()) > 0) {
                this.listBox.setFocusItemByIndex(focusItemIndex3 - 1);
                return true;
            }
        } else if (inputEvent == NiftyInputEvent.Activate && this.hasElements() && (focusItemIndex = this.listBox.getFocusItemIndex()) >= 0) {
            if (this.listBox.getSelection().contains(this.listBox.getFocusItem())) {
                this.listBox.deselectItemByIndex(focusItemIndex);
            } else {
                this.listBox.selectItemByIndex(focusItemIndex);
            }
        }
        return false;
    }

    private boolean hasElements() {
        return this.listBox.itemCount() > 0;
    }

    public void onFocus(boolean getFocus) {
        super.onFocus(getFocus);
        this.hasFocus = getFocus;
        this.listBox.updateView();
    }

    public void setListBox(ListBoxImpl<T> listBox) {
        this.listBox = listBox;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }
}

